/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.ssl.SslFilter;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.CompositeIoFilterChainBuilder;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AcceptorIoHandler;
import quickfix.mina.acceptor.AcceptorSessionProvider;
import quickfix.mina.message.FIXProtocolCodecFactory;
import quickfix.mina.ssl.SSLConfig;
import quickfix.mina.ssl.SSLContextFactory;
import quickfix.mina.ssl.SSLSupport;

public abstract class AbstractSocketAcceptor
extends SessionConnector
implements Acceptor {
    private final Map<SocketAddress, AcceptorSessionProvider> sessionProviders = new HashMap<SocketAddress, AcceptorSessionProvider>();
    private final SessionFactory sessionFactory;
    private final Map<SocketAddress, AcceptorSocketDescriptor> socketDescriptorForAddress = new HashMap<SocketAddress, AcceptorSocketDescriptor>();
    private final ConcurrentMap<AcceptorSocketDescriptor, IoAcceptor> ioAcceptors = new ConcurrentHashMap<AcceptorSocketDescriptor, IoAcceptor>();

    protected AbstractSocketAcceptor(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        super(settings, sessionFactory);
        IoBuffer.setAllocator(new SimpleBufferAllocator());
        IoBuffer.setUseDirectBuffer(false);
        this.sessionFactory = sessionFactory;
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        this(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected synchronized void startAcceptingConnections() throws ConfigError {
        boolean continueInitOnError = this.isContinueInitOnError();
        this.createSessions(this.getSettings(), continueInitOnError);
        this.startSessionTimer();
        SocketAddress address = null;
        for (AcceptorSocketDescriptor socketDescriptor : this.socketDescriptorForAddress.values()) {
            try {
                address = socketDescriptor.getAddress();
                IoAcceptor ioAcceptor = this.getIoAcceptor(socketDescriptor);
                CompositeIoFilterChainBuilder ioFilterChainBuilder = new CompositeIoFilterChainBuilder(this.getIoFilterChainBuilder());
                if (socketDescriptor.isUseSSL()) {
                    this.installSSL(socketDescriptor, ioFilterChainBuilder);
                }
                ioFilterChainBuilder.addLast("FIXCodec", new ProtocolCodecFilter(new FIXProtocolCodecFactory()));
                ioAcceptor.setFilterChainBuilder(ioFilterChainBuilder);
                ioAcceptor.setCloseOnDeactivation(false);
                ioAcceptor.bind(socketDescriptor.getAddress());
                this.log.info("Listening for connections at {} for session(s) {}", (Object)address, (Object)socketDescriptor.getAcceptedSessions().keySet());
            }
            catch (IOException | GeneralSecurityException | ConfigError e) {
                if (continueInitOnError) {
                    this.log.warn("error during session initialization for session(s) {}, continuing...", (Object)socketDescriptor.getAcceptedSessions().keySet(), (Object)e);
                    continue;
                }
                this.log.error("Cannot start acceptor session for {}, error: {}", (Object)address, (Object)e);
                throw new RuntimeError(e);
            }
        }
    }

    private void installSSL(AcceptorSocketDescriptor descriptor, CompositeIoFilterChainBuilder ioFilterChainBuilder) throws GeneralSecurityException {
        this.log.info("Installing SSL filter for {}", (Object)descriptor.getAddress());
        SSLConfig sslConfig = descriptor.getSslConfig();
        SSLContext sslContext = SSLContextFactory.getInstance(sslConfig);
        SslFilter sslFilter = new SslFilter(sslContext);
        sslFilter.setNeedClientAuth(sslConfig.isNeedClientAuth());
        sslFilter.setEnabledCipherSuites(sslConfig.getEnabledCipherSuites() != null ? sslConfig.getEnabledCipherSuites() : SSLSupport.getDefaultCipherSuites(sslContext));
        sslFilter.setEnabledProtocols(sslConfig.getEnabledProtocols() != null ? sslConfig.getEnabledProtocols() : SSLSupport.getSupportedProtocols(sslContext));
        ioFilterChainBuilder.addLast("SslFilter", sslFilter);
    }

    private IoAcceptor getIoAcceptor(AcceptorSocketDescriptor socketDescriptor) throws ConfigError {
        int transportType = ProtocolFactory.getAddressTransportType(socketDescriptor.getAddress());
        AcceptorSessionProvider sessionProvider = this.sessionProviders.computeIfAbsent(socketDescriptor.getAddress(), k -> new DefaultAcceptorSessionProvider(socketDescriptor.getAcceptedSessions()));
        IoAcceptor ioAcceptor = (IoAcceptor)this.ioAcceptors.get(socketDescriptor);
        if (ioAcceptor == null) {
            ioAcceptor = ProtocolFactory.createIoAcceptor(transportType);
            try {
                SessionSettings settings = this.getSettings();
                NetworkingOptions networkingOptions = new NetworkingOptions(settings.getDefaultProperties());
                networkingOptions.apply(ioAcceptor);
                ioAcceptor.setHandler(new AcceptorIoHandler(sessionProvider, networkingOptions, this.getEventHandlingStrategy()));
            }
            catch (FieldConvertError e) {
                throw new ConfigError(e);
            }
            this.ioAcceptors.put(socketDescriptor, ioAcceptor);
        }
        return ioAcceptor;
    }

    private void setupSession(SessionSettings settings, SessionID sessionID, boolean isTemplate, Map<SessionID, Session> allSessions) throws ConfigError, FieldConvertError {
        SocketAddress acceptorAddress;
        AcceptorSocketDescriptor descriptor;
        int acceptTransportType = 0;
        if (settings.isSetting(sessionID, "SocketAcceptProtocol")) {
            try {
                acceptTransportType = ProtocolFactory.getTransportType(settings.getString(sessionID, "SocketAcceptProtocol"));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError(e);
            }
        }
        boolean useSSL = false;
        SSLConfig sslConfig = null;
        if (this.getSettings().isSetting(sessionID, "SocketUseSSL") && this.getSettings().getBool(sessionID, "SocketUseSSL")) {
            if (acceptTransportType == 0) {
                useSSL = true;
                sslConfig = SSLSupport.getSslConfig(this.getSettings(), sessionID);
            } else {
                this.log.warn("SSL will not be enabled for transport type={}, session={}", (Object)acceptTransportType, (Object)sessionID);
            }
        }
        int acceptPort = (int)settings.getLong(sessionID, "SocketAcceptPort");
        String acceptHost = null;
        if (settings.isSetting(sessionID, "SocketAcceptAddress")) {
            acceptHost = settings.getString(sessionID, "SocketAcceptAddress");
        }
        if ((descriptor = this.socketDescriptorForAddress.get(acceptorAddress = ProtocolFactory.createSocketAddress(acceptTransportType, acceptHost, acceptPort))) != null) {
            if (descriptor.isUseSSL() != useSSL || !this.equals(sslConfig, descriptor.getSslConfig())) {
                throw new ConfigError("Conflicting configurations of acceptor socket: " + acceptorAddress);
            }
        } else {
            descriptor = new AcceptorSocketDescriptor(acceptorAddress, useSSL, sslConfig);
            this.socketDescriptorForAddress.put(acceptorAddress, descriptor);
        }
        if (!isTemplate) {
            Session session = this.sessionFactory.create(sessionID, settings);
            descriptor.acceptSession(session);
            allSessions.put(sessionID, session);
        }
    }

    private boolean equals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    private void createSessions(SessionSettings settings, boolean continueInitOnError) throws ConfigError {
        HashMap<SessionID, Session> allSessions = new HashMap<SessionID, Session>();
        Iterator<SessionID> i = settings.sectionIterator();
        while (i.hasNext()) {
            SessionID sessionID = i.next();
            try {
                String connectionType = null;
                if (settings.isSetting(sessionID, "ConnectionType")) {
                    connectionType = settings.getString(sessionID, "ConnectionType");
                }
                if (!"acceptor".equals(connectionType)) continue;
                boolean isTemplate = false;
                if (settings.isSetting(sessionID, "AcceptorTemplate")) {
                    try {
                        isTemplate = settings.getBool(sessionID, "AcceptorTemplate");
                    }
                    catch (ConfigError | FieldConvertError exception) {
                        // empty catch block
                    }
                }
                this.setupSession(settings, sessionID, isTemplate, allSessions);
            }
            catch (Throwable t) {
                if (continueInitOnError) {
                    this.log.warn("error during session initialization for {}, continuing...", (Object)sessionID, (Object)t);
                    continue;
                }
                throw t instanceof ConfigError ? (ConfigError)t : new ConfigError("error during session initialization", t);
            }
        }
        this.setSessions(allSessions);
        if (this.socketDescriptorForAddress.isEmpty()) {
            throw new ConfigError("No acceptor sessions found in settings.");
        }
    }

    protected void stopAcceptingConnections() {
        Iterator<IoAcceptor> ioIt = this.getEndpoints().iterator();
        while (ioIt.hasNext()) {
            IoAcceptor ioAcceptor = ioIt.next();
            SocketAddress localAddress = ioAcceptor.getLocalAddress();
            ioAcceptor.unbind();
            AbstractSocketAcceptor.closeManagedSessionsAndDispose(ioAcceptor, true, this.log);
            this.log.info("No longer accepting connections on {}", (Object)localAddress);
            ioIt.remove();
        }
    }

    public Collection<IoAcceptor> getEndpoints() {
        return this.ioAcceptors.values();
    }

    public Map<SessionID, SocketAddress> getAcceptorAddresses() {
        HashMap<SessionID, SocketAddress> sessionIdToAddressMap = new HashMap<SessionID, SocketAddress>();
        for (AcceptorSocketDescriptor descriptor : this.socketDescriptorForAddress.values()) {
            for (SessionID sessionID : descriptor.getAcceptedSessions().keySet()) {
                sessionIdToAddressMap.put(sessionID, descriptor.getAddress());
            }
        }
        return sessionIdToAddressMap;
    }

    public void setSessionProvider(SocketAddress address, AcceptorSessionProvider provider) {
        this.sessionProviders.put(address, provider);
    }

    public int getQueueSize() {
        EventHandlingStrategy ehs = this.getEventHandlingStrategy();
        return ehs == null ? 0 : ehs.getQueueSize();
    }

    protected abstract EventHandlingStrategy getEventHandlingStrategy();

    private class DefaultAcceptorSessionProvider
    implements AcceptorSessionProvider {
        private final Map<SessionID, Session> acceptorSessions;

        public DefaultAcceptorSessionProvider(Map<SessionID, Session> acceptorSessions) {
            this.acceptorSessions = acceptorSessions;
        }

        @Override
        public Session getSession(SessionID sessionID, SessionConnector ignored) {
            Session session = this.acceptorSessions.get(sessionID);
            if (session == null) {
                SessionID reduced = this.reduceSessionID(sessionID);
                session = this.acceptorSessions.get(reduced);
            }
            return session;
        }

        private SessionID reduceSessionID(SessionID sessionID) {
            return new SessionID(sessionID.getBeginString(), sessionID.getSenderCompID(), sessionID.getTargetCompID());
        }
    }

    static class StaticAcceptorSessionProvider
    implements AcceptorSessionProvider {
        private final Map<SessionID, Session> acceptorSessions;

        public StaticAcceptorSessionProvider(Map<SessionID, Session> acceptorSessions) {
            this.acceptorSessions = acceptorSessions;
        }

        @Override
        public Session getSession(SessionID sessionID, SessionConnector connector) {
            return this.acceptorSessions.get(sessionID);
        }
    }

    private static class AcceptorSocketDescriptor {
        private final SocketAddress address;
        private final boolean useSSL;
        private final SSLConfig sslConfig;
        private final Map<SessionID, Session> acceptedSessions = new HashMap<SessionID, Session>();

        public AcceptorSocketDescriptor(SocketAddress address, boolean useSSL, SSLConfig sslConfig) {
            this.address = address;
            this.useSSL = useSSL;
            this.sslConfig = sslConfig;
        }

        public void acceptSession(Session session) {
            this.acceptedSessions.put(session.getSessionID(), session);
        }

        public Map<SessionID, Session> getAcceptedSessions() {
            return Collections.unmodifiableMap(this.acceptedSessions);
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public SSLConfig getSslConfig() {
            return this.sslConfig;
        }
    }
}

