/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import quickfix.FieldConvertError;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcDateOnlyConverter
extends AbstractDateTimeConverter {
    static final String TYPE = "date";
    static final int DATE_LENGTH = 8;
    private static final ThreadLocal<UtcDateOnlyConverter> UTC_DATE_CONVERTER = new ThreadLocal();
    private final DateFormat dateFormat = this.createDateFormat("yyyyMMdd");
    private static final DateTimeFormatter FORMATTER_DATE = UtcDateOnlyConverter.createDateTimeFormat("yyyyMMdd");

    public static String convert(Date d) {
        return UtcDateOnlyConverter.getFormatter().format(d);
    }

    public static String convert(LocalDate d) {
        return d.format(FORMATTER_DATE);
    }

    private static DateFormat getFormatter() {
        UtcDateOnlyConverter converter = UTC_DATE_CONVERTER.get();
        if (converter == null) {
            converter = new UtcDateOnlyConverter();
            UTC_DATE_CONVERTER.set(converter);
        }
        return converter.dateFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        Date d = null;
        UtcDateOnlyConverter.checkString(value);
        try {
            d = UtcDateOnlyConverter.getFormatter().parse(value);
        }
        catch (ParseException e) {
            UtcDateOnlyConverter.throwFieldConvertError(value, TYPE);
        }
        return d;
    }

    public static LocalDate convertToLocalDate(String value) throws FieldConvertError {
        UtcDateOnlyConverter.checkString(value);
        try {
            return LocalDate.parse(value.substring(0, 8), FORMATTER_DATE);
        }
        catch (DateTimeParseException e) {
            UtcDateOnlyConverter.throwFieldConvertError(value, TYPE);
            return null;
        }
    }

    private static void checkString(String value) throws FieldConvertError {
        UtcDateOnlyConverter.assertLength(value, 8, TYPE);
        UtcDateOnlyConverter.assertDigitSequence(value, 0, 8, TYPE);
    }

    public static Date getDate(LocalDate localDate) {
        if (localDate != null) {
            return Date.from(localDate.atStartOfDay().atZone(ZoneOffset.UTC).toInstant());
        }
        return null;
    }
}

