/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import quickfix.FieldConvertError;
import quickfix.RuntimeError;

public class DoubleConverter {
    private static final ThreadLocal<DecimalFormat[]> THREAD_DECIMAL_FORMATS = new ThreadLocal();

    public static String convert(double d) {
        return DoubleConverter.convert(d, 0);
    }

    static DecimalFormat getDecimalFormat(int padding) {
        DecimalFormat f;
        if (padding > 14) {
            throw new RuntimeError("maximum padding of 14 zeroes is supported: " + padding);
        }
        DecimalFormat[] decimalFormats = THREAD_DECIMAL_FORMATS.get();
        if (decimalFormats == null) {
            decimalFormats = new DecimalFormat[14];
            THREAD_DECIMAL_FORMATS.set(decimalFormats);
        }
        if ((f = decimalFormats[padding]) == null) {
            int i;
            StringBuilder buffer = new StringBuilder("0.");
            for (i = 0; i < padding; ++i) {
                buffer.append('0');
            }
            for (i = padding; i < 14; ++i) {
                buffer.append('#');
            }
            f = new DecimalFormat(buffer.toString());
            f.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
            decimalFormats[padding] = f;
        }
        return f;
    }

    public static String convert(double d, int padding) {
        return DoubleConverter.getDecimalFormat(padding).format(d);
    }

    public static double convert(String value) throws FieldConvertError {
        try {
            return DoubleConverter.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new FieldConvertError("invalid double value: " + value);
        }
    }

    private static double parseDouble(String value) {
        if (value.length() == 0) {
            throw new NumberFormatException(value);
        }
        boolean dot = false;
        int i = 0;
        char c = value.charAt(i);
        switch (c) {
            case '-': {
                ++i;
                break;
            }
            case '+': {
                throw new NumberFormatException(value);
            }
        }
        while (i < value.length()) {
            c = value.charAt(i);
            if (!dot && c == '.') {
                dot = true;
            } else if (c < '0' || c > '9') {
                throw new NumberFormatException(value);
            }
            ++i;
        }
        return Double.parseDouble(value);
    }
}

