/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.FileStore;
import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class FileStoreFactory
implements MessageStoreFactory {
    public static final String SETTING_FILE_STORE_PATH = "FileStorePath";
    public static final String SETTING_FILE_STORE_SYNC = "FileStoreSync";
    public static final String SETTING_FILE_STORE_MAX_CACHED_MSGS = "FileStoreMaxCachedMsgs";
    protected final SessionSettings settings;

    public FileStoreFactory(SessionSettings settings) {
        this.settings = settings;
    }

    @Override
    public MessageStore create(SessionID sessionID) {
        try {
            long maxCachedMsgsSetting;
            boolean syncWrites = false;
            if (this.settings.isSetting(sessionID, SETTING_FILE_STORE_SYNC)) {
                syncWrites = this.settings.getBool(sessionID, SETTING_FILE_STORE_SYNC);
            }
            int maxCachedMsgs = 10000;
            if (this.settings.isSetting(sessionID, SETTING_FILE_STORE_MAX_CACHED_MSGS) && (maxCachedMsgsSetting = this.settings.getLong(sessionID, SETTING_FILE_STORE_MAX_CACHED_MSGS)) >= 0L && maxCachedMsgsSetting <= Integer.MAX_VALUE) {
                maxCachedMsgs = (int)maxCachedMsgsSetting;
            }
            return new FileStore(this.settings.getString(sessionID, SETTING_FILE_STORE_PATH), sessionID, syncWrites, maxCachedMsgs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

