/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.session;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import quickfix.ConfigError;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class SessionSettingsAdmin
implements DynamicMBean {
    private Properties settings;
    private final SessionID sessionID;

    public SessionSettingsAdmin(SessionID sessionID, SessionSettings settings) throws ConfigError {
        this.sessionID = sessionID;
        Properties p = new Properties();
        p.putAll((Map<?, ?>)settings.getDefaultProperties());
        p.putAll((Map<?, ?>)settings.getSessionProperties(sessionID));
        this.settings = p;
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.settings.get(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList attributeList = new AttributeList();
        for (String attributeName : attributeNames) {
            attributeList.add(new Attribute(attributeName, this.getAttribute(attributeName)));
        }
        return attributeList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributeInfos = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<Object, Object> entry : this.settings.entrySet()) {
            String name = (String)entry.getKey();
            attributeInfos.add(new MBeanAttributeInfo(name, "Setting for " + name, entry.getValue().getClass().getName(), true, false, false));
        }
        return new MBeanInfo(SessionSettings.class.getName(), "Session Settings", attributeInfos.toArray(new MBeanAttributeInfo[attributeInfos.size()]), null, null, null);
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }
}

