/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class CharsetSupport {
    private static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset CHARSET_ASCII = Charset.forName("US-ASCII");
    private static String charset = CharsetSupport.getDefaultCharset();
    private static Charset charsetInstance = Charset.forName(charset);
    private static boolean isStringEquivalent = CharsetSupport.isStringEquivalent(charsetInstance);

    public static String getDefaultCharset() {
        return "ISO-8859-1";
    }

    public static boolean isStringEquivalent(Charset charset) {
        return charset.equals(CHARSET_ISO_8859_1) || charset.equals(CHARSET_ASCII);
    }

    public static boolean isStringEquivalent() {
        return isStringEquivalent;
    }

    public static void setCharset(String charset) throws UnsupportedEncodingException {
        CharsetSupport.charset = CharsetSupport.validate(charset);
        charsetInstance = Charset.forName(charset);
        isStringEquivalent = CharsetSupport.isStringEquivalent(charsetInstance);
    }

    public static void setDefaultCharset() throws UnsupportedEncodingException {
        CharsetSupport.setCharset(CharsetSupport.getDefaultCharset());
    }

    public static String getCharset() {
        return charset;
    }

    public static Charset getCharsetInstance() {
        return charsetInstance;
    }

    public static String validate(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            throw new UnsupportedEncodingException(charset);
        }
        return charset;
    }
}

