/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.PrintStream;
import quickfix.AbstractLog;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class ScreenLog
extends AbstractLog {
    private static final String EVENT_CATEGORY = "event";
    private static final String ERROR_EVENT_CATEGORY = "error";
    private static final String OUTGOING_CATEGORY = "outgoing";
    private static final String INCOMING_CATEGORY = "incoming";
    private PrintStream out;
    private final SessionID sessionID;
    private final boolean incoming;
    private final boolean outgoing;
    private final boolean events;
    private final boolean includeMillis;

    ScreenLog(boolean incoming, boolean outgoing, boolean events, boolean logHeartbeats, boolean includeMillis, SessionID sessionID, PrintStream out) {
        this.setLogHeartbeats(logHeartbeats);
        this.out = out;
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.events = events;
        this.sessionID = sessionID;
        this.includeMillis = includeMillis;
    }

    @Override
    protected void logIncoming(String message) {
        if (this.incoming) {
            this.logMessage(message, INCOMING_CATEGORY);
        }
    }

    @Override
    protected void logOutgoing(String message) {
        if (this.outgoing) {
            this.logMessage(message, OUTGOING_CATEGORY);
        }
    }

    private void logMessage(String message, String type) {
        this.log(message, type);
    }

    @Override
    public void onEvent(String message) {
        if (this.events) {
            this.log(message, EVENT_CATEGORY);
        }
    }

    @Override
    public void onErrorEvent(String message) {
        this.log(message, ERROR_EVENT_CATEGORY);
    }

    private void log(String message, String type) {
        this.out.println("<" + UtcTimestampConverter.convert(SystemTime.getDate(), this.includeMillis) + ", " + this.sessionID + ", " + type + "> (" + message + ")");
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    @Override
    public void clear() {
        this.onEvent("Log clear operation is not supported: " + this.getClass().getName());
    }
}

