/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.concurrent.atomic.AtomicBoolean;
import quickfix.AbstractSessionConnectorBuilder;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class SocketInitiator
extends AbstractSocketInitiator {
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final SingleThreadedEventHandlingStrategy eventHandlingStrategy;

    private SocketInitiator(Builder builder) throws ConfigError {
        super(builder.application, builder.messageStoreFactory, builder.settings, builder.logFactory, builder.messageFactory, builder.numReconnectThreads);
        this.eventHandlingStrategy = builder.queueCapacity >= 0 ? new SingleThreadedEventHandlingStrategy(this, builder.queueCapacity) : new SingleThreadedEventHandlingStrategy(this, builder.queueLowerWatermark, builder.queueUpperWatermark);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, 10000);
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    public SocketInitiator(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this, queueCapacity);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ConfigError {
        AtomicBoolean atomicBoolean = this.isStarted;
        synchronized (atomicBoolean) {
            if (this.isStarted.compareAndSet(false, true)) {
                this.eventHandlingStrategy.setExecutor(this.longLivedExecutor);
                this.createSessionInitiators();
                for (Session session : this.getSessionMap().values()) {
                    Session.registerSession(session);
                }
                this.startInitiators();
                this.eventHandlingStrategy.blockInThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean forceDisconnect) {
        AtomicBoolean atomicBoolean = this.isStarted;
        synchronized (atomicBoolean) {
            if (this.isStarted.compareAndSet(true, false)) {
                try {
                    this.logoutAllSessions(forceDisconnect);
                    this.stopInitiators();
                }
                finally {
                    try {
                        this.eventHandlingStrategy.stopHandlingMessages(true);
                    }
                    finally {
                        Session.unregisterSessions(this.getSessions(), true);
                        this.clearConnectorSessions();
                    }
                }
            }
        }
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }

    public static final class Builder
    extends AbstractSessionConnectorBuilder<Builder, SocketInitiator> {
        int numReconnectThreads = 3;

        private Builder() {
            super(Builder.class);
        }

        public Builder withReconnectThreads(int numReconnectThreads) throws ConfigError {
            this.numReconnectThreads = numReconnectThreads;
            return this;
        }

        @Override
        protected SocketInitiator doBuild() throws ConfigError {
            return new SocketInitiator(this);
        }
    }
}

