/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import quickfix.Application;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.FromAdminListener;
import quickfix.FromAppListener;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.RejectLogon;
import quickfix.SessionID;
import quickfix.ToAppListener;
import quickfix.UnsupportedMessageType;

public class ApplicationFunctionalAdapter
implements Application {
    private final List<Consumer<SessionID>> onCreateListeners = new CopyOnWriteArrayList<Consumer<SessionID>>();
    private final List<Consumer<SessionID>> onLogonListeners = new CopyOnWriteArrayList<Consumer<SessionID>>();
    private final List<Consumer<SessionID>> onLogoutListeners = new CopyOnWriteArrayList<Consumer<SessionID>>();
    private final List<BiConsumer<Message, SessionID>> toAdminListeners = new CopyOnWriteArrayList<BiConsumer<Message, SessionID>>();
    private final ConcurrentMap<Class, List<BiConsumer>> toAdminTypeSafeListeners = new ConcurrentHashMap<Class, List<BiConsumer>>();
    private final List<FromAdminListener<Message>> fromAdminListeners = new CopyOnWriteArrayList<FromAdminListener<Message>>();
    private final ConcurrentMap<Class, List<FromAdminListener>> fromAdminTypeSafeListeners = new ConcurrentHashMap<Class, List<FromAdminListener>>();
    private final List<ToAppListener<Message>> toAppListeners = new CopyOnWriteArrayList<ToAppListener<Message>>();
    private final ConcurrentMap<Class, List<ToAppListener>> toAppTypeSafeListeners = new ConcurrentHashMap<Class, List<ToAppListener>>();
    private final List<FromAppListener<Message>> fromAppListeners = new CopyOnWriteArrayList<FromAppListener<Message>>();
    private final ConcurrentMap<Class, List<FromAppListener>> fromAppTypeSafeListeners = new ConcurrentHashMap<Class, List<FromAppListener>>();

    public void addOnCreateListener(Consumer<SessionID> onCreateListener) {
        this.onCreateListeners.add(onCreateListener);
    }

    public void removeOnCreateListener(Consumer<SessionID> onCreateListener) {
        this.onCreateListeners.remove(onCreateListener);
    }

    public void addOnLogonListener(Consumer<SessionID> onLogonListener) {
        this.onLogonListeners.add(onLogonListener);
    }

    public void removeOnLogonListener(Consumer<SessionID> onLogonListener) {
        this.onLogonListeners.remove(onLogonListener);
    }

    public void addOnLogoutListener(Consumer<SessionID> onLogoutListener) {
        this.onLogoutListeners.add(onLogoutListener);
    }

    public void removeOnLogoutListener(Consumer<SessionID> onLogoutListener) {
        this.onLogoutListeners.remove(onLogoutListener);
    }

    public void addToAdminListener(BiConsumer<Message, SessionID> toAdminListener) {
        this.toAdminListeners.add(toAdminListener);
    }

    public <T extends Message> void addToAdminListener(Class<T> clazz, BiConsumer<T, SessionID> toAdminListener) {
        this.getList(this.toAdminTypeSafeListeners, clazz).add(toAdminListener);
    }

    public <T extends Message> void removeToAdminListener(BiConsumer<T, SessionID> toAdminListener) {
        this.toAdminListeners.remove(toAdminListener);
        this.toAdminTypeSafeListeners.values().forEach(list -> list.remove(toAdminListener));
    }

    public void addFromAdminListener(FromAdminListener<Message> fromAdminListener) {
        this.fromAdminListeners.add(fromAdminListener);
    }

    public <T extends Message> void addFromAdminListener(Class<T> clazz, FromAdminListener<T> fromAdminListener) {
        this.getList(this.fromAdminTypeSafeListeners, clazz).add(fromAdminListener);
    }

    public <T extends Message> void removeFromAdminListener(FromAdminListener<T> fromAdminListener) {
        this.fromAdminListeners.remove(fromAdminListener);
        this.fromAdminTypeSafeListeners.values().forEach(list -> list.remove(fromAdminListener));
    }

    public void addToAppListener(ToAppListener<Message> toAppListener) {
        this.toAppListeners.add(toAppListener);
    }

    public <T extends Message> void addToAppListener(Class<T> clazz, ToAppListener<T> toAppListener) {
        this.getList(this.toAppTypeSafeListeners, clazz).add(toAppListener);
    }

    public <T extends Message> void removeToAppListener(ToAppListener<T> toAppListener) {
        this.toAppListeners.remove(toAppListener);
        this.toAppTypeSafeListeners.values().forEach(list -> list.remove(toAppListener));
    }

    public void addFromAppListener(FromAppListener<Message> fromAppListener) {
        this.fromAppListeners.add(fromAppListener);
    }

    public <T extends Message> void addFromAppListener(Class<T> clazz, FromAppListener<T> fromAppListener) {
        this.getList(this.fromAppTypeSafeListeners, clazz).add(fromAppListener);
    }

    public <T extends Message> void removeFromAppListener(FromAppListener<T> fromAppListener) {
        this.fromAppListeners.remove(fromAppListener);
        this.fromAppTypeSafeListeners.values().forEach(list -> list.remove(fromAppListener));
    }

    @Override
    public void onCreate(SessionID sessionId) {
        this.onCreateListeners.forEach(c -> c.accept(sessionId));
    }

    @Override
    public void onLogon(SessionID sessionId) {
        this.onLogonListeners.forEach(c -> c.accept(sessionId));
    }

    @Override
    public void onLogout(SessionID sessionId) {
        this.onLogoutListeners.forEach(c -> c.accept(sessionId));
    }

    @Override
    public void toAdmin(Message message, SessionID sessionId) {
        this.toAdminListeners.forEach(c -> c.accept(message, sessionId));
        this.getList(this.toAdminTypeSafeListeners, message.getClass()).forEach(c -> c.accept(message, sessionId));
    }

    @Override
    public void fromAdmin(Message message, SessionID sessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
        for (FromAdminListener<Message> listener : this.fromAdminListeners) {
            listener.accept(message, sessionId);
        }
        for (FromAdminListener<Message> listener : this.getList(this.fromAdminTypeSafeListeners, message.getClass())) {
            listener.accept(message, sessionId);
        }
    }

    @Override
    public void toApp(Message message, SessionID sessionId) throws DoNotSend {
        for (ToAppListener<Message> listener : this.toAppListeners) {
            listener.accept(message, sessionId);
        }
        for (ToAppListener<Message> listener : this.getList(this.toAppTypeSafeListeners, message.getClass())) {
            listener.accept(message, sessionId);
        }
    }

    @Override
    public void fromApp(Message message, SessionID sessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        for (FromAppListener<Message> listener : this.fromAppListeners) {
            listener.accept(message, sessionId);
        }
        for (FromAppListener<Message> listener : this.getList(this.fromAppTypeSafeListeners, message.getClass())) {
            listener.accept(message, sessionId);
        }
    }

    private <T> List<T> getList(ConcurrentMap<Class, List<T>> multimap, Class clazz) {
        return multimap.computeIfAbsent(clazz, k -> new CopyOnWriteArrayList());
    }
}

