/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.quickfixj.jmx.JmxExporter;
import org.quickfixj.jmx.mbean.JmxSupport;
import org.quickfixj.jmx.mbean.connector.ConnectorAdmin;
import org.quickfixj.jmx.mbean.connector.SocketInitiatorAdminMBean;
import org.quickfixj.jmx.mbean.session.SessionJmxExporter;
import quickfix.SessionID;
import quickfix.mina.initiator.AbstractSocketInitiator;
import quickfix.mina.initiator.IoSessionInitiator;

class SocketInitiatorAdmin
extends ConnectorAdmin
implements SocketInitiatorAdminMBean {
    private final AbstractSocketInitiator initiator;

    protected SocketInitiatorAdmin(JmxExporter jmxExporter, AbstractSocketInitiator connector, ObjectName connectorName, SessionJmxExporter sessionExporter) {
        super(jmxExporter, connector, connectorName, connector.getSettings(), sessionExporter);
        this.initiator = connector;
    }

    @Override
    public TabularData getInitiatorAddresses() throws IOException {
        ArrayList<SessionInitiatorAddressRow> rows = new ArrayList<SessionInitiatorAddressRow>();
        for (IoSessionInitiator initiator : this.initiator.getInitiators()) {
            SessionID sessionID = initiator.getSessionID();
            rows.add(new SessionInitiatorAddressRow(sessionID, initiator.getLocalAddress(), initiator.getSocketAddresses(), this.sessionExporter.getSessionName(sessionID)));
        }
        try {
            return TABULAR_DATA_ADAPTER.fromBeanList("InitiatorAddresses", "AddressInfo", "sessionID", rows);
        }
        catch (OpenDataException e) {
            throw JmxSupport.toIOException(e);
        }
    }

    @Override
    public int getQueueSize() {
        return this.initiator.getQueueSize();
    }

    public static class SessionInitiatorAddressRow {
        private final SessionID sessionID;
        private final SocketAddress localInitiatorAddress;
        private final SocketAddress[] initiatorAddresses;
        private final ObjectName sessionName;

        public SessionInitiatorAddressRow(SessionID sessionID, SocketAddress localInitiatorAddress, SocketAddress[] initiatorAddresses, ObjectName sessionName) {
            this.sessionID = sessionID;
            this.localInitiatorAddress = localInitiatorAddress;
            this.initiatorAddresses = initiatorAddresses;
            this.sessionName = sessionName;
        }

        public String getLocalInitiatorAddress() {
            if (this.localInitiatorAddress == null) {
                return null;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.localInitiatorAddress;
            return inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        }

        public String getInitiatorAddresses() {
            StringBuilder builder = new StringBuilder(128);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.initiatorAddresses[0];
            builder.append(inetSocketAddress.getAddress().getHostAddress()).append(':').append(inetSocketAddress.getPort());
            for (int i = 1; i < this.initiatorAddresses.length; ++i) {
                inetSocketAddress = (InetSocketAddress)this.initiatorAddresses[i];
                builder.append(',').append(inetSocketAddress.getAddress().getHostAddress()).append(':').append(inetSocketAddress.getPort());
            }
            return builder.toString();
        }

        public SessionID getSessionID() {
            return this.sessionID;
        }

        public ObjectName getSessionName() {
            return this.sessionName;
        }
    }
}

