/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.ExecutorFactory;
import quickfix.FieldConvertError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.field.converter.IntConverter;

public abstract class SessionConnector
implements Connector {
    protected static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final String SESSIONS_PROPERTY = "sessions";
    public static final String QF_SESSION = "QF_SESSION";
    public static final String QFJ_RESET_IO_CONNECTOR = "QFJ_RESET_IO_CONNECTOR";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<SessionID, Session> sessions = new ConcurrentHashMap<SessionID, Session>();
    private final SessionSettings settings;
    private final SessionFactory sessionFactory;
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new QFTimerThreadFactory());
    private ScheduledFuture<?> sessionTimerFuture;
    private IoFilterChainBuilder ioFilterChainBuilder;
    protected Executor longLivedExecutor;
    protected Executor shortLivedExecutor;

    public SessionConnector(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        this.settings = settings;
        this.sessionFactory = sessionFactory;
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        if (this.longLivedExecutor != null || this.shortLivedExecutor != null) {
            throw new IllegalStateException("Optional ExecutorFactory has already been set.  It cannot be changed once set.");
        }
        this.longLivedExecutor = executorFactory.getLongLivedExecutor();
        this.shortLivedExecutor = executorFactory.getShortLivedExecutor();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void setSessions(Map<SessionID, Session> sessions) {
        this.clearConnectorSessions();
        this.sessions.putAll(sessions);
        this.propertyChangeSupport.firePropertyChange(SESSIONS_PROPERTY, null, sessions);
    }

    protected void clearConnectorSessions() {
        this.sessions.clear();
    }

    public List<Session> getManagedSessions() {
        return new ArrayList<Session>(this.sessions.values());
    }

    protected Map<SessionID, Session> getSessionMap() {
        return Collections.unmodifiableMap(this.sessions);
    }

    @Override
    public ArrayList<SessionID> getSessions() {
        return new ArrayList<SessionID>(this.sessions.keySet());
    }

    public void addDynamicSession(Session inSession) {
        this.sessions.put(inSession.getSessionID(), inSession);
        this.log.debug("adding session for {}", (Object)inSession.getSessionID());
        this.propertyChangeSupport.firePropertyChange(SESSIONS_PROPERTY, null, this.sessions);
    }

    public void removeDynamicSession(SessionID inSessionID) {
        this.sessions.remove(inSessionID);
        this.log.debug("removing session for {}", (Object)inSessionID);
        this.propertyChangeSupport.firePropertyChange(SESSIONS_PROPERTY, null, this.sessions);
    }

    public SessionSettings getSettings() {
        return this.settings;
    }

    protected Session createSession(SessionID sessionID) throws ConfigError {
        return this.sessionFactory.create(sessionID, this.settings);
    }

    protected int getIntSetting(String key) throws ConfigError {
        try {
            return IntConverter.convert(this.settings.getString(key));
        }
        catch (FieldConvertError e) {
            throw (ConfigError)new ConfigError(e.getMessage()).fillInStackTrace();
        }
    }

    @Override
    public boolean isLoggedOn() {
        if (this.sessions.isEmpty()) {
            return false;
        }
        for (Session session : this.sessions.values()) {
            if (session.isLoggedOn()) continue;
            return false;
        }
        return true;
    }

    boolean anyLoggedOn() {
        if (this.sessions.isEmpty()) {
            return false;
        }
        for (Session session : this.sessions.values()) {
            if (!session.isLoggedOn()) continue;
            return true;
        }
        return false;
    }

    private Set<Session> getLoggedOnSessions() {
        HashSet<Session> loggedOnSessions = new HashSet<Session>(this.sessions.size());
        for (Session session : this.sessions.values()) {
            if (!session.isLoggedOn()) continue;
            loggedOnSessions.add(session);
        }
        return loggedOnSessions;
    }

    protected void logoutAllSessions(boolean forceDisconnect) {
        this.log.info("Logging out all sessions");
        if (this.sessions == null) {
            this.log.error("Attempt to logout all sessions before initialization is complete.");
            return;
        }
        for (Session session : this.sessions.values()) {
            try {
                session.logout();
            }
            catch (Throwable e) {
                this.logError(session.getSessionID(), null, "Error during logout", e);
            }
        }
        if (this.anyLoggedOn()) {
            if (forceDisconnect) {
                for (Session session : this.sessions.values()) {
                    try {
                        if (!session.isLoggedOn()) continue;
                        session.disconnect("Forcibly disconnecting session", false);
                    }
                    catch (Throwable e) {
                        this.logError(session.getSessionID(), null, "Error during disconnect", e);
                    }
                }
            } else {
                this.waitForLogout();
            }
        }
    }

    protected void waitForLogout() {
        Set<Session> loggedOnSessions;
        long start = System.currentTimeMillis();
        while (!(loggedOnSessions = this.getLoggedOnSessions()).isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            long elapsed = System.currentTimeMillis() - start;
            Iterator<Session> sessionItr = loggedOnSessions.iterator();
            while (sessionItr.hasNext()) {
                Session session = sessionItr.next();
                if (elapsed < (long)session.getLogoutTimeout() * 1000L) continue;
                try {
                    session.disconnect("Logout timeout, force disconnect", false);
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                sessionItr.remove();
            }
            if (elapsed <= 60000L) continue;
            this.log.warn("Stopping session logout wait after 1 minute");
            break;
        }
    }

    protected void logError(SessionID sessionID, IoSession protocolSession, String message, Throwable t) {
        this.log.error(message + this.getLogSuffix(sessionID, protocolSession), t);
    }

    private String getLogSuffix(SessionID sessionID, IoSession protocolSession) {
        String suffix = ":";
        if (sessionID != null) {
            suffix = suffix + "sessionID=" + sessionID.toString() + ";";
        }
        if (protocolSession != null) {
            suffix = suffix + "address=" + protocolSession.getRemoteAddress();
        }
        return suffix;
    }

    protected void startSessionTimer() {
        Runnable timerTask = new SessionTimerTask();
        if (this.shortLivedExecutor != null) {
            timerTask = new DelegatingTask(timerTask, this.shortLivedExecutor);
        }
        this.sessionTimerFuture = scheduledExecutorService.scheduleAtFixedRate(timerTask, 0L, 1000L, TimeUnit.MILLISECONDS);
        this.log.info("SessionTimer started");
    }

    protected void stopSessionTimer() {
        if (this.sessionTimerFuture != null && this.sessionTimerFuture.cancel(true)) {
            this.log.info("SessionTimer canceled");
        }
    }

    boolean checkSessionTimerRunning() {
        if (this.sessionTimerFuture != null) {
            return !this.sessionTimerFuture.isDone();
        }
        return false;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutorService;
    }

    public void setIoFilterChainBuilder(IoFilterChainBuilder ioFilterChainBuilder) {
        this.ioFilterChainBuilder = ioFilterChainBuilder;
    }

    protected IoFilterChainBuilder getIoFilterChainBuilder() {
        return this.ioFilterChainBuilder;
    }

    public static void closeManagedSessionsAndDispose(IoService ioService, boolean awaitTermination, Logger logger) {
        Map managedSessions = ioService.getManagedSessions();
        for (IoSession ioSession : managedSessions.values()) {
            if (ioSession.isClosing()) continue;
            CloseFuture closeFuture = ioSession.closeNow();
            boolean completed = false;
            try {
                completed = closeFuture.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (completed) continue;
            logger.warn("Could not close IoSession {}", (Object)ioSession);
        }
        if (!ioService.isDisposing()) {
            ioService.dispose(awaitTermination);
        }
    }

    private static class QFTimerThreadFactory
    implements ThreadFactory {
        private QFTimerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "QFJ Timer");
            thread.setDaemon(true);
            return thread;
        }
    }

    static final class DelegatingTask
    implements Runnable {
        private final BlockingSupportTask delegate;
        private final Executor executor;

        DelegatingTask(Runnable delegate, Executor executor) {
            this.delegate = new BlockingSupportTask(delegate);
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.execute(this.delegate);
            try {
                this.delegate.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        static final class BlockingSupportTask
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final Runnable delegate;

            BlockingSupportTask(Runnable delegate) {
                this.delegate = delegate;
            }

            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                String threadName = currentThread.getName();
                try {
                    currentThread.setName("QFJ Timer (" + threadName + ")");
                    this.delegate.run();
                }
                finally {
                    this.latch.countDown();
                    currentThread.setName(threadName);
                }
            }

            void await() throws InterruptedException {
                this.latch.await();
            }
        }
    }

    private class SessionTimerTask
    implements Runnable {
        private SessionTimerTask() {
        }

        @Override
        public void run() {
            try {
                for (Session session : SessionConnector.this.sessions.values()) {
                    try {
                        session.next();
                    }
                    catch (IOException e) {
                        SessionConnector.this.logError(session.getSessionID(), null, "Error in session timer processing", e);
                    }
                }
            }
            catch (Throwable e) {
                SessionConnector.this.log.error("Error during timer processing", e);
            }
        }
    }
}

