/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.File;
import java.io.FileFilter;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.jobs.DirectoryScanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class DirectoryScanJob
implements Job {
    public static final String DIRECTORY_NAME = "DIRECTORY_NAME";
    public static final String DIRECTORY_SCAN_LISTENER_NAME = "DIRECTORY_SCAN_LISTENER_NAME";
    public static final String MINIMUM_UPDATE_AGE = "MINIMUM_UPDATE_AGE";
    private static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        long maxAgeDate;
        File[] updatedFiles;
        JobDataMap mergedJobDataMap = context.getMergedJobDataMap();
        SchedulerContext schedCtx = null;
        try {
            schedCtx = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Error obtaining scheduler context.", (Throwable)e, false);
        }
        String dirName = mergedJobDataMap.getString(DIRECTORY_NAME);
        String listenerName = mergedJobDataMap.getString(DIRECTORY_SCAN_LISTENER_NAME);
        if (dirName == null) {
            throw new JobExecutionException("Required parameter 'DIRECTORY_NAME' not found in merged JobDataMap");
        }
        if (listenerName == null) {
            throw new JobExecutionException("Required parameter 'DIRECTORY_SCAN_LISTENER_NAME' not found in merged JobDataMap");
        }
        DirectoryScanListener listener = (DirectoryScanListener)schedCtx.get((Object)listenerName);
        if (listener == null) {
            throw new JobExecutionException("DirectoryScanListener named '" + listenerName + "' not found in SchedulerContext");
        }
        long lastDate = -1L;
        if (mergedJobDataMap.containsKey((Object)LAST_MODIFIED_TIME)) {
            lastDate = mergedJobDataMap.getLong(LAST_MODIFIED_TIME);
        }
        long minAge = 5000L;
        if (mergedJobDataMap.containsKey((Object)MINIMUM_UPDATE_AGE)) {
            minAge = mergedJobDataMap.getLong(MINIMUM_UPDATE_AGE);
        }
        if ((updatedFiles = this.getUpdatedOrNewFiles(dirName, lastDate, maxAgeDate = System.currentTimeMillis() - minAge)) == null) {
            this.log.warn("Directory '" + dirName + "' does not exist.");
            return;
        }
        long latestMod = lastDate;
        for (File updFile : updatedFiles) {
            long lm = updFile.lastModified();
            latestMod = lm > latestMod ? lm : latestMod;
        }
        if (updatedFiles.length > 0) {
            this.log.info("Directory '" + dirName + "' contents updated, notifying listener.");
            listener.filesUpdatedOrAdded(updatedFiles);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Directory '" + dirName + "' contents unchanged.");
        }
        context.getJobDetail().getJobDataMap().put(LAST_MODIFIED_TIME, latestMod);
    }

    protected File[] getUpdatedOrNewFiles(String dirName, final long lastDate, final long maxAgeDate) {
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.lastModified() > lastDate && pathname.lastModified() < maxAgeDate;
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }
}

