/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.codecs;

@Untraversable
public abstract class BaseBytes
extends PySequence
implements List<PyInteger> {
    protected static final byte[] emptyStorage;
    protected byte[] storage = emptyStorage;
    protected int size = 0;
    protected int offset = 0;
    private static PyString PICKLE_ENCODING;
    private static final int SWAP_CASE = 32;
    private static final byte UPPER = 1;
    private static final byte LOWER = 2;
    private static final byte DIGIT = 4;
    private static final byte SPACE = 8;
    private static final byte ALPHA = 3;
    private static final byte ALNUM = 7;
    private static final byte[] ctype;
    protected final List<PyInteger> listDelegate = new AbstractList<PyInteger>(){

        @Override
        public PyInteger get(int index) {
            BaseBytes.this.indexCheck(index);
            return BaseBytes.this.pyget(index);
        }

        @Override
        public int size() {
            return BaseBytes.this.size;
        }

        @Override
        public PyInteger set(int index, PyInteger element) throws PyException {
            BaseBytes.this.indexCheck(index);
            PyInteger result = BaseBytes.this.pyget(index);
            BaseBytes.this.pyset(index, element);
            return result;
        }

        @Override
        public void add(int index, PyInteger element) throws PyException {
            BaseBytes.this.indexCheck(index);
            BaseBytes.this.pyinsert(index, element);
        }

        @Override
        public PyInteger remove(int index) {
            BaseBytes.this.indexCheck(index);
            PyInteger result = BaseBytes.this.pyget(index);
            BaseBytes.this.del(index);
            return result;
        }
    };

    public BaseBytes(PyType type) {
        super(type, null);
        this.delegator = new IndexDelegate();
        this.setStorage(emptyStorage);
    }

    public BaseBytes(PyType type, int size) {
        super(type, null);
        this.delegator = new IndexDelegate();
        this.newStorage(size);
    }

    public BaseBytes(PyType type, int[] value) {
        super(type, null);
        this.delegator = new IndexDelegate();
        int n = value.length;
        this.newStorage(n);
        int i = this.offset;
        for (int j = 0; j < n; ++j) {
            this.storage[i] = BaseBytes.byteCheck(value[j]);
            ++i;
        }
    }

    protected BaseBytes(PyType type, String value) throws PyException {
        super(type, null);
        this.delegator = new IndexDelegate();
        int n = value.length();
        this.newStorage(n);
        int i = this.offset;
        for (int j = 0; j < n; ++j) {
            this.storage[i++] = BaseBytes.byteCheck(value.charAt(j));
        }
    }

    protected void setStorage(byte[] storage, int size, int offset) throws IllegalArgumentException {
        if (size < 0 || offset < 0 || offset + size > storage.length) {
            throw new IllegalArgumentException();
        }
        this.storage = storage;
        this.size = size;
        this.offset = offset;
    }

    protected void setStorage(byte[] storage, int size) throws IllegalArgumentException {
        if (size < 0 || size > storage.length) {
            throw new IllegalArgumentException();
        }
        this.storage = storage;
        this.size = size;
        this.offset = 0;
    }

    protected void setStorage(byte[] storage) {
        this.storage = storage;
        this.size = storage.length;
        this.offset = 0;
    }

    protected void init(PyObject arg) {
        if (arg == null) {
            this.setStorage(emptyStorage);
        } else if (arg instanceof PyString) {
            this.init((PyString)arg, (String)null, (String)null);
        } else if (arg.isIndex()) {
            this.init(arg.asIndex(Py.OverflowError));
        } else if (arg instanceof BaseBytes) {
            this.init((BaseBytes)arg);
        } else if (arg instanceof BufferProtocol) {
            this.init((BufferProtocol)((Object)arg));
        } else {
            this.init(arg.asIterable());
        }
    }

    protected void init(PyString arg, PyObject encoding, PyObject errors) {
        String enc = encoding == null ? null : encoding.asString();
        String err = errors == null ? null : errors.asString();
        this.init(arg, enc, err);
    }

    protected void init(PyString arg, String encoding, String errors) {
        String encoded = BaseBytes.encode(arg, encoding, errors);
        this.newStorage(encoded.length());
        this.setBytes(0, encoded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String encode(PyString arg, String encoding, String errors) throws PyException {
        if (arg instanceof PyUnicode) {
            if (encoding == null) throw Py.TypeError("unicode argument without an encoding");
            return codecs.encode(arg, encoding, errors);
        }
        if (encoding == null) return arg.getString();
        return codecs.encode(arg, encoding, errors);
    }

    protected void setBytes(int start, String value) throws PyException {
        int n = value.length();
        int io = this.offset + start;
        for (int j = 0; j < n; ++j) {
            this.storage[io++] = BaseBytes.byteCheck(value.charAt(j));
        }
    }

    protected void setBytes(int start, int step, String value) throws PyException {
        int n = value.length();
        int io = this.offset + start;
        for (int j = 0; j < n; ++j) {
            this.storage[io] = BaseBytes.byteCheck(value.charAt(j));
            io += step;
        }
    }

    protected void init(int n) {
        if (n < 0) {
            throw Py.ValueError("negative count");
        }
        this.newStorage(n);
    }

    protected void init(BufferProtocol value) throws PyException {
        try (PyBuffer view = value.getBuffer(284);){
            this.newStorage(view.getLen());
            view.copyTo(this.storage, this.offset);
        }
    }

    protected void init(BaseBytes source) {
        this.newStorage(source.size);
        System.arraycopy(source.storage, source.offset, this.storage, this.offset, this.size);
    }

    protected void init(Iterable<? extends PyObject> iter) {
        FragmentList fragList = new FragmentList();
        fragList.loadFrom(iter);
        if (fragList.totalCount > 0) {
            if (fragList.size() == 1) {
                Fragment frag = (Fragment)fragList.getFirst();
                this.setStorage(frag.storage, frag.count);
            } else {
                this.newStorage(fragList.totalCount);
                fragList.emptyInto(this.storage, this.offset);
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    protected final void indexCheck(int index) throws PyException {
        if (index < 0 || index >= this.size) {
            throw Py.IndexError(this.getType().fastGetName() + " index out of range");
        }
    }

    protected void newStorage(int needed) {
        if (needed > 0) {
            try {
                this.setStorage(new byte[needed]);
            }
            catch (OutOfMemoryError e) {
                throw Py.MemoryError(e.getMessage());
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    protected static final byte byteCheck(int value) throws PyException {
        if (value < 0 || value > 255) {
            throw Py.ValueError("byte must be in range(0, 256)");
        }
        return (byte)value;
    }

    protected static final byte byteCheck(PyInteger value) throws PyException {
        return BaseBytes.byteCheck(value.asInt());
    }

    protected static final byte byteCheck(PyObject value) throws PyException {
        if (value.isIndex()) {
            return BaseBytes.byteCheck(value.asIndex());
        }
        if (value.getType() == PyString.TYPE) {
            String strValue = ((PyString)value).getString();
            if (strValue.length() != 1) {
                throw Py.ValueError("string must be of size 1");
            }
            return BaseBytes.byteCheck(strValue.charAt(0));
        }
        throw Py.TypeError("an integer or string of size 1 is required");
    }

    protected static PyBuffer getView(PyObject b) {
        if (b == null) {
            return null;
        }
        if (b instanceof PyUnicode) {
            return null;
        }
        if (b instanceof BufferProtocol) {
            return ((BufferProtocol)((Object)b)).getBuffer(284);
        }
        return null;
    }

    protected static PyBuffer getViewOrError(PyObject b) {
        PyBuffer buffer = BaseBytes.getView(b);
        if (buffer != null) {
            return buffer;
        }
        String fmt = "Type %s doesn't support the buffer API";
        throw Py.TypeError(String.format(fmt, b.getType().fastGetName()));
    }

    @Override
    protected PyInteger pyget(int index) {
        return new PyInteger(this.intAt(index));
    }

    @Override
    protected abstract BaseBytes getslice(int var1, int var2, int var3);

    @Override
    protected abstract BaseBytes repeat(int var1);

    public void pyinsert(int index, PyObject element) {
        this.pyset(index, element);
    }

    protected BaseBytes getslice(int start, int stop) {
        return this.getslice(start, stop, 1);
    }

    @Override
    public int __len__() {
        return this.size;
    }

    private static int compare(BaseBytes a, PyBuffer b) {
        int ap = a.offset;
        int aEnd = ap + a.size;
        int bp = 0;
        int bEnd = b.getLen();
        while (ap < aEnd) {
            int bVal;
            int aVal;
            int diff;
            if (bp >= bEnd) {
                return 1;
            }
            if ((diff = (aVal = 0xFF & a.storage[ap++]) - (bVal = b.intAt(bp++))) == 0) continue;
            return diff < 0 ? -1 : 1;
        }
        if (bp < bEnd) {
            return -1;
        }
        return 0;
    }

    private synchronized int basebytes_cmp(PyObject b) {
        if (this == b) {
            return 0;
        }
        try (PyBuffer bv = BaseBytes.getView(b);){
            if (bv == null) {
                int n = -2;
                return n;
            }
            int n = BaseBytes.compare(this, bv);
            return n;
        }
    }

    private synchronized int basebytes_cmpeq(PyObject b) {
        if (this == b) {
            return 0;
        }
        try (PyBuffer bv = BaseBytes.getView(b);){
            if (bv == null) {
                int n = -2;
                return n;
            }
            if (bv.getLen() != this.size) {
                int n = 1;
                return n;
            }
            int n = BaseBytes.compare(this, bv);
            return n;
        }
    }

    final PyObject basebytes___eq__(PyObject other) {
        int cmp = this.basebytes_cmpeq(other);
        if (cmp == 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject basebytes___ne__(PyObject other) {
        int cmp = this.basebytes_cmpeq(other);
        if (cmp == 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject basebytes___lt__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp >= 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject basebytes___le__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp > 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject basebytes___ge__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp >= 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject basebytes___gt__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp > 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    protected final synchronized boolean basebytes___contains__(PyObject target) {
        if (target.isIndex()) {
            byte b = BaseBytes.byteCheck(target.asIndex());
            return this.index(b) >= 0;
        }
        try (PyBuffer targetView = BaseBytes.getViewOrError(target);){
            Finder finder = new Finder(targetView);
            finder.setText(this);
            boolean bl = finder.nextIndex() >= 0;
            return bl;
        }
    }

    protected final synchronized boolean basebytes_starts_or_endswith(PyObject target, PyObject ostart, PyObject oend, boolean endswith) {
        int[] index = this.indicesEx(ostart, oend);
        if (target instanceof PyTuple) {
            for (PyObject t : ((PyTuple)target).getList()) {
                if (!this.match(t, index[0], index[3], endswith)) continue;
                return true;
            }
            return false;
        }
        return this.match(target, index[0], index[3], endswith);
    }

    private boolean match(PyObject target, int pos, int n, boolean endswith) {
        try (PyBuffer vt = BaseBytes.getViewOrError(target);){
            int j = 0;
            int len = vt.getLen();
            if (!endswith) {
                if (len > n) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                j = n - len;
                if (j < 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            j += this.offset + pos;
            for (int i = 0; i < len; ++i) {
                if (this.storage[j++] == vt.byteAt(i)) continue;
                boolean x2 = false;
                return x2;
            }
            boolean bl = true;
            return bl;
        }
    }

    private int[] indicesEx(PyObject ostart, PyObject oend) {
        PySlice s = new PySlice(ostart, oend, null);
        return s.indicesEx(this.size);
    }

    @Override
    public synchronized String asString() {
        char[] buf = new char[this.size];
        int j = this.offset + this.size;
        int i = this.size;
        while (--i >= 0) {
            buf[i] = (char)(0xFF & this.storage[--j]);
        }
        return new String(buf);
    }

    public PyObject decode() {
        return this.decode(null, null);
    }

    public PyObject decode(String encoding) {
        return this.decode(encoding, null);
    }

    public PyObject decode(String encoding, String errors) {
        PyString this_ = new PyString(this.asString());
        return codecs.decode(this_, encoding, errors);
    }

    protected final PyObject basebytes_decode(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("decode", args, keywords, "encoding", "errors");
        String encoding = ap.getString(0, null);
        String errors = ap.getString(1, null);
        return this.decode(encoding, errors);
    }

    static PyException ConcatenationTypeError(PyType type, PyType toType) {
        String fmt = "can't concat %s to %s";
        return Py.TypeError(String.format(fmt, type.fastGetName(), toType.fastGetName()));
    }

    @Override
    public PyObject __reduce__() {
        return this.basebytes___reduce__();
    }

    final PyTuple basebytes___reduce__() {
        PyUnicode encoded = new PyUnicode(this.asString());
        PyTuple args = new PyTuple(encoded, BaseBytes.getPickleEncoding());
        PyObject dict = this.__findattr__("__dict__");
        return new PyTuple(this.getType(), args, dict != null ? dict : Py.None);
    }

    private static final PyString getPickleEncoding() {
        if (PICKLE_ENCODING == null) {
            PICKLE_ENCODING = new PyString("latin-1");
        }
        return PICKLE_ENCODING;
    }

    protected int index(byte b) {
        int limit = this.offset + this.size;
        for (int p = this.offset; p < limit; ++p) {
            if (this.storage[p] != b) continue;
            return p - this.offset;
        }
        return -1;
    }

    protected static final int checkForEmptySeparator(PyBuffer separator) throws PyException {
        int n = separator.getLen();
        if (n == 0) {
            throw Py.ValueError("empty separator");
        }
        return n;
    }

    protected int lstripIndex(ByteSet byteSet) {
        int limit = this.offset + this.size;
        for (int left = this.offset; left < limit; ++left) {
            if (byteSet.contains(this.storage[left])) continue;
            return left - this.offset;
        }
        return this.size;
    }

    protected int lstripIndex() {
        int limit = this.offset + this.size;
        for (int left = this.offset; left < limit; ++left) {
            if (BaseBytes.isspace(this.storage[left])) continue;
            return left - this.offset;
        }
        return this.size;
    }

    protected int rstripIndex(ByteSet byteSet) {
        for (int right = this.offset + this.size; right > this.offset; --right) {
            if (byteSet.contains(this.storage[right - 1])) continue;
            return right - this.offset;
        }
        return 0;
    }

    protected int rstripIndex() {
        for (int right = this.offset + this.size; right > this.offset; --right) {
            if (BaseBytes.isspace(this.storage[right - 1])) continue;
            return right - this.offset;
        }
        return this.size;
    }

    final int basebytes_count(PyObject sub, PyObject ostart, PyObject oend) {
        try (PyBuffer vsub = BaseBytes.getViewOrError(sub);){
            Finder finder = new Finder(vsub);
            int[] index = this.indicesEx(ostart, oend);
            int n = finder.count(this.storage, this.offset + index[0], index[3]);
            return n;
        }
    }

    final int basebytes_find(PyObject sub, PyObject ostart, PyObject oend) {
        try (PyBuffer vsub = BaseBytes.getViewOrError(sub);){
            Finder finder = new Finder(vsub);
            int n = this.find(finder, ostart, oend);
            return n;
        }
    }

    static void basebytes_fromhex(BaseBytes result, String hex) throws PyException {
        int hexlen = hex.length();
        result.newStorage(hexlen / 2);
        String fmt = "non-hexadecimal number found in fromhex() arg at position %d";
        byte[] r = result.storage;
        int p = result.offset;
        int i = 0;
        while (i < hexlen) {
            char c;
            if ((c = hex.charAt(i++)) == ' ') continue;
            try {
                int value = BaseBytes.hexDigit(c);
                c = hex.charAt(i++);
                value = (value << 4) + BaseBytes.hexDigit(c);
                r[p++] = (byte)value;
            }
            catch (IllegalArgumentException e) {
                throw Py.ValueError(String.format(fmt, i - 1));
            }
            catch (IndexOutOfBoundsException e) {
                throw Py.ValueError(String.format(fmt, i - 2));
            }
        }
        result.size = p - result.offset;
    }

    private static int hexDigit(char c) throws IllegalArgumentException {
        int result = c - 48;
        if (result >= 0) {
            if (result < 10) {
                return result;
            }
            result = (c & 0xDF) - 65;
            if (result >= 0 && result < 6) {
                return result + 10;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final synchronized PyByteArray basebytes_join(Iterable<? extends PyObject> iter) {
        LinkedList<PyBuffer> iterList = new LinkedList<PyBuffer>();
        long mysize = this.size;
        long totalSize = 0L;
        boolean first = true;
        try {
            for (PyObject pyObject : iter) {
                PyBuffer v = BaseBytes.getView(pyObject);
                if (v == null) {
                    String fmt = "can only join an iterable of bytes (item %d has type '%.80s')";
                    throw Py.TypeError(String.format(fmt, iterList.size(), pyObject.getType().fastGetName()));
                }
                iterList.add(v);
                totalSize += (long)v.getLen();
                if (!first) {
                    totalSize += mysize;
                } else {
                    first = false;
                }
                if (totalSize <= Integer.MAX_VALUE) continue;
                throw Py.OverflowError("join() result would be too long");
            }
            PyByteArray result = new PyByteArray((int)totalSize);
            int n = result.offset;
            first = true;
            for (PyBuffer v : iterList) {
                void var9_9;
                if (!first) {
                    System.arraycopy(this.storage, this.offset, result.storage, (int)var9_9, this.size);
                    var9_9 += this.size;
                } else {
                    first = false;
                }
                v.copyTo(result.storage, (int)var9_9);
                var9_9 += v.getLen();
            }
            PyByteArray pyByteArray = result;
            return pyByteArray;
        }
        finally {
            for (PyBuffer v : iterList) {
                v.release();
            }
        }
    }

    public PyTuple partition(PyObject sep) {
        return this.basebytes_partition(sep);
    }

    final synchronized PyTuple basebytes_partition(PyObject sep) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            int n = BaseBytes.checkForEmptySeparator(separator);
            Finder finder = new Finder(separator);
            finder.setText(this);
            int p = finder.nextIndex() - this.offset;
            if (p >= 0) {
                PyTuple pyTuple = this.partition(p, p + n);
                return pyTuple;
            }
            PyTuple pyTuple = this.partition(this.size, this.size);
            return pyTuple;
        }
    }

    private PyTuple partition(int p, int q) {
        BaseBytes head = this.getslice(0, p);
        BaseBytes sep = this.getslice(p, q);
        BaseBytes tail = this.getslice(q, this.size);
        return new PyTuple(head, sep, tail);
    }

    final int basebytes_rfind(PyObject sub, PyObject ostart, PyObject oend) {
        try (PyBuffer vsub = BaseBytes.getViewOrError(sub);){
            ReverseFinder finder = new ReverseFinder(vsub);
            int n = this.find(finder, ostart, oend);
            return n;
        }
    }

    private final int find(Finder finder, PyObject ostart, PyObject oend) {
        int[] index = this.indicesEx(ostart, oend);
        finder.setText(this.storage, this.offset + index[0], index[3]);
        int result = finder.nextIndex();
        return result < 0 ? -1 : result - this.offset;
    }

    /*
     * Exception decompiling
     */
    final synchronized PyByteArray basebytes_replace(PyObject oldB, PyObject newB, int maxcount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 65[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PyByteArray replace_substring(PyBuffer from, PyBuffer to, int maxcount) {
        int q;
        byte[] r;
        Finder finder = new Finder(from);
        int count2 = finder.count(this.storage, this.offset, this.size, maxcount);
        if (count2 == 0) {
            return new PyByteArray(this);
        }
        int from_len = from.getLen();
        int to_len = to.getLen();
        long result_len = this.size + count2 * (to_len - from_len);
        try {
            r = new byte[(int)result_len];
        }
        catch (OutOfMemoryError e) {
            throw Py.OverflowError("replace bytes is too long");
        }
        int p = this.offset;
        int rp = 0;
        finder.setText(this.storage, p, this.size);
        while (count2-- > 0 && (q = finder.nextIndex()) >= 0) {
            int length = q - p;
            if (length > 0) {
                System.arraycopy(this.storage, p, r, rp, length);
                rp += length;
            }
            p = q + from_len;
            to.copyTo(r, rp);
            rp += to_len;
        }
        int length = this.size + this.offset - p;
        if (length > 0) {
            System.arraycopy(this.storage, p, r, rp, length);
            rp += length;
        }
        return new PyByteArray(r);
    }

    private PyByteArray replace_interleave(PyBuffer to, int maxcount) {
        byte[] r;
        int count2 = this.size + 1;
        if (maxcount < count2) {
            count2 = maxcount;
        }
        int to_len = to.getLen();
        long result_len = (long)count2 * (long)to_len + (long)this.size;
        try {
            r = new byte[(int)result_len];
        }
        catch (OutOfMemoryError e) {
            throw Py.OverflowError("replace bytes is too long");
        }
        int p = this.offset;
        int rp = 0;
        to.copyTo(r, rp);
        rp += to_len;
        for (int i = 1; i < count2; ++i) {
            r[rp++] = this.storage[p++];
            to.copyTo(r, rp);
            rp += to_len;
        }
        int length = this.size + this.offset - p;
        if (length > 0) {
            System.arraycopy(this.storage, p, r, rp, length);
            rp += length;
        }
        return new PyByteArray(r);
    }

    private PyByteArray replace_delete_substring(PyBuffer from, int maxcount) {
        int q;
        byte[] r;
        Finder finder = new Finder(from);
        int count2 = finder.count(this.storage, this.offset, this.size, maxcount);
        if (count2 == 0) {
            return new PyByteArray(this);
        }
        int from_len = from.getLen();
        long result_len = this.size - count2 * from_len;
        assert (result_len >= 0L);
        try {
            r = new byte[(int)result_len];
        }
        catch (OutOfMemoryError e) {
            throw Py.OverflowError("replace bytes is too long");
        }
        int p = this.offset;
        int rp = 0;
        finder.setText(this.storage, this.offset, this.size);
        while (count2-- > 0 && (q = finder.nextIndex()) >= 0) {
            int length = q - p;
            if (length > 0) {
                System.arraycopy(this.storage, p, r, rp, length);
                rp += length;
            }
            p = q + from_len;
        }
        int length = this.size + this.offset - p;
        if (length > 0) {
            System.arraycopy(this.storage, p, r, rp, length);
            rp += length;
        }
        return new PyByteArray(r);
    }

    private PyByteArray replace_substring_in_place(PyBuffer from, PyBuffer to, int maxcount) {
        int q;
        byte[] r;
        Finder finder = new Finder(from);
        int count2 = maxcount;
        try {
            r = new byte[this.size];
        }
        catch (OutOfMemoryError e) {
            throw Py.OverflowError("replace bytes is too long");
        }
        System.arraycopy(this.storage, this.offset, r, 0, this.size);
        finder.setText(r);
        while (count2-- > 0 && (q = finder.nextIndex()) >= 0) {
            to.copyTo(r, q);
        }
        return new PyByteArray(r);
    }

    public PyTuple rpartition(PyObject sep) {
        return this.basebytes_rpartition(sep);
    }

    final synchronized PyTuple basebytes_rpartition(PyObject sep) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            int n = BaseBytes.checkForEmptySeparator(separator);
            ReverseFinder finder = new ReverseFinder(separator);
            finder.setText(this);
            int p = ((Finder)finder).nextIndex() - this.offset;
            if (p >= 0) {
                PyTuple pyTuple = this.partition(p, p + n);
                return pyTuple;
            }
            PyTuple pyTuple = this.partition(0, 0);
            return pyTuple;
        }
    }

    public PyList rsplit() {
        return this.basebytes_rsplit_whitespace(-1);
    }

    public PyList rsplit(PyObject sep) {
        return this.basebytes_rsplit(sep, -1);
    }

    public PyList rsplit(PyObject sep, int maxsplit) {
        return this.basebytes_rsplit(sep, maxsplit);
    }

    final PyList basebytes_rsplit(PyObject sep, int maxsplit) {
        if (sep == null || sep == Py.None) {
            return this.basebytes_rsplit_whitespace(maxsplit);
        }
        return this.basebytes_rsplit_explicit(sep, maxsplit);
    }

    final synchronized PyList basebytes_rsplit_explicit(PyObject sep, int maxsplit) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            int n = BaseBytes.checkForEmptySeparator(separator);
            PyList result = new PyList();
            ReverseFinder finder = new ReverseFinder(separator);
            finder.setText(this);
            int q = this.offset + this.size;
            while (q > this.offset && maxsplit-- != 0) {
                int r = q;
                q = ((Finder)finder).nextIndex();
                int p = q < 0 ? this.offset : q + n;
                BaseBytes word = this.getslice(p - this.offset, r - this.offset);
                result.add(0, word);
            }
            if (q >= this.offset) {
                BaseBytes word = this.getslice(0, q - this.offset);
                result.add(0, word);
            }
            PyList pyList = result;
            return pyList;
        }
    }

    final synchronized PyList basebytes_rsplit_whitespace(int maxsplit) {
        BaseBytes word;
        int q;
        PyList result = new PyList();
        for (q = this.offset + this.size; q > this.offset && BaseBytes.isspace(this.storage[q - 1]); --q) {
        }
        while (q > this.offset && maxsplit-- != 0) {
            int p;
            for (p = q; p > this.offset && !BaseBytes.isspace(this.storage[p - 1]); --p) {
            }
            word = this.getslice(p - this.offset, q - this.offset);
            result.add(0, word);
            for (q = p; q > this.offset && BaseBytes.isspace(this.storage[q - 1]); --q) {
            }
        }
        if (q > this.offset) {
            word = this.getslice(0, q - this.offset);
            result.add(0, word);
        }
        return result;
    }

    public PyList split() {
        return this.basebytes_split_whitespace(-1);
    }

    public PyList split(PyObject sep) {
        return this.basebytes_split(sep, -1);
    }

    public PyList split(PyObject sep, int maxsplit) {
        return this.basebytes_split(sep, maxsplit);
    }

    final PyList basebytes_split(PyObject sep, int maxsplit) {
        if (sep == null || sep == Py.None) {
            return this.basebytes_split_whitespace(maxsplit);
        }
        return this.basebytes_split_explicit(sep, maxsplit);
    }

    final synchronized PyList basebytes_split_explicit(PyObject sep, int maxsplit) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            BaseBytes.checkForEmptySeparator(separator);
            PyList result = new PyList();
            Finder finder = new Finder(separator);
            finder.setText(this);
            int p = finder.currIndex();
            int q = finder.nextIndex();
            while (q >= 0 && maxsplit-- != 0) {
                result.append(this.getslice(p - this.offset, q - this.offset));
                p = finder.currIndex();
                q = finder.nextIndex();
            }
            result.append(this.getslice(p - this.offset, this.size));
            PyList pyList = result;
            return pyList;
        }
    }

    final synchronized PyList basebytes_split_whitespace(int maxsplit) {
        int p;
        PyList result = new PyList();
        int limit = this.offset + this.size;
        for (p = this.offset; p < limit && BaseBytes.isspace(this.storage[p]); ++p) {
        }
        while (p < limit && maxsplit-- != 0) {
            int q;
            for (q = p; q < limit && !BaseBytes.isspace(this.storage[q]); ++q) {
            }
            result.append(this.getslice(p - this.offset, q - this.offset));
            for (p = q; p < limit && BaseBytes.isspace(this.storage[p]); ++p) {
            }
        }
        if (p < limit) {
            result.append(this.getslice(p - this.offset, this.size));
        }
        return result;
    }

    public PyList splitlines() {
        return this.basebytes_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.basebytes_splitlines(keepends);
    }

    protected final synchronized PyList basebytes_splitlines(boolean keepends) {
        PyList list = new PyList();
        int limit = this.offset + this.size;
        int p = this.offset;
        while (p < limit) {
            int q;
            int lenEOL = 0;
            for (q = p; q < limit; ++q) {
                byte b = this.storage[q];
                if (b == 13) {
                    lenEOL = this.storage[q + 1] == 10 ? 2 : 1;
                    break;
                }
                if (b != 10) continue;
                lenEOL = 1;
                break;
            }
            if (keepends) {
                list.append(this.getslice(p - this.offset, q + lenEOL - this.offset));
            } else {
                list.append(this.getslice(p - this.offset, q - this.offset));
            }
            p = q + lenEOL;
        }
        return list;
    }

    protected static byte fillByteCheck(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.length() == 1) {
            return (byte)fillchar.charAt(0);
        }
        throw Py.TypeError(function + "() argument 2 must be char, not str");
    }

    private BaseBytes padHelper(byte pad, int left, int right) {
        if (left + right <= 0) {
            return this.getslice(0, this.size);
        }
        Builder builder = this.getBuilder(left + this.size + right);
        builder.repeat(pad, left);
        builder.append(this);
        builder.repeat(pad, right);
        return builder.getResult();
    }

    final BaseBytes basebytes_center(int width, String fillchar) {
        byte pad = BaseBytes.fillByteCheck("center", fillchar);
        int fill = width - this.size;
        int left = fill / 2 + (fill & width & 1);
        return this.padHelper(pad, left, fill - left);
    }

    final BaseBytes basebytes_ljust(int width, String fillchar) {
        byte pad = BaseBytes.fillByteCheck("rjust", fillchar);
        int fill = width - this.size;
        return this.padHelper(pad, 0, fill);
    }

    final BaseBytes basebytes_rjust(int width, String fillchar) {
        byte pad = BaseBytes.fillByteCheck("rjust", fillchar);
        int fill = width - this.size;
        return this.padHelper(pad, fill, 0);
    }

    final BaseBytes basebytes_expandtabs(int tabsize) {
        int estimatedSize = this.size + this.size / 8;
        Builder builder = this.getBuilder(estimatedSize);
        int carriagePosition = 0;
        int limit = this.offset + this.size;
        for (int i = this.offset; i < limit; ++i) {
            byte c = this.storage[i];
            if (c == 9) {
                int spaces = tabsize - carriagePosition % tabsize;
                builder.repeat((byte)32, spaces);
                carriagePosition += spaces;
                continue;
            }
            builder.append(c);
            carriagePosition = c == 10 || c == 13 ? 0 : carriagePosition + 1;
        }
        return builder.getResult();
    }

    final BaseBytes basebytes_zfill(int width) {
        int fill = width - this.size;
        Builder builder = this.getBuilder(fill > 0 ? width : this.size);
        if (fill <= 0) {
            builder.append(this);
        } else {
            byte sign;
            int p = 0;
            if (this.size > 0 && ((sign = this.storage[this.offset]) == 45 || sign == 43)) {
                builder.append(sign);
                p = 1;
            }
            builder.repeat((byte)48, fill);
            if (this.size > p) {
                builder.append(this, p, this.size);
            }
        }
        return builder.getResult();
    }

    static final boolean isupper(byte b) {
        return (ctype[128 + b] & 1) != 0;
    }

    static final boolean islower(byte b) {
        return (ctype[128 + b] & 2) != 0;
    }

    static final boolean isalpha(byte b) {
        return (ctype[128 + b] & 3) != 0;
    }

    static final boolean isdigit(byte b) {
        return (ctype[128 + b] & 4) != 0;
    }

    static final boolean isalnum(byte b) {
        return (ctype[128 + b] & 7) != 0;
    }

    static final boolean isspace(byte b) {
        return (ctype[128 + b] & 8) != 0;
    }

    public boolean isalnum() {
        return this.basebytes_isalnum();
    }

    final boolean basebytes_isalnum() {
        if (this.size == 1) {
            return BaseBytes.isalnum(this.storage[this.offset]);
        }
        for (int i = 0; i < this.size; ++i) {
            if (BaseBytes.isalnum(this.storage[this.offset + i])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean isalpha() {
        return this.basebytes_isalpha();
    }

    final boolean basebytes_isalpha() {
        if (this.size == 1) {
            return BaseBytes.isalpha(this.storage[this.offset]);
        }
        for (int i = 0; i < this.size; ++i) {
            if (BaseBytes.isalpha(this.storage[this.offset + i])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean isdigit() {
        return this.basebytes_isdigit();
    }

    final boolean basebytes_isdigit() {
        if (this.size == 1) {
            return BaseBytes.isdigit(this.storage[this.offset]);
        }
        for (int i = 0; i < this.size; ++i) {
            if (BaseBytes.isdigit(this.storage[this.offset + i])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean islower() {
        return this.basebytes_islower();
    }

    final boolean basebytes_islower() {
        int i;
        if (this.size == 1) {
            return BaseBytes.islower(this.storage[this.offset]);
        }
        byte c = 0;
        for (i = 0; i < this.size && !BaseBytes.isalpha(c = this.storage[this.offset + i]); ++i) {
        }
        if (i == this.size || BaseBytes.isupper(c)) {
            return false;
        }
        ++i;
        while (i < this.size) {
            if (BaseBytes.isupper(this.storage[this.offset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isspace() {
        return this.basebytes_isspace();
    }

    final boolean basebytes_isspace() {
        if (this.size == 1) {
            return BaseBytes.isspace(this.storage[this.offset]);
        }
        for (int i = 0; i < this.size; ++i) {
            if (BaseBytes.isspace(this.storage[this.offset + i])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean istitle() {
        return this.basebytes_istitle();
    }

    final boolean basebytes_istitle() {
        int state = 0;
        for (int i = 0; i < this.size; ++i) {
            byte c = this.storage[this.offset + i];
            if (BaseBytes.isupper(c)) {
                if (state == 2) {
                    return false;
                }
                state = 2;
                continue;
            }
            if (BaseBytes.islower(c)) {
                if (state == 2) continue;
                return false;
            }
            if (state != 2) continue;
            state = 1;
        }
        return state != 0;
    }

    public boolean isupper() {
        return this.basebytes_isupper();
    }

    final boolean basebytes_isupper() {
        int i;
        if (this.size == 1) {
            return BaseBytes.isupper(this.storage[this.offset]);
        }
        byte c = 0;
        for (i = 0; i < this.size && !BaseBytes.isalpha(c = this.storage[this.offset + i]); ++i) {
        }
        if (i == this.size || BaseBytes.islower(c)) {
            return false;
        }
        ++i;
        while (i < this.size) {
            if (BaseBytes.islower(this.storage[this.offset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BaseBytes capitalize() {
        return this.basebytes_capitalize();
    }

    final BaseBytes basebytes_capitalize() {
        Builder builder = this.getBuilder(this.size);
        if (this.size > 0) {
            byte c = this.storage[this.offset];
            if (BaseBytes.islower(c)) {
                c = (byte)(c ^ 0x20);
            }
            builder.append(c);
            for (int i = 1; i < this.size; ++i) {
                c = this.storage[this.offset + i];
                if (BaseBytes.isupper(c)) {
                    c = (byte)(c ^ 0x20);
                }
                builder.append(c);
            }
        }
        return builder.getResult();
    }

    public BaseBytes lower() {
        return this.basebytes_lower();
    }

    final BaseBytes basebytes_lower() {
        Builder builder = this.getBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            byte c = this.storage[this.offset + i];
            if (BaseBytes.isupper(c)) {
                c = (byte)(c ^ 0x20);
            }
            builder.append(c);
        }
        return builder.getResult();
    }

    public BaseBytes swapcase() {
        return this.basebytes_swapcase();
    }

    final BaseBytes basebytes_swapcase() {
        Builder builder = this.getBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            byte c = this.storage[this.offset + i];
            if (BaseBytes.isalpha(c)) {
                c = (byte)(c ^ 0x20);
            }
            builder.append(c);
        }
        return builder.getResult();
    }

    public BaseBytes title() {
        return this.basebytes_title();
    }

    final BaseBytes basebytes_title() {
        Builder builder = this.getBuilder(this.size);
        boolean inWord = false;
        for (int i = 0; i < this.size; ++i) {
            byte c = this.storage[this.offset + i];
            if (!inWord) {
                if (BaseBytes.islower(c)) {
                    c = (byte)(c ^ 0x20);
                    inWord = true;
                } else if (BaseBytes.isupper(c)) {
                    inWord = true;
                }
            } else if (BaseBytes.isupper(c)) {
                c = (byte)(c ^ 0x20);
            } else if (!BaseBytes.islower(c)) {
                inWord = false;
            }
            builder.append(c);
        }
        return builder.getResult();
    }

    public BaseBytes upper() {
        return this.basebytes_upper();
    }

    final BaseBytes basebytes_upper() {
        Builder builder = this.getBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            byte c = this.storage[this.offset + i];
            if (BaseBytes.islower(c)) {
                c = (byte)(c ^ 0x20);
            }
            builder.append(c);
        }
        return builder.getResult();
    }

    private final synchronized byte byteAt(int index) {
        return this.storage[index + this.offset];
    }

    public synchronized int intAt(int index) throws PyException {
        this.indexCheck(index);
        return 0xFF & this.byteAt(index);
    }

    protected synchronized byte[] repeatImpl(int count2) {
        byte[] dst;
        if (count2 <= 0) {
            return emptyStorage;
        }
        long newSize = (long)count2 * (long)this.size;
        try {
            dst = new byte[(int)newSize];
        }
        catch (OutOfMemoryError e) {
            throw Py.MemoryError(e.getMessage());
        }
        int i = 0;
        int p = 0;
        while (i < count2) {
            System.arraycopy(this.storage, this.offset, dst, p, this.size);
            ++i;
            p += this.size;
        }
        return dst;
    }

    private static final void appendHexEscape(StringBuilder buf, int c) {
        buf.append("\\x").append(Character.forDigit((c & 0xF0) >> 4, 16)).append(Character.forDigit(c & 0xF, 16));
    }

    final synchronized String basebytes_repr(String before, String after) {
        if (before == null) {
            before = "";
        }
        if (after == null) {
            after = "";
        }
        int guess = this.size + (this.size >> 2) + before.length() + after.length() + 10;
        StringBuilder buf = new StringBuilder(guess);
        buf.append(before).append('\'');
        int jmax = this.offset + this.size;
        for (int j = this.offset; j < jmax; ++j) {
            int c = 0xFF & this.storage[j];
            if (c >= 127) {
                BaseBytes.appendHexEscape(buf, c);
                continue;
            }
            if (c >= 32) {
                if (c == 92 || c == 39) {
                    buf.append('\\');
                }
                buf.append((char)c);
                continue;
            }
            if (c == 9) {
                buf.append("\\t");
                continue;
            }
            if (c == 10) {
                buf.append("\\n");
                continue;
            }
            if (c == 13) {
                buf.append("\\r");
                continue;
            }
            BaseBytes.appendHexEscape(buf, c);
        }
        buf.append('\'').append(after);
        return buf.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.listDelegate.contains(o);
    }

    @Override
    public Iterator<PyInteger> iterator() {
        return this.listDelegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.listDelegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.listDelegate.toArray(a);
    }

    @Override
    public boolean add(PyInteger o) {
        return this.listDelegate.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.listDelegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.listDelegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends PyInteger> c) {
        return this.listDelegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends PyInteger> c) {
        return this.listDelegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.listDelegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.listDelegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.listDelegate.clear();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof PyObject) {
            return super.equals(other);
        }
        return this.listDelegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.listDelegate.hashCode();
    }

    @Override
    public PyInteger get(int index) {
        return this.listDelegate.get(index);
    }

    @Override
    public PyInteger set(int index, PyInteger element) {
        return this.listDelegate.set(index, element);
    }

    @Override
    public void add(int index, PyInteger element) {
        this.listDelegate.add(index, element);
    }

    @Override
    public PyInteger remove(int index) {
        return this.listDelegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.listDelegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.listDelegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<PyInteger> listIterator() {
        return this.listDelegate.listIterator();
    }

    @Override
    public ListIterator<PyInteger> listIterator(int index) {
        return this.listDelegate.listIterator(index);
    }

    @Override
    public List<PyInteger> subList(int fromIndex, int toIndex) {
        return this.listDelegate.subList(fromIndex, toIndex);
    }

    protected static final int roundUp(int size) {
        int ALLOC = 16;
        int SIZE2 = 10;
        if (size >= 10) {
            return size + (size >> 3) + 21 & 0xFFFFFFF0;
        }
        if (size > 0) {
            return 16;
        }
        return 0;
    }

    protected abstract Builder getBuilder(int var1);

    static {
        int c;
        emptyStorage = new byte[0];
        ctype = new byte[256];
        for (c = 65; c <= 90; ++c) {
            BaseBytes.ctype[128 + c] = 1;
            BaseBytes.ctype[160 + c] = 2;
        }
        for (c = 48; c <= 57; ++c) {
            BaseBytes.ctype[128 + c] = 4;
        }
        for (char c2 : " \t\n\u000b\f\r".toCharArray()) {
            BaseBytes.ctype[128 + c2] = 8;
        }
    }

    protected static abstract class Builder {
        private byte[] storage = emptyStorage;
        private int size = 0;

        abstract BaseBytes getResult();

        Builder(int capacity) {
            this.makeRoomFor(capacity);
        }

        byte[] getStorage() {
            byte[] s = this.storage;
            this.storage = emptyStorage;
            return s;
        }

        final int getSize() {
            return this.size;
        }

        void append(byte b) {
            this.makeRoomFor(1);
            this.storage[this.size++] = b;
        }

        void repeat(byte b, int n) {
            if (n > 0) {
                this.makeRoomFor(n);
                while (n-- > 0) {
                    this.storage[this.size++] = b;
                }
            }
        }

        void append(BaseBytes b) {
            this.append(b, 0, b.size);
        }

        void append(BaseBytes b, int start, int end) {
            int n = end - start;
            this.makeRoomFor(n);
            System.arraycopy(b.storage, b.offset + start, this.storage, this.size, n);
            this.size += n;
        }

        void append(PyBuffer v) {
            int n = v.getLen();
            this.makeRoomFor(n);
            v.copyTo(this.storage, this.size);
            this.size += n;
        }

        void makeRoomFor(int n) throws PyException {
            int needed = this.size + n;
            if (needed > this.storage.length) {
                try {
                    if (this.storage == emptyStorage) {
                        this.size = 0;
                        if (n > 0) {
                            this.storage = new byte[n];
                        }
                    } else {
                        byte[] old = this.storage;
                        this.storage = new byte[BaseBytes.roundUp(needed)];
                        System.arraycopy(old, 0, this.storage, 0, this.size);
                    }
                }
                catch (OutOfMemoryError e) {
                    throw Py.MemoryError(e.getMessage());
                }
            }
        }
    }

    protected static class ByteSet {
        protected final long[] map = new long[4];

        public ByteSet(PyBuffer bytes) {
            int n = bytes.getLen();
            for (int i = 0; i < n; ++i) {
                int word;
                int c = bytes.intAt(i);
                long mask = 1L << c;
                int n2 = word = c >> 6;
                this.map[n2] = this.map[n2] | mask;
            }
        }

        public boolean contains(byte b) {
            int word = (b & 0xFF) >> 6;
            long mask = 1L << b;
            return (this.map[word] & mask) != 0L;
        }

        public boolean contains(int b) {
            int word = b >> 6;
            long mask = 1L << b;
            return (this.map[word] & mask) != 0L;
        }
    }

    protected static class ReverseFinder
    extends Finder {
        private static final byte MASK = 31;

        public ReverseFinder(PyBuffer pattern) {
            super(pattern);
        }

        @Override
        protected int[] calculateSkipTable() {
            int[] skipTable = new int[32];
            int m = this.pattern.getLen();
            Arrays.fill(skipTable, m);
            int i = m;
            while (--i >= 0) {
                skipTable[0x1F & this.pattern.byteAt((int)i)] = i;
            }
            return skipTable;
        }

        @Override
        public int currIndex() {
            return this.right + this.pattern.getLen() - 1;
        }

        @Override
        public int nextIndex() {
            int m = this.pattern.getLen();
            if (this.skipTable != null) {
                int i = this.right - 1;
                while (i >= this.left) {
                    int skip = this.skipTable[0x1F & this.text[i]];
                    if (skip == 0) {
                        int j;
                        int k = i;
                        for (j = 0; j < m && this.text[k++] == this.pattern.byteAt(j); ++j) {
                        }
                        if (j == m) {
                            this.right = i - m + 1;
                            return i;
                        }
                        --i;
                        continue;
                    }
                    i -= skip;
                }
            } else if (m == 1) {
                byte b = this.pattern.byteAt(0);
                int i = this.right;
                while (--i >= this.left) {
                    if (this.text[i] != b) continue;
                    this.right = i;
                    return i;
                }
            } else {
                int i = this.right;
                if (--i >= this.left) {
                    this.right = i;
                    return i;
                }
            }
            return -1;
        }
    }

    protected static class Finder {
        private static final byte MASK = 31;
        protected int[] skipTable = null;
        protected final PyBuffer pattern;
        protected byte[] text = emptyStorage;
        protected int left = 0;
        protected int right = 0;

        public Finder(PyBuffer pattern) {
            this.pattern = pattern;
        }

        protected int[] calculateSkipTable() {
            int[] skipTable = new int[32];
            int m = this.pattern.getLen();
            Arrays.fill(skipTable, m);
            for (int i = 0; i < m; ++i) {
                skipTable[0x1F & this.pattern.byteAt((int)i)] = m - i - 1;
            }
            return skipTable;
        }

        public void setText(byte[] text) {
            this.setText(text, 0, text.length);
        }

        public void setText(BaseBytes text) {
            this.setText(text.storage, text.offset, text.size);
        }

        public void setText(byte[] text, int start, int size) {
            this.text = text;
            this.left = start;
            this.right = start + size - this.pattern.getLen() + 1;
            if (this.pattern.getLen() > 1 && this.skipTable == null) {
                this.skipTable = this.calculateSkipTable();
            }
        }

        public int currIndex() {
            return this.left;
        }

        public int nextIndex() {
            int m = this.pattern.getLen();
            if (this.skipTable != null) {
                int i = this.left;
                while (i < this.right) {
                    int skip = this.skipTable[0x1F & this.text[i + (m - 1)]];
                    if (skip == 0) {
                        int j;
                        int k = i;
                        for (j = 0; j < m && this.text[k++] == this.pattern.byteAt(j); ++j) {
                        }
                        if (j == m) {
                            this.left = k;
                            return i;
                        }
                        ++i;
                        continue;
                    }
                    i += skip;
                }
            } else if (m == 1) {
                byte b = this.pattern.byteAt(0);
                for (int i = this.left; i < this.right; ++i) {
                    if (this.text[i] != b) continue;
                    this.left = i + 1;
                    return i;
                }
            } else {
                int i = this.left;
                if (i <= this.right) {
                    this.left = i + 1;
                    return i;
                }
            }
            return -1;
        }

        public int count(byte[] text) {
            return this.count(text, 0, text.length, Integer.MAX_VALUE);
        }

        public int count(byte[] text, int start, int size) {
            return this.count(text, start, size, Integer.MAX_VALUE);
        }

        public int count(byte[] text, int start, int size, int maxcount) {
            int count2;
            this.setText(text, start, size);
            for (count2 = 0; count2 < maxcount && this.nextIndex() >= 0; ++count2) {
            }
            return count2;
        }
    }

    private class IndexDelegate
    extends PySequence.DefaultIndexDelegate {
        private IndexDelegate() {
            super(BaseBytes.this);
        }

        @Override
        public void checkIdxAndSetSlice(PySlice slice2, PyObject value) {
            if (value.__len__() != 0) {
                super.checkIdxAndSetSlice(slice2, value);
            } else {
                this.checkIdxAndDelItem(slice2);
            }
        }

        @Override
        protected void delSlice(int[] indices) {
            BaseBytes.this.delslice(indices[0], indices[1], indices[2], indices[3]);
        }
    }

    protected static class FragmentList
    extends LinkedList<Fragment> {
        int totalCount = 0;

        protected FragmentList() {
        }

        void loadFrom(Iterable<? extends PyObject> iter) throws PyException {
            int fragSize = 8;
            Fragment curr = null;
            try {
                for (PyObject pyObject : iter) {
                    if (curr == null) {
                        curr = new Fragment(fragSize);
                        this.add(curr);
                        if (fragSize < 1024) {
                            fragSize <<= 1;
                        }
                    }
                    if (!curr.isFilledBy(pyObject)) continue;
                    this.totalCount += curr.count;
                    curr = null;
                }
            }
            catch (OutOfMemoryError e) {
                throw Py.MemoryError(e.getMessage());
            }
            if (curr != null) {
                this.totalCount += curr.count;
            }
        }

        void emptyInto(byte[] target, int p) {
            for (Fragment frag : this) {
                System.arraycopy(frag.storage, 0, target, p, frag.count);
                p += frag.count;
            }
            this.clear();
            this.totalCount = 0;
        }

        void emptyInto(byte[] target, int start, int step) {
            int p = start;
            for (Fragment frag : this) {
                for (int i = 0; i < frag.count; ++i) {
                    target[p] = frag.storage[i];
                    p += step;
                }
            }
            this.clear();
            this.totalCount = 0;
        }
    }

    protected static class Fragment {
        static final int MINSIZE = 8;
        static final int MAXSIZE = 1024;
        byte[] storage;
        int count = 0;

        Fragment(int size) {
            this.storage = new byte[size];
        }

        boolean isFilledBy(PyObject value) {
            this.storage[this.count++] = BaseBytes.byteCheck(value);
            return this.count == this.storage.length;
        }
    }
}

