/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLongDerived;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;

public class PyLong
extends PyObject {
    public static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger maxULong = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
    public static final String exposed_name = "long";
    private BigInteger value;
    private static final PyType LONGTYPE = PyType.fromClass(PyLong.class);

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        class Exposed___abs__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___abs__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___abs__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___abs__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___abs__();
            }
        }
        pyObject.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyLong.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___float__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___float__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___float__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___float__();
            }
        }
        pyObject.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyLong.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___hex__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hex__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___hex__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___hex__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___hex__();
            }
        }
        pyObject.__setitem__("__hex__", (PyObject)new PyMethodDescr("__hex__", PyLong.class, 0, 0, new Exposed___hex__(null, null)));
        class Exposed___int__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___int__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___int__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___int__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___int__();
            }
        }
        pyObject.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyLong.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___invert__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___invert__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___invert__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___invert__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___invert__();
            }
        }
        pyObject.__setitem__("__invert__", (PyObject)new PyMethodDescr("__invert__", PyLong.class, 0, 0, new Exposed___invert__(null, null)));
        class Exposed___long__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___long__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___long__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___long__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___long__();
            }
        }
        pyObject.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyLong.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___neg__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___neg__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___neg__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___neg__();
            }
        }
        pyObject.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyLong.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___oct__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___oct__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___oct__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___oct__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___oct__();
            }
        }
        pyObject.__setitem__("__oct__", (PyObject)new PyMethodDescr("__oct__", PyLong.class, 0, 0, new Exposed___oct__(null, null)));
        class Exposed___pos__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pos__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___pos__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.long___pos__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return pyLong.long___pos__();
            }
        }
        pyObject.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyLong.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___add__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___add__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___add__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___add__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyLong.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___and__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___and__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___and__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___and__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___and__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__and__", (PyObject)new PyMethodDescr("__and__", PyLong.class, 1, 1, new Exposed___and__(null, null)));
        class Exposed___div__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___div__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___div__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___div__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___div__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyLong.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___divmod__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___divmod__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___divmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___divmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyLong.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___floordiv__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___floordiv__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___floordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___floordiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyLong.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___lshift__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___lshift__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___lshift__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___lshift__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___lshift__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__lshift__", (PyObject)new PyMethodDescr("__lshift__", PyLong.class, 1, 1, new Exposed___lshift__(null, null)));
        class Exposed___mod__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mod__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___mod__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___mod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___mod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyLong.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mul__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___mul__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___mul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___mul__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyLong.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___or__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___or__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___or__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___or__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___or__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__or__", (PyObject)new PyMethodDescr("__or__", PyLong.class, 1, 1, new Exposed___or__(null, null)));
        class Exposed___radd__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___radd__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___radd__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___radd__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___radd__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyLong.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rdiv__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rdiv__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rdiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rdiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyLong.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rfloordiv__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rfloordiv__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rfloordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rfloordiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyLong.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmod__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rmod__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyLong.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmul__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rmul__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rmul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rmul__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyLong.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rshift__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rshift__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rshift__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rshift__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rshift__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rshift__", (PyObject)new PyMethodDescr("__rshift__", PyLong.class, 1, 1, new Exposed___rshift__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rsub__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rsub__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rsub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rsub__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyLong.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rtruediv__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rtruediv__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___rtruediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___rtruediv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyLong.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___sub__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___sub__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___sub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___sub__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyLong.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___truediv__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___truediv__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___truediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___truediv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyLong.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___xor__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___xor__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___xor__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___xor__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___xor__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__xor__", (PyObject)new PyMethodDescr("__xor__", PyLong.class, 1, 1, new Exposed___xor__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___cmp__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___cmp__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                int n = this.self.long___cmp__(pyObject);
                if (n == -2) {
                    throw Py.TypeError("long.__cmp__(x,y) requires y to be 'long', not a '" + pyObject.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                int n = pyLong.long___cmp__(pyObject2);
                if (n == -2) {
                    throw Py.TypeError("long.__cmp__(x,y) requires y to be 'long', not a '" + pyObject2.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }
        }
        pyObject.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyLong.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pow__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___pow__((PyLong)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                PyObject pyObject3 = this.self.long___pow__(pyObject, pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject4 = pyLong.long___pow__(pyObject2, pyObject3);
                if (pyObject4 == null) {
                    return Py.NotImplemented;
                }
                return pyObject4;
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.long___pow__(pyObject, null);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyLong pyLong = (PyLong)pyObject;
                PyObject pyObject3 = pyLong.long___pow__(pyObject2, null);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyLong.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___repr__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___repr__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___repr__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.long_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return new PyString(pyLong.long_toString());
            }
        }
        pyObject.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyLong.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___str__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___str__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.long_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return new PyString(pyLong.long_toString());
            }
        }
        pyObject.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyLong.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinFunctionNarrow {
            private PyLong self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hash__(PyLong pyLong, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyLong;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___hash__((PyLong)pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(this.self.long_hashCode());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyLong pyLong = (PyLong)pyObject;
                return Py.newInteger(pyLong.long_hashCode());
            }
        }
        pyObject.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyLong.class, 0, 0, new Exposed___hash__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(PyLong.class, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                return PyLong.long_new(this, bl, pyType, pyObjectArray, stringArray);
            }
        });
    }

    public static PyObject long_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, new String[]{"x", "base"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        int n = argParser.getInt(1, -909);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return Py.Zero;
            }
            Object object = pyObject.__tojava__(BigInteger.class);
            if (object != Py.NoConversion) {
                return Py.newLong((BigInteger)object);
            }
            if (n == -909) {
                return pyObject.__long__();
            }
            if (!(pyObject instanceof PyString)) {
                throw Py.TypeError("long: can't convert non-string with explicit base");
            }
            return ((PyString)pyObject).atol(n);
        }
        if (pyObject == null) {
            return new PyLongDerived(pyType, BigInteger.valueOf(0L));
        }
        Object object = pyObject.__tojava__(BigInteger.class);
        if (object != Py.NoConversion) {
            return new PyLongDerived(pyType, (BigInteger)object);
        }
        if (n == -909) {
            return new PyLongDerived(pyType, pyObject.__long__().getValue());
        }
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError("long: can't convert non-string with explicit base");
        }
        return new PyLongDerived(pyType, ((PyString)pyObject).atol(n).getValue());
    }

    public PyLong(PyType pyType, BigInteger bigInteger) {
        super(pyType);
        this.value = bigInteger;
    }

    public PyLong(BigInteger bigInteger) {
        this(LONGTYPE, bigInteger);
    }

    public PyLong(double d) {
        this(new BigDecimal(d).toBigInteger());
    }

    public PyLong(long l) {
        this(BigInteger.valueOf(l));
    }

    public PyLong(String string) {
        this(new BigInteger(string));
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String toString() {
        return this.long_toString();
    }

    final String long_toString() {
        return this.value.toString() + "L";
    }

    public int hashCode() {
        return this.long_hashCode();
    }

    final int long_hashCode() {
        return this.value.intValue();
    }

    public boolean __nonzero__() {
        return !this.value.equals(BigInteger.valueOf(0L));
    }

    public double doubleValue() {
        double d = this.value.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw Py.OverflowError("long int too long to convert");
        }
        return d;
    }

    private static final double scaledDoubleValue(BigInteger bigInteger, int[] nArray) {
        double d = 0.0;
        int n = bigInteger.signum();
        byte[] byArray = n >= 0 ? bigInteger.toByteArray() : bigInteger.negate().toByteArray();
        int n2 = 8;
        int n3 = 0;
        if (byArray[0] == 0) {
            ++n3;
            ++n2;
        }
        int n4 = n2 = n2 <= byArray.length ? n2 : byArray.length;
        while (n3 < n2) {
            d = d * 256.0 + (double)(byArray[n3] & 0xFF);
            ++n3;
        }
        nArray[0] = byArray.length - n3;
        return (double)n * d;
    }

    public double scaledDoubleValue(int[] nArray) {
        return PyLong.scaledDoubleValue(this.value, nArray);
    }

    private long getLong(long l, long l2) {
        long l3;
        if (this.value.compareTo(maxLong) <= 0 && this.value.compareTo(minLong) >= 0 && (l3 = this.value.longValue()) >= l && l3 <= l2) {
            return l3;
        }
        throw Py.OverflowError("long int too long to convert");
    }

    public long asLong(int n) {
        return this.getLong(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public Object __tojava__(Class clazz) {
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE || clazz == Float.class || clazz == Double.class) {
                return this.__float__().__tojava__(clazz);
            }
            if (clazz == BigInteger.class || clazz == Number.class || clazz == Object.class || clazz == Serializable.class) {
                return this.value;
            }
        }
        catch (PyException pyException) {
            return Py.NoConversion;
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.long___cmp__(pyObject);
    }

    final int long___cmp__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return -2;
        }
        return this.value.compareTo(PyLong.coerce(pyObject));
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return Py.newLong(((PyInteger)pyObject).getValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyLong || pyObject instanceof PyInteger;
    }

    private static final BigInteger coerce(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).value;
        }
        if (pyObject instanceof PyInteger) {
            return BigInteger.valueOf(((PyInteger)pyObject).getValue());
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.long___add__(pyObject);
    }

    final PyObject long___add__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.value.add(PyLong.coerce(pyObject)));
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.long___radd__(pyObject);
    }

    final PyObject long___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.long___sub__(pyObject);
    }

    final PyObject long___sub__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.value.subtract(PyLong.coerce(pyObject)));
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.long___rsub__(pyObject);
    }

    final PyObject long___rsub__(PyObject pyObject) {
        return Py.newLong(PyLong.coerce(pyObject).subtract(this.value));
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.long___mul__(pyObject);
    }

    final PyObject long___mul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.value.multiply(PyLong.coerce(pyObject)));
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.long___rmul__(pyObject);
    }

    final PyObject long___rmul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(pyObject).multiply(this.value));
    }

    private BigInteger divide(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = BigInteger.valueOf(0L);
        if (bigInteger2.equals(bigInteger3)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (bigInteger2.compareTo(bigInteger3) < 0) {
            if (bigInteger.compareTo(bigInteger3) > 0) {
                return bigInteger.subtract(bigInteger2).subtract(BigInteger.valueOf(1L)).divide(bigInteger2);
            }
        } else if (bigInteger.compareTo(bigInteger3) < 0) {
            return bigInteger.subtract(bigInteger2).add(BigInteger.valueOf(1L)).divide(bigInteger2);
        }
        return bigInteger.divide(bigInteger2);
    }

    public PyObject __div__(PyObject pyObject) {
        return this.long___div__(pyObject);
    }

    final PyObject long___div__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic long division");
        }
        return Py.newLong(this.divide(this.value, PyLong.coerce(pyObject)));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.long___rdiv__(pyObject);
    }

    final PyObject long___rdiv__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic long division");
        }
        return Py.newLong(this.divide(PyLong.coerce(pyObject), this.value));
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.long___floordiv__(pyObject);
    }

    final PyObject long___floordiv__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.divide(this.value, PyLong.coerce(pyObject)));
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.long___rfloordiv__(pyObject);
    }

    final PyObject long___rfloordiv__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.divide(PyLong.coerce(pyObject), this.value));
    }

    private static final PyFloat true_divide(BigInteger bigInteger, BigInteger bigInteger2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        double d = PyLong.scaledDoubleValue(bigInteger, nArray);
        double d2 = PyLong.scaledDoubleValue(bigInteger2, nArray2);
        if (d2 == 0.0) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        d /= d2;
        int n = nArray[0] - nArray2[0];
        if (n > 0xFFFFFFF) {
            throw Py.OverflowError("long/long too large for a float");
        }
        if (n < -268435455) {
            return new PyFloat(0.0);
        }
        if (Double.isInfinite(d *= Math.pow(2.0, n * 8))) {
            throw Py.OverflowError("long/long too large for a float");
        }
        return new PyFloat(d);
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.long___truediv__(pyObject);
    }

    final PyObject long___truediv__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return PyLong.true_divide(this.value, PyLong.coerce(pyObject));
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.long___rtruediv__(pyObject);
    }

    final PyObject long___rtruediv__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return PyLong.true_divide(PyLong.coerce(pyObject), this.value);
    }

    private BigInteger modulo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.subtract(bigInteger3.multiply(bigInteger2));
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.long___mod__(pyObject);
    }

    final PyObject long___mod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        return Py.newLong(this.modulo(this.value, bigInteger, this.divide(this.value, bigInteger)));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.long___rmod__(pyObject);
    }

    final PyObject long___rmod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        return Py.newLong(this.modulo(bigInteger, this.value, this.divide(bigInteger, this.value)));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.long___divmod__(pyObject);
    }

    final PyObject long___divmod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        BigInteger bigInteger2 = this.divide(this.value, bigInteger);
        return new PyTuple(new PyObject[]{Py.newLong(bigInteger2), Py.newLong(this.modulo(this.value, bigInteger, bigInteger2))});
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        return this.long___rdivmod__(pyObject);
    }

    final PyObject long___rdivmod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        BigInteger bigInteger2 = this.divide(bigInteger, this.value);
        return new PyTuple(new PyObject[]{Py.newLong(bigInteger2), Py.newLong(this.modulo(bigInteger, this.value, bigInteger2))});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.long___pow__(pyObject, pyObject2);
    }

    final PyObject long___pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyLong.canCoerce(pyObject)) {
            return null;
        }
        return PyLong._pow(this.value, PyLong.coerce(pyObject), pyObject2, this, pyObject);
    }

    public PyObject __rpow__(PyObject pyObject) {
        return this.long___rpow__(pyObject);
    }

    final PyObject long___rpow__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return PyLong._pow(PyLong.coerce(pyObject), this.value, null, pyObject, this);
    }

    public static PyObject _pow(BigInteger bigInteger, BigInteger bigInteger2, PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (bigInteger2.compareTo(BigInteger.valueOf(0L)) < 0) {
            if (bigInteger.compareTo(BigInteger.valueOf(0L)) != 0) {
                return pyObject2.__float__().__pow__(pyObject3, pyObject);
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (pyObject == null) {
            return Py.newLong(bigInteger.pow(bigInteger2.intValue()));
        }
        BigInteger bigInteger3 = PyLong.coerce(pyObject);
        int n = bigInteger3.intValue();
        if (n == 0) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (n == 1 || n == -1) {
            return Py.newLong(0);
        }
        if (bigInteger3.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((bigInteger2 = bigInteger.modPow(bigInteger2, bigInteger3.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return Py.newLong(bigInteger3.add(bigInteger2));
            }
            return Py.newLong(bigInteger2);
        }
        return Py.newLong(bigInteger.modPow(bigInteger2, bigInteger3));
    }

    private static final int coerceInt(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return (int)((PyLong)pyObject).getLong(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __lshift__(PyObject pyObject) {
        return this.long___lshift__(pyObject);
    }

    final PyObject long___lshift__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        int n = PyLong.coerceInt(pyObject);
        if (n < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newLong(this.value.shiftLeft(n));
    }

    public PyObject __rshift__(PyObject pyObject) {
        return this.long___rshift__(pyObject);
    }

    final PyObject long___rshift__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        int n = PyLong.coerceInt(pyObject);
        if (n < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newLong(this.value.shiftRight(n));
    }

    public PyObject __and__(PyObject pyObject) {
        return this.long___and__(pyObject);
    }

    final PyObject long___and__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.value.and(PyLong.coerce(pyObject)));
    }

    public PyObject __rand__(PyObject pyObject) {
        return this.long___rand__(pyObject);
    }

    final PyObject long___rand__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(pyObject).and(this.value));
    }

    public PyObject __xor__(PyObject pyObject) {
        return this.long___xor__(pyObject);
    }

    final PyObject long___xor__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.value.xor(PyLong.coerce(pyObject)));
    }

    public PyObject __rxor__(PyObject pyObject) {
        return this.long___rxor__(pyObject);
    }

    final PyObject long___rxor__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(pyObject).xor(this.value));
    }

    public PyObject __or__(PyObject pyObject) {
        return this.long___or__(pyObject);
    }

    final PyObject long___or__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(this.value.or(PyLong.coerce(pyObject)));
    }

    public PyObject __ror__(PyObject pyObject) {
        return this.long___ror__(pyObject);
    }

    final PyObject long___ror__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(pyObject).or(this.value));
    }

    public PyObject __neg__() {
        return this.long___neg__();
    }

    final PyObject long___neg__() {
        return Py.newLong(this.value.negate());
    }

    public PyObject __pos__() {
        return this.long___pos__();
    }

    final PyObject long___pos__() {
        return Py.newLong(this.value);
    }

    public PyObject __abs__() {
        return this.long___abs__();
    }

    final PyObject long___abs__() {
        return Py.newLong(this.value.abs());
    }

    public PyObject __invert__() {
        return this.long___invert__();
    }

    final PyObject long___invert__() {
        return Py.newLong(this.value.not());
    }

    public PyObject __int__() {
        return this.long___int__();
    }

    final PyObject long___int__() {
        long l = this.value.longValue();
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            return Py.newLong(this.value);
        }
        return Py.newInteger((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public PyLong __long__() {
        return this.long___long__();
    }

    final PyLong long___long__() {
        return Py.newLong(this.value);
    }

    public PyFloat __float__() {
        return this.long___float__();
    }

    final PyFloat long___float__() {
        return new PyFloat(this.doubleValue());
    }

    public PyComplex __complex__() {
        return this.long___complex__();
    }

    final PyComplex long___complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    public PyString __oct__() {
        return this.long___oct__();
    }

    final PyString long___oct__() {
        String string = this.value.toString(8);
        if (string.startsWith("-")) {
            return new PyString("-0" + string.substring(1, string.length()) + "L");
        }
        if (string.startsWith("0")) {
            return new PyString(string + "L");
        }
        return new PyString("0" + string + "L");
    }

    public PyString __hex__() {
        return this.long___hex__();
    }

    final PyString long___hex__() {
        String string = this.value.toString(16).toUpperCase();
        if (string.startsWith("-")) {
            return new PyString("-0x" + string.substring(1, string.length()) + "L");
        }
        return new PyString("0x" + string + "L");
    }

    public PyString __str__() {
        return Py.newString(this.value.toString());
    }

    public PyUnicode __unicode__() {
        return new PyUnicode(this.value.toString());
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }
}

