/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyComplex;
import org.python.core.PyFloatDerived;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyFloat
extends PyObject {
    public static final String exposed_name = "float";
    private static final PyType FLOATTYPE = PyType.fromClass(PyFloat.class);
    private double value;

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        class Exposed___abs__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___abs__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___abs__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.float___abs__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return pyFloat.float___abs__();
            }
        }
        pyObject.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyFloat.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___float__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___float__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.float___float__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return pyFloat.float___float__();
            }
        }
        pyObject.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyFloat.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___int__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___int__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___int__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.float___int__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return pyFloat.float___int__();
            }
        }
        pyObject.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyFloat.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___long__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___long__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___long__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.float___long__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return pyFloat.float___long__();
            }
        }
        pyObject.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyFloat.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___neg__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___neg__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.float___neg__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return pyFloat.float___neg__();
            }
        }
        pyObject.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyFloat.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___pos__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pos__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___pos__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.float___pos__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return pyFloat.float___pos__();
            }
        }
        pyObject.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyFloat.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___add__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___add__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___add__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___add__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyFloat.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___div__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___div__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___div__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___div__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___div__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyFloat.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___divmod__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___divmod__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___divmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___divmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyFloat.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___floordiv__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___floordiv__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___floordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___floordiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyFloat.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___mod__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mod__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___mod__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___mod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___mod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyFloat.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mul__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___mul__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___mul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___mul__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyFloat.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___radd__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___radd__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___radd__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___radd__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___radd__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyFloat.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rdiv__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rdiv__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___rdiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___rdiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyFloat.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rfloordiv__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rfloordiv__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___rfloordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___rfloordiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyFloat.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmod__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rmod__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___rmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___rmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyFloat.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmul__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rmul__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___rmul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___rmul__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyFloat.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rsub__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rsub__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___rsub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___rsub__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyFloat.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rtruediv__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rtruediv__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___rtruediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___rtruediv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyFloat.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___sub__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___sub__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___sub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___sub__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyFloat.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___truediv__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___truediv__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___truediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___truediv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyFloat.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___cmp__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___cmp__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                int n = this.self.float___cmp__(pyObject);
                if (n == -2) {
                    throw Py.TypeError("float.__cmp__(x,y) requires y to be 'float', not a '" + pyObject.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                int n = pyFloat.float___cmp__(pyObject2);
                if (n == -2) {
                    throw Py.TypeError("float.__cmp__(x,y) requires y to be 'float', not a '" + pyObject2.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }
        }
        pyObject.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyFloat.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pow__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___pow__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                PyObject pyObject3 = this.self.float___pow__(pyObject, pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject4 = pyFloat.float___pow__(pyObject2, pyObject3);
                if (pyObject4 == null) {
                    return Py.NotImplemented;
                }
                return pyObject4;
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.float___pow__(pyObject, null);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyFloat pyFloat = (PyFloat)pyObject;
                PyObject pyObject3 = pyFloat.float___pow__(pyObject2, null);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyFloat.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___nonzero__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___nonzero__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(this.self.float___nonzero__());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return Py.newBoolean(pyFloat.float___nonzero__());
            }
        }
        pyObject.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyFloat.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___repr__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___repr__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___repr__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.float_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return new PyString(pyFloat.float_toString());
            }
        }
        pyObject.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyFloat.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___str__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___str__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.float_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return new PyString(pyFloat.float_toString());
            }
        }
        pyObject.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyFloat.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinFunctionNarrow {
            private PyFloat self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hash__(PyFloat pyFloat, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyFloat;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___hash__((PyFloat)pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(this.self.float_hashCode());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyFloat pyFloat = (PyFloat)pyObject;
                return Py.newInteger(pyFloat.float_hashCode());
            }
        }
        pyObject.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyFloat.class, 0, 0, new Exposed___hash__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(PyFloat.class, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                return PyFloat.float_new(this, bl, pyType, pyObjectArray, stringArray);
            }
        });
    }

    public static PyObject float_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, new String[]{"x"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return new PyFloat(0.0);
            }
            return pyObject.__float__();
        }
        if (pyObject == null) {
            return new PyFloatDerived(pyType, 0.0);
        }
        return new PyFloatDerived(pyType, pyObject.__float__().getValue());
    }

    public PyFloat(PyType pyType, double d) {
        super(pyType);
        this.value = d;
    }

    public PyFloat(double d) {
        this(FLOATTYPE, d);
    }

    public PyFloat(float f) {
        this((double)f);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.float_toString();
    }

    final String float_toString() {
        String string = Double.toString(this.value);
        if (string.indexOf(69) == -1) {
            int n;
            while ((n = string.length()) > 2 && string.charAt(n - 1) == '0' && string.charAt(n - 2) != '.') {
                string = string.substring(0, n - 1);
            }
        }
        return string;
    }

    public int hashCode() {
        return this.float_hashCode();
    }

    final int float_hashCode() {
        double d = Math.floor(this.value);
        double d2 = this.value - d;
        if (d2 == 0.0) {
            if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.float___nonzero__();
    }

    final boolean float___nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Double.TYPE || clazz == Number.class || clazz == Double.class || clazz == Object.class || clazz == Serializable.class) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value);
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.float___cmp__(pyObject);
    }

    final int float___cmp__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return -2;
        }
        double d = PyFloat.coerce(pyObject);
        return this.value < d ? -1 : (this.value > d ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PyLong) {
            return new PyFloat(((PyLong)pyObject).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyFloat || pyObject instanceof PyInteger || pyObject instanceof PyLong;
    }

    private static final double coerce(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).value;
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.float___add__(pyObject);
    }

    final PyObject float___add__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value + d);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.float___radd__(pyObject);
    }

    final PyObject float___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.float___sub__(pyObject);
    }

    final PyObject float___sub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value - d);
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.float___rsub__(pyObject);
    }

    final PyObject float___rsub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(d - this.value);
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.float___mul__(pyObject);
    }

    final PyObject float___mul__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value * d);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.float___rmul__(pyObject);
    }

    final PyObject float___rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    public PyObject __div__(PyObject pyObject) {
        return this.float___div__(pyObject);
    }

    final PyObject float___div__(PyObject pyObject) {
        double d;
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        if ((d = PyFloat.coerce(pyObject)) == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.float___rdiv__(pyObject);
    }

    final PyObject float___rdiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.float___floordiv__(pyObject);
    }

    final PyObject float___floordiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(this.value / d));
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.float___rfloordiv__(pyObject);
    }

    final PyObject float___rfloordiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(d / this.value));
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.float___truediv__(pyObject);
    }

    final PyObject float___truediv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.float___rtruediv__(pyObject);
    }

    final PyObject float___rtruediv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    private static double modulo(double d, double d2) {
        if (d2 == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double d3 = Math.IEEEremainder(d, d2);
        if (d3 * d2 < 0.0) {
            d3 += d2;
        }
        return d3;
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.float___mod__(pyObject);
    }

    final PyObject float___mod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(this.value, d));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.float___rmod__(pyObject);
    }

    final PyObject float___rmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(d, this.value));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.float___divmod__(pyObject);
    }

    final PyObject float___divmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(this.value / d);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(this.value - d2 * d)});
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(d / this.value);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(d - d2 * this.value)});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.float___pow__(pyObject, pyObject2);
    }

    final PyObject float___pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null) {
            throw Py.TypeError("pow() 3rd argument not allowed unless all arguments are integers");
        }
        return PyFloat._pow(this.value, PyFloat.coerce(pyObject), pyObject2);
    }

    public PyObject __rpow__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(pyObject), this.value, null);
    }

    private static PyFloat _pow(double d, double d2, PyObject pyObject) {
        if (d2 == 0.0) {
            if (pyObject != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(pyObject)));
            }
            return new PyFloat(1.0);
        }
        if (d == 0.0) {
            if (d2 < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        double d3 = Math.pow(d, d2);
        if (pyObject == null) {
            return new PyFloat(d3);
        }
        return new PyFloat(PyFloat.modulo(d3, PyFloat.coerce(pyObject)));
    }

    public PyObject __neg__() {
        return this.float___neg__();
    }

    final PyObject float___neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this.float___pos__();
    }

    final PyObject float___pos__() {
        return Py.newFloat(this.value);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.float___abs__();
    }

    final PyObject float___abs__() {
        if (this.value >= 0.0) {
            return Py.newFloat(this.value);
        }
        return this.__neg__();
    }

    public PyObject __int__() {
        return this.float___int__();
    }

    final PyInteger float___int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    public PyLong __long__() {
        return this.float___long__();
    }

    final PyLong float___long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this.float___float__();
    }

    final PyFloat float___float__() {
        return Py.newFloat(this.value);
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isSequenceType() throws PyIgnoreMethodTag {
        return false;
    }
}

