/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Arrays;
import org.python.compiler.APIVersion;
import org.python.compiler.Filename;
import org.python.compiler.MTime;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyFunctionTable;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.imp;

@APIVersion(value=39)
@MTime(value=1661668918129L)
@Filename(value="D:\\git\\work\\build2\\resources\\main\\Lib\\heapq.py")
public class heapq$py
extends PyFunctionTable
implements PyRunnable {
    static heapq$py self;
    static final PyCode f$0;
    static final PyCode cmp_lt$1;
    static final PyCode heappush$2;
    static final PyCode heappop$3;
    static final PyCode heapreplace$4;
    static final PyCode heappushpop$5;
    static final PyCode heapify$6;
    static final PyCode _heappushpop_max$7;
    static final PyCode _heapify_max$8;
    static final PyCode nlargest$9;
    static final PyCode nsmallest$10;
    static final PyCode _siftdown$11;
    static final PyCode _siftup$12;
    static final PyCode _siftdown_max$13;
    static final PyCode _siftup_max$14;
    static final PyCode merge$15;
    static final PyCode nsmallest$16;
    static final PyCode nlargest$17;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PyObject f$0(PyFrame pyFrame, ThreadState threadState) {
        block7: {
            Object object;
            block11: {
                block10: {
                    block9: {
                        Object object2;
                        block8: {
                            pyFrame.setglobal("__doc__", PyString.fromInterned("Heap queue algorithm (a.k.a. priority queue).\n\nHeaps are arrays for which a[k] <= a[2*k+1] and a[k] <= a[2*k+2] for\nall k, counting elements from 0.  For the sake of comparison,\nnon-existing elements are considered to be infinite.  The interesting\nproperty of a heap is that a[0] is always its smallest element.\n\nUsage:\n\nheap = []            # creates an empty heap\nheappush(heap, item) # pushes a new item on the heap\nitem = heappop(heap) # pops the smallest item from the heap\nitem = heap[0]       # smallest item on the heap without popping it\nheapify(x)           # transforms list into a heap, in-place, in linear time\nitem = heapreplace(heap, item) # pops and returns smallest item, and adds\n                               # new item; the heap size is unchanged\n\nOur API differs from textbook heap algorithms as follows:\n\n- We use 0-based indexing.  This makes the relationship between the\n  index for a node and the indexes for its children slightly less\n  obvious, but is more suitable since Python uses 0-based indexing.\n\n- Our heappop() method returns the smallest item, not the largest.\n\nThese two make it possible to view the heap as a regular Python list\nwithout surprises: heap[0] is the smallest item, and heap.sort()\nmaintains the heap invariant!\n"));
                            pyFrame.setline(31);
                            PyString.fromInterned("Heap queue algorithm (a.k.a. priority queue).\n\nHeaps are arrays for which a[k] <= a[2*k+1] and a[k] <= a[2*k+2] for\nall k, counting elements from 0.  For the sake of comparison,\nnon-existing elements are considered to be infinite.  The interesting\nproperty of a heap is that a[0] is always its smallest element.\n\nUsage:\n\nheap = []            # creates an empty heap\nheappush(heap, item) # pushes a new item on the heap\nitem = heappop(heap) # pops the smallest item from the heap\nitem = heap[0]       # smallest item on the heap without popping it\nheapify(x)           # transforms list into a heap, in-place, in linear time\nitem = heapreplace(heap, item) # pops and returns smallest item, and adds\n                               # new item; the heap size is unchanged\n\nOur API differs from textbook heap algorithms as follows:\n\n- We use 0-based indexing.  This makes the relationship between the\n  index for a node and the indexes for its children slightly less\n  obvious, but is more suitable since Python uses 0-based indexing.\n\n- Our heappop() method returns the smallest item, not the largest.\n\nThese two make it possible to view the heap as a regular Python list\nwithout surprises: heap[0] is the smallest item, and heap.sort()\nmaintains the heap invariant!\n");
                            pyFrame.setline(35);
                            object = PyString.fromInterned("Heap queues\n\n[explanation by Fran\u00e7ois Pinard]\n\nHeaps are arrays for which a[k] <= a[2*k+1] and a[k] <= a[2*k+2] for\nall k, counting elements from 0.  For the sake of comparison,\nnon-existing elements are considered to be infinite.  The interesting\nproperty of a heap is that a[0] is always its smallest element.\n\nThe strange invariant above is meant to be an efficient memory\nrepresentation for a tournament.  The numbers below are `k', not a[k]:\n\n                                   0\n\n                  1                                 2\n\n          3               4                5               6\n\n      7       8       9       10      11      12      13      14\n\n    15 16   17 18   19 20   21 22   23 24   25 26   27 28   29 30\n\n\nIn the tree above, each cell `k' is topping `2*k+1' and `2*k+2'.  In\nan usual binary tournament we see in sports, each cell is the winner\nover the two cells it tops, and we can trace the winner down the tree\nto see all opponents s/he had.  However, in many computer applications\nof such tournaments, we do not need to trace the history of a winner.\nTo be more memory efficient, when a winner is promoted, we try to\nreplace it by something else at a lower level, and the rule becomes\nthat a cell and the two cells it tops contain three different items,\nbut the top cell \"wins\" over the two topped cells.\n\nIf this heap invariant is protected at all time, index 0 is clearly\nthe overall winner.  The simplest algorithmic way to remove it and\nfind the \"next\" winner is to move some loser (let's say cell 30 in the\ndiagram above) into the 0 position, and then percolate this new 0 down\nthe tree, exchanging values, until the invariant is re-established.\nThis is clearly logarithmic on the total number of items in the tree.\nBy iterating over all items, you get an O(n ln n) sort.\n\nA nice feature of this sort is that you can efficiently insert new\nitems while the sort is going on, provided that the inserted items are\nnot \"better\" than the last 0'th element you extracted.  This is\nespecially useful in simulation contexts, where the tree holds all\nincoming events, and the \"win\" condition means the smallest scheduled\ntime.  When an event schedule other events for execution, they are\nscheduled into the future, so they can easily go into the heap.  So, a\nheap is a good structure for implementing schedulers (this is what I\nused for my MIDI sequencer :-).\n\nVarious structures for implementing schedulers have been extensively\nstudied, and heaps are good for this, as they are reasonably speedy,\nthe speed is almost constant, and the worst case is not much different\nthan the average case.  However, there are other representations which\nare more efficient overall, yet the worst cases might be terrible.\n\nHeaps are also very useful in big disk sorts.  You most probably all\nknow that a big sort implies producing \"runs\" (which are pre-sorted\nsequences, which size is usually related to the amount of CPU memory),\nfollowed by a merging passes for these runs, which merging is often\nvery cleverly organised[1].  It is very important that the initial\nsort produces the longest runs possible.  Tournaments are a good way\nto that.  If, using all the memory available to hold a tournament, you\nreplace and percolate items that happen to fit the current run, you'll\nproduce runs which are twice the size of the memory for random input,\nand much better for input fuzzily ordered.\n\nMoreover, if you output the 0'th item on disk and get an input which\nmay not fit in the current tournament (because the value \"wins\" over\nthe last output value), it cannot fit in the heap, so the size of the\nheap decreases.  The freed memory could be cleverly reused immediately\nfor progressively building a second heap, which grows at exactly the\nsame rate the first heap is melting.  When the first heap completely\nvanishes, you switch heaps and start a new run.  Clever and quite\neffective!\n\nIn a word, heaps are useful memory structures to know.  I use them in\na few applications, and I think it is good to keep a `heap' module\naround. :-)\n\n--------------------\n[1] The disk balancing algorithms which are current, nowadays, are\nmore annoying than clever, and this is a consequence of the seeking\ncapabilities of the disks.  On devices which cannot seek, like big\ntape drives, the story was quite different, and one had to be very\nclever to ensure (far in advance) that each tape movement will be the\nmost effective possible (that is, will best participate at\n\"progressing\" the merge).  Some tapes were even able to read\nbackwards, and this was also used to avoid the rewinding time.\nBelieve me, real good tape sorts were quite spectacular to watch!\nFrom all times, sorting has always been a Great Art! :-)\n");
                            pyFrame.setlocal("__about__", (PyObject)object);
                            object = null;
                            pyFrame.setline(129);
                            object = new PyList(new PyObject[]{PyString.fromInterned("heappush"), PyString.fromInterned("heappop"), PyString.fromInterned("heapify"), PyString.fromInterned("heapreplace"), PyString.fromInterned("merge"), PyString.fromInterned("nlargest"), PyString.fromInterned("nsmallest"), PyString.fromInterned("heappushpop")});
                            pyFrame.setlocal("__all__", (PyObject)object);
                            object = null;
                            pyFrame.setline(132);
                            object = new String[]{"islice", "count", "imap", "izip", "tee", "chain"};
                            object = imp.importFrom("itertools", (String[])object, pyFrame, -1);
                            object2 = object[0];
                            pyFrame.setlocal("islice", (PyObject)object2);
                            object2 = null;
                            object2 = object[1];
                            pyFrame.setlocal("count", (PyObject)object2);
                            object2 = null;
                            object2 = object[2];
                            pyFrame.setlocal("imap", (PyObject)object2);
                            object2 = null;
                            object2 = object[3];
                            pyFrame.setlocal("izip", (PyObject)object2);
                            object2 = null;
                            object2 = object[4];
                            pyFrame.setlocal("tee", (PyObject)object2);
                            object2 = null;
                            object2 = object[5];
                            pyFrame.setlocal("chain", (PyObject)object2);
                            object2 = null;
                            pyFrame.setline(133);
                            object = new String[]{"itemgetter"};
                            object = imp.importFrom("operator", (String[])object, pyFrame, -1);
                            object2 = object[0];
                            pyFrame.setlocal("itemgetter", (PyObject)object2);
                            object2 = null;
                            pyFrame.setline(135);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, cmp_lt$1, null);
                            pyFrame.setlocal("cmp_lt", (PyObject)object);
                            object = null;
                            pyFrame.setline(140);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, heappush$2, PyString.fromInterned("Push item onto heap, maintaining the heap invariant."));
                            pyFrame.setlocal("heappush", (PyObject)object);
                            object = null;
                            pyFrame.setline(145);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, heappop$3, PyString.fromInterned("Pop the smallest item off the heap, maintaining the heap invariant."));
                            pyFrame.setlocal("heappop", (PyObject)object);
                            object = null;
                            pyFrame.setline(156);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, heapreplace$4, PyString.fromInterned("Pop and return the current smallest value, and add the new item.\n\n    This is more efficient than heappop() followed by heappush(), and can be\n    more appropriate when using a fixed-size heap.  Note that the value\n    returned may be larger than item!  That constrains reasonable uses of\n    this routine unless written as part of a conditional replacement:\n\n        if item > heap[0]:\n            item = heapreplace(heap, item)\n    "));
                            pyFrame.setlocal("heapreplace", (PyObject)object);
                            object = null;
                            pyFrame.setline(172);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, heappushpop$5, PyString.fromInterned("Fast version of a heappush followed by a heappop."));
                            pyFrame.setlocal("heappushpop", (PyObject)object);
                            object = null;
                            pyFrame.setline(179);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, heapify$6, PyString.fromInterned("Transform list into a heap, in-place, in O(len(x)) time."));
                            pyFrame.setlocal("heapify", (PyObject)object);
                            object = null;
                            pyFrame.setline(190);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _heappushpop_max$7, PyString.fromInterned("Maxheap version of a heappush followed by a heappop."));
                            pyFrame.setlocal("_heappushpop_max", (PyObject)object);
                            object = null;
                            pyFrame.setline(197);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _heapify_max$8, PyString.fromInterned("Transform list into a maxheap, in-place, in O(len(x)) time."));
                            pyFrame.setlocal("_heapify_max", (PyObject)object);
                            object = null;
                            pyFrame.setline(203);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, nlargest$9, PyString.fromInterned("Find the n largest elements in a dataset.\n\n    Equivalent to:  sorted(iterable, reverse=True)[:n]\n    "));
                            pyFrame.setlocal("nlargest", (PyObject)object);
                            object = null;
                            pyFrame.setline(221);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, nsmallest$10, PyString.fromInterned("Find the n smallest elements in a dataset.\n\n    Equivalent to:  sorted(iterable)[:n]\n    "));
                            pyFrame.setlocal("nsmallest", (PyObject)object);
                            object = null;
                            pyFrame.setline(242);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _siftdown$11, null);
                            pyFrame.setlocal("_siftdown", (PyObject)object);
                            object = null;
                            pyFrame.setline(295);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _siftup$12, null);
                            pyFrame.setlocal("_siftup", (PyObject)object);
                            object = null;
                            pyFrame.setline(315);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _siftdown_max$13, PyString.fromInterned("Maxheap variant of _siftdown"));
                            pyFrame.setlocal("_siftdown_max", (PyObject)object);
                            object = null;
                            pyFrame.setline(330);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _siftup_max$14, PyString.fromInterned("Maxheap variant of _siftup"));
                            pyFrame.setlocal("_siftup_max", (PyObject)object);
                            object = null;
                            try {
                                pyFrame.setline(353);
                                imp.importAll("_heapq", pyFrame, -1);
                            }
                            catch (Throwable throwable) {
                                object = Py.setException(throwable, pyFrame);
                                if (!((PyException)object).match(pyFrame.getname("ImportError"))) {
                                    throw object;
                                }
                                pyFrame.setline(355);
                            }
                            pyFrame.setline(357);
                            object = Py.EmptyObjects;
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, merge$15, PyString.fromInterned("Merge multiple sorted inputs into a single sorted output.\n\n    Similar to sorted(itertools.chain(*iterables)) but returns a generator,\n    does not pull the data into memory all at once, and assumes that each of\n    the input streams is already sorted (smallest to largest).\n\n    >>> list(merge([1,3,5,7], [0,2,4,8], [5,10,15,20], [], [25]))\n    [0, 1, 2, 3, 4, 5, 5, 7, 8, 10, 15, 20, 25]\n\n    "));
                            pyFrame.setlocal("merge", (PyObject)object);
                            object = null;
                            pyFrame.setline(393);
                            object = pyFrame.getname("nsmallest");
                            pyFrame.setlocal("_nsmallest", (PyObject)object);
                            object = null;
                            pyFrame.setline(394);
                            object = new PyObject[]{pyFrame.getname("None")};
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, nsmallest$16, PyString.fromInterned("Find the n smallest elements in a dataset.\n\n    Equivalent to:  sorted(iterable, key=key)[:n]\n    "));
                            pyFrame.setlocal("nsmallest", (PyObject)object);
                            object = null;
                            pyFrame.setline(430);
                            object = pyFrame.getname("nlargest");
                            pyFrame.setlocal("_nlargest", (PyObject)object);
                            object = null;
                            pyFrame.setline(431);
                            object = new PyObject[]{pyFrame.getname("None")};
                            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, nlargest$17, PyString.fromInterned("Find the n largest elements in a dataset.\n\n    Equivalent to:  sorted(iterable, key=key, reverse=True)[:n]\n    "));
                            pyFrame.setlocal("nlargest", (PyObject)object);
                            object = null;
                            pyFrame.setline(468);
                            object = pyFrame.getname("__name__");
                            PyObject pyObject = ((PyObject)object)._eq(PyString.fromInterned("__main__"));
                            object = null;
                            if (!pyObject.__nonzero__()) break block7;
                            pyFrame.setline(470);
                            object = new PyList(Py.EmptyObjects);
                            pyFrame.setlocal("heap", (PyObject)object);
                            object = null;
                            pyFrame.setline(471);
                            object = new PyList(new PyObject[]{Py.newInteger(1), Py.newInteger(3), Py.newInteger(5), Py.newInteger(7), Py.newInteger(9), Py.newInteger(2), Py.newInteger(4), Py.newInteger(6), Py.newInteger(8), Py.newInteger(0)});
                            pyFrame.setlocal("data", (PyObject)object);
                            object = null;
                            pyFrame.setline(472);
                            object = pyFrame.getname("data").__iter__();
                            if (!true) break block8;
                            pyFrame.setline(472);
                            if ((object2 = ((PyObject)object).__iternext__()) == null) break block9;
                        }
                        do {
                            pyFrame.setlocal("item", (PyObject)object2);
                            pyFrame.setline(473);
                            pyFrame.getname("heappush").__call__(threadState, pyFrame.getname("heap"), pyFrame.getname("item"));
                            pyFrame.setline(472);
                        } while ((object2 = ((PyObject)object).__iternext__()) != null);
                    }
                    pyFrame.setline(474);
                    object = new PyList(Py.EmptyObjects);
                    pyFrame.setlocal("sort", (PyObject)object);
                    object = null;
                    if (!true) break block10;
                    pyFrame.setline(475);
                    if (!pyFrame.getname("heap").__nonzero__()) break block11;
                }
                do {
                    pyFrame.setline(476);
                    pyFrame.getname("sort").__getattr__("append").__call__(threadState, pyFrame.getname("heappop").__call__(threadState, pyFrame.getname("heap")));
                    pyFrame.setline(475);
                } while (pyFrame.getname("heap").__nonzero__());
            }
            pyFrame.setline(477);
            Py.println(pyFrame.getname("sort"));
            pyFrame.setline(479);
            object = imp.importOne("doctest", pyFrame, -1);
            pyFrame.setlocal("doctest", (PyObject)object);
            object = null;
            pyFrame.setline(480);
            pyFrame.getname("doctest").__getattr__("testmod").__call__(threadState);
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject cmp_lt$1(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        PyObject pyObject2;
        pyFrame.setline(138);
        pyFrame.setline(138);
        if (pyFrame.getglobal("hasattr").__call__(threadState, pyFrame.getlocal(0), (PyObject)PyString.fromInterned("__lt__")).__nonzero__()) {
            pyObject2 = pyFrame.getlocal(0);
            pyObject = pyObject2._lt(pyFrame.getlocal(1));
            pyObject2 = null;
        } else {
            pyObject2 = pyFrame.getlocal(1);
            PyObject pyObject3 = pyObject2._le(pyFrame.getlocal(0));
            pyObject2 = null;
            pyObject = pyObject3.__not__();
        }
        pyObject2 = pyObject;
        pyFrame.f_lasti = -1;
        return pyObject2;
    }

    public PyObject heappush$2(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(141);
        PyString.fromInterned("Push item onto heap, maintaining the heap invariant.");
        pyFrame.setline(142);
        pyFrame.getlocal(0).__getattr__("append").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.setline(143);
        pyFrame.getglobal("_siftdown").__call__(threadState, pyFrame.getlocal(0), (PyObject)Py.newInteger(0), pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(0))._sub(Py.newInteger(1)));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject heappop$3(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(146);
        PyString.fromInterned("Pop the smallest item off the heap, maintaining the heap invariant.");
        pyFrame.setline(147);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("pop").__call__(threadState);
        pyFrame.setlocal(1, pyObject);
        pyObject = null;
        pyFrame.setline(148);
        if (pyFrame.getlocal(0).__nonzero__()) {
            pyFrame.setline(149);
            pyObject = pyFrame.getlocal(0).__getitem__(Py.newInteger(0));
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
            pyFrame.setline(150);
            pyObject = pyFrame.getlocal(1);
            pyFrame.getlocal(0).__setitem__(Py.newInteger(0), pyObject);
            pyObject = null;
            pyFrame.setline(151);
            pyFrame.getglobal("_siftup").__call__(threadState, pyFrame.getlocal(0), (PyObject)Py.newInteger(0));
        } else {
            pyFrame.setline(153);
            pyObject = pyFrame.getlocal(1);
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(154);
        pyObject = pyFrame.getlocal(2);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject heapreplace$4(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(166);
        PyString.fromInterned("Pop and return the current smallest value, and add the new item.\n\n    This is more efficient than heappop() followed by heappush(), and can be\n    more appropriate when using a fixed-size heap.  Note that the value\n    returned may be larger than item!  That constrains reasonable uses of\n    this routine unless written as part of a conditional replacement:\n\n        if item > heap[0]:\n            item = heapreplace(heap, item)\n    ");
        pyFrame.setline(167);
        PyObject pyObject = pyFrame.getlocal(0).__getitem__(Py.newInteger(0));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(168);
        pyObject = pyFrame.getlocal(1);
        pyFrame.getlocal(0).__setitem__(Py.newInteger(0), pyObject);
        pyObject = null;
        pyFrame.setline(169);
        pyFrame.getglobal("_siftup").__call__(threadState, pyFrame.getlocal(0), (PyObject)Py.newInteger(0));
        pyFrame.setline(170);
        pyObject = pyFrame.getlocal(2);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject heappushpop$5(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(173);
        PyString.fromInterned("Fast version of a heappush followed by a heappop.");
        pyFrame.setline(174);
        PyObject pyObject2 = pyFrame.getlocal(0);
        if (pyObject2.__nonzero__()) {
            pyObject2 = pyFrame.getglobal("cmp_lt").__call__(threadState, pyFrame.getlocal(0).__getitem__(Py.newInteger(0)), pyFrame.getlocal(1));
        }
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(175);
            pyObject = new PyTuple(pyFrame.getlocal(0).__getitem__(Py.newInteger(0)), pyFrame.getlocal(1));
            PyObject[] pyObjectArray = Py.unpackSequence(pyObject, 2);
            PyObject pyObject3 = pyObjectArray[0];
            pyFrame.setlocal(1, pyObject3);
            pyObject3 = null;
            pyObject3 = pyObjectArray[1];
            pyFrame.getlocal(0).__setitem__(Py.newInteger(0), pyObject3);
            pyObject3 = null;
            pyObject = null;
            pyFrame.setline(176);
            pyFrame.getglobal("_siftup").__call__(threadState, pyFrame.getlocal(0), (PyObject)Py.newInteger(0));
        }
        pyFrame.setline(177);
        pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject heapify$6(PyFrame pyFrame, ThreadState threadState) {
        block3: {
            PyObject pyObject;
            PyObject pyObject2;
            block2: {
                pyFrame.setline(180);
                PyString.fromInterned("Transform list into a heap, in-place, in O(len(x)) time.");
                pyFrame.setline(181);
                pyObject2 = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(0));
                pyFrame.setlocal(1, pyObject2);
                pyObject2 = null;
                pyFrame.setline(187);
                pyObject2 = pyFrame.getglobal("reversed").__call__(threadState, pyFrame.getglobal("xrange").__call__(threadState, pyFrame.getlocal(1)._floordiv(Py.newInteger(2)))).__iter__();
                if (!true) break block2;
                pyFrame.setline(187);
                if ((pyObject = pyObject2.__iternext__()) == null) break block3;
            }
            do {
                pyFrame.setlocal(2, pyObject);
                pyFrame.setline(188);
                pyFrame.getglobal("_siftup").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(2));
                pyFrame.setline(187);
            } while ((pyObject = pyObject2.__iternext__()) != null);
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject _heappushpop_max$7(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(191);
        PyString.fromInterned("Maxheap version of a heappush followed by a heappop.");
        pyFrame.setline(192);
        PyObject pyObject2 = pyFrame.getlocal(0);
        if (pyObject2.__nonzero__()) {
            pyObject2 = pyFrame.getglobal("cmp_lt").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(0).__getitem__(Py.newInteger(0)));
        }
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(193);
            pyObject = new PyTuple(pyFrame.getlocal(0).__getitem__(Py.newInteger(0)), pyFrame.getlocal(1));
            PyObject[] pyObjectArray = Py.unpackSequence(pyObject, 2);
            PyObject pyObject3 = pyObjectArray[0];
            pyFrame.setlocal(1, pyObject3);
            pyObject3 = null;
            pyObject3 = pyObjectArray[1];
            pyFrame.getlocal(0).__setitem__(Py.newInteger(0), pyObject3);
            pyObject3 = null;
            pyObject = null;
            pyFrame.setline(194);
            pyFrame.getglobal("_siftup_max").__call__(threadState, pyFrame.getlocal(0), (PyObject)Py.newInteger(0));
        }
        pyFrame.setline(195);
        pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _heapify_max$8(PyFrame pyFrame, ThreadState threadState) {
        block3: {
            PyObject pyObject;
            PyObject pyObject2;
            block2: {
                pyFrame.setline(198);
                PyString.fromInterned("Transform list into a maxheap, in-place, in O(len(x)) time.");
                pyFrame.setline(199);
                pyObject2 = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(0));
                pyFrame.setlocal(1, pyObject2);
                pyObject2 = null;
                pyFrame.setline(200);
                pyObject2 = pyFrame.getglobal("reversed").__call__(threadState, pyFrame.getglobal("range").__call__(threadState, pyFrame.getlocal(1)._floordiv(Py.newInteger(2)))).__iter__();
                if (!true) break block2;
                pyFrame.setline(200);
                if ((pyObject = pyObject2.__iternext__()) == null) break block3;
            }
            do {
                pyFrame.setlocal(2, pyObject);
                pyFrame.setline(201);
                pyFrame.getglobal("_siftup_max").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(2));
                pyFrame.setline(200);
            } while ((pyObject = pyObject2.__iternext__()) != null);
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject nlargest$9(PyFrame pyFrame, ThreadState threadState) {
        String[] stringArray;
        PyObject[] pyObjectArray;
        PyObject pyObject;
        block5: {
            block4: {
                pyFrame.setline(207);
                PyString.fromInterned("Find the n largest elements in a dataset.\n\n    Equivalent to:  sorted(iterable, reverse=True)[:n]\n    ");
                pyFrame.setline(208);
                pyObject = pyFrame.getlocal(0);
                PyObject pyObject2 = pyObject._lt(Py.newInteger(0));
                pyObject = null;
                if (pyObject2.__nonzero__()) {
                    pyFrame.setline(209);
                    pyObject = new PyList(Py.EmptyObjects);
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(210);
                pyObjectArray = pyFrame.getglobal("iter").__call__(threadState, pyFrame.getlocal(1));
                pyFrame.setlocal(2, (PyObject)pyObjectArray);
                pyObjectArray = null;
                pyFrame.setline(211);
                pyObjectArray = pyFrame.getglobal("list").__call__(threadState, pyFrame.getglobal("islice").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(0)));
                pyFrame.setlocal(3, (PyObject)pyObjectArray);
                pyObjectArray = null;
                pyFrame.setline(212);
                if (pyFrame.getlocal(3).__not__().__nonzero__()) {
                    pyFrame.setline(213);
                    pyObject = pyFrame.getlocal(3);
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(214);
                pyFrame.getglobal("heapify").__call__(threadState, pyFrame.getlocal(3));
                pyFrame.setline(215);
                pyObjectArray = pyFrame.getglobal("heappushpop");
                pyFrame.setlocal(4, (PyObject)pyObjectArray);
                pyObjectArray = null;
                pyFrame.setline(216);
                pyObjectArray = pyFrame.getlocal(2).__iter__();
                if (!true) break block4;
                pyFrame.setline(216);
                if ((stringArray = pyObjectArray.__iternext__()) == null) break block5;
            }
            do {
                pyFrame.setlocal(5, (PyObject)stringArray);
                pyFrame.setline(217);
                pyFrame.getlocal(4).__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(5));
                pyFrame.setline(216);
            } while ((stringArray = pyObjectArray.__iternext__()) != null);
        }
        pyFrame.setline(218);
        pyObjectArray = new PyObject[]{pyFrame.getglobal("True")};
        stringArray = new String[]{"reverse"};
        pyFrame.getlocal(3).__getattr__("sort").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        pyFrame.setline(219);
        pyObject = pyFrame.getlocal(3);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject nsmallest$10(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block5: {
            PyObject pyObject2;
            PyObject pyObject3;
            block4: {
                pyFrame.setline(225);
                PyString.fromInterned("Find the n smallest elements in a dataset.\n\n    Equivalent to:  sorted(iterable)[:n]\n    ");
                pyFrame.setline(226);
                pyObject = pyFrame.getlocal(0);
                PyObject pyObject4 = pyObject._lt(Py.newInteger(0));
                pyObject = null;
                if (pyObject4.__nonzero__()) {
                    pyFrame.setline(227);
                    pyObject = new PyList(Py.EmptyObjects);
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(228);
                pyObject3 = pyFrame.getglobal("iter").__call__(threadState, pyFrame.getlocal(1));
                pyFrame.setlocal(2, pyObject3);
                pyObject3 = null;
                pyFrame.setline(229);
                pyObject3 = pyFrame.getglobal("list").__call__(threadState, pyFrame.getglobal("islice").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(0)));
                pyFrame.setlocal(3, pyObject3);
                pyObject3 = null;
                pyFrame.setline(230);
                if (pyFrame.getlocal(3).__not__().__nonzero__()) {
                    pyFrame.setline(231);
                    pyObject = pyFrame.getlocal(3);
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(232);
                pyFrame.getglobal("_heapify_max").__call__(threadState, pyFrame.getlocal(3));
                pyFrame.setline(233);
                pyObject3 = pyFrame.getglobal("_heappushpop_max");
                pyFrame.setlocal(4, pyObject3);
                pyObject3 = null;
                pyFrame.setline(234);
                pyObject3 = pyFrame.getlocal(2).__iter__();
                if (!true) break block4;
                pyFrame.setline(234);
                if ((pyObject2 = pyObject3.__iternext__()) == null) break block5;
            }
            do {
                pyFrame.setlocal(5, pyObject2);
                pyFrame.setline(235);
                pyFrame.getlocal(4).__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(5));
                pyFrame.setline(234);
            } while ((pyObject2 = pyObject3.__iternext__()) != null);
        }
        pyFrame.setline(236);
        pyFrame.getlocal(3).__getattr__("sort").__call__(threadState);
        pyFrame.setline(237);
        pyObject = pyFrame.getlocal(3);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _siftdown$11(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block3: {
            PyObject pyObject2;
            block2: {
                pyFrame.setline(243);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(2));
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                if (!true) break block2;
                pyFrame.setline(246);
                pyObject = pyFrame.getlocal(2);
                pyObject2 = pyObject._gt(pyFrame.getlocal(1));
                pyObject = null;
                if (!pyObject2.__nonzero__()) break block3;
            }
            do {
                pyFrame.setline(247);
                pyObject = pyFrame.getlocal(2)._sub(Py.newInteger(1))._rshift(Py.newInteger(1));
                pyFrame.setlocal(4, pyObject);
                pyObject = null;
                pyFrame.setline(248);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(4));
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                pyFrame.setline(249);
                if (!pyFrame.getglobal("cmp_lt").__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(5)).__nonzero__()) break;
                pyFrame.setline(250);
                pyObject = pyFrame.getlocal(5);
                pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(2), pyObject);
                pyObject = null;
                pyFrame.setline(251);
                pyObject = pyFrame.getlocal(4);
                pyFrame.setlocal(2, pyObject);
                pyObject = null;
                pyFrame.setline(246);
                pyObject = pyFrame.getlocal(2);
                pyObject2 = pyObject._gt(pyFrame.getlocal(1));
                pyObject = null;
            } while (pyObject2.__nonzero__());
        }
        pyFrame.setline(254);
        pyObject = pyFrame.getlocal(3);
        pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(2), pyObject);
        pyObject = null;
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _siftup$12(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block5: {
            PyObject pyObject2;
            block4: {
                pyFrame.setline(296);
                pyObject = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(0));
                pyFrame.setlocal(2, pyObject);
                pyObject = null;
                pyFrame.setline(297);
                pyObject = pyFrame.getlocal(1);
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(298);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(1));
                pyFrame.setlocal(4, pyObject);
                pyObject = null;
                pyFrame.setline(300);
                pyObject = Py.newInteger(2)._mul(pyFrame.getlocal(1))._add(Py.newInteger(1));
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                if (!true) break block4;
                pyFrame.setline(301);
                pyObject = pyFrame.getlocal(5);
                pyObject2 = pyObject._lt(pyFrame.getlocal(2));
                pyObject = null;
                if (!pyObject2.__nonzero__()) break block5;
            }
            do {
                pyFrame.setline(303);
                pyObject = pyFrame.getlocal(5)._add(Py.newInteger(1));
                pyFrame.setlocal(6, pyObject);
                pyObject = null;
                pyFrame.setline(304);
                pyObject = pyFrame.getlocal(6);
                PyObject pyObject3 = pyObject._lt(pyFrame.getlocal(2));
                pyObject = null;
                PyObject pyObject4 = pyObject3;
                if (pyObject3.__nonzero__()) {
                    pyObject4 = pyFrame.getglobal("cmp_lt").__call__(threadState, pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(5)), pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(6))).__not__();
                }
                if (pyObject4.__nonzero__()) {
                    pyFrame.setline(305);
                    pyObject = pyFrame.getlocal(6);
                    pyFrame.setlocal(5, pyObject);
                    pyObject = null;
                }
                pyFrame.setline(307);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(5));
                pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(1), pyObject);
                pyObject = null;
                pyFrame.setline(308);
                pyObject = pyFrame.getlocal(5);
                pyFrame.setlocal(1, pyObject);
                pyObject = null;
                pyFrame.setline(309);
                pyObject = Py.newInteger(2)._mul(pyFrame.getlocal(1))._add(Py.newInteger(1));
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                pyFrame.setline(301);
                pyObject = pyFrame.getlocal(5);
                pyObject2 = pyObject._lt(pyFrame.getlocal(2));
                pyObject = null;
            } while (pyObject2.__nonzero__());
        }
        pyFrame.setline(312);
        pyObject = pyFrame.getlocal(4);
        pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(1), pyObject);
        pyObject = null;
        pyFrame.setline(313);
        pyFrame.getglobal("_siftdown").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3), pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _siftdown_max$13(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block3: {
            PyObject pyObject2;
            block2: {
                pyFrame.setline(316);
                PyString.fromInterned("Maxheap variant of _siftdown");
                pyFrame.setline(317);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(2));
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                if (!true) break block2;
                pyFrame.setline(320);
                pyObject = pyFrame.getlocal(2);
                pyObject2 = pyObject._gt(pyFrame.getlocal(1));
                pyObject = null;
                if (!pyObject2.__nonzero__()) break block3;
            }
            do {
                pyFrame.setline(321);
                pyObject = pyFrame.getlocal(2)._sub(Py.newInteger(1))._rshift(Py.newInteger(1));
                pyFrame.setlocal(4, pyObject);
                pyObject = null;
                pyFrame.setline(322);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(4));
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                pyFrame.setline(323);
                if (!pyFrame.getglobal("cmp_lt").__call__(threadState, pyFrame.getlocal(5), pyFrame.getlocal(3)).__nonzero__()) break;
                pyFrame.setline(324);
                pyObject = pyFrame.getlocal(5);
                pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(2), pyObject);
                pyObject = null;
                pyFrame.setline(325);
                pyObject = pyFrame.getlocal(4);
                pyFrame.setlocal(2, pyObject);
                pyObject = null;
                pyFrame.setline(320);
                pyObject = pyFrame.getlocal(2);
                pyObject2 = pyObject._gt(pyFrame.getlocal(1));
                pyObject = null;
            } while (pyObject2.__nonzero__());
        }
        pyFrame.setline(328);
        pyObject = pyFrame.getlocal(3);
        pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(2), pyObject);
        pyObject = null;
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _siftup_max$14(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block5: {
            PyObject pyObject2;
            block4: {
                pyFrame.setline(331);
                PyString.fromInterned("Maxheap variant of _siftup");
                pyFrame.setline(332);
                pyObject = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(0));
                pyFrame.setlocal(2, pyObject);
                pyObject = null;
                pyFrame.setline(333);
                pyObject = pyFrame.getlocal(1);
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(334);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(1));
                pyFrame.setlocal(4, pyObject);
                pyObject = null;
                pyFrame.setline(336);
                pyObject = Py.newInteger(2)._mul(pyFrame.getlocal(1))._add(Py.newInteger(1));
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                if (!true) break block4;
                pyFrame.setline(337);
                pyObject = pyFrame.getlocal(5);
                pyObject2 = pyObject._lt(pyFrame.getlocal(2));
                pyObject = null;
                if (!pyObject2.__nonzero__()) break block5;
            }
            do {
                pyFrame.setline(339);
                pyObject = pyFrame.getlocal(5)._add(Py.newInteger(1));
                pyFrame.setlocal(6, pyObject);
                pyObject = null;
                pyFrame.setline(340);
                pyObject = pyFrame.getlocal(6);
                PyObject pyObject3 = pyObject._lt(pyFrame.getlocal(2));
                pyObject = null;
                PyObject pyObject4 = pyObject3;
                if (pyObject3.__nonzero__()) {
                    pyObject4 = pyFrame.getglobal("cmp_lt").__call__(threadState, pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(6)), pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(5))).__not__();
                }
                if (pyObject4.__nonzero__()) {
                    pyFrame.setline(341);
                    pyObject = pyFrame.getlocal(6);
                    pyFrame.setlocal(5, pyObject);
                    pyObject = null;
                }
                pyFrame.setline(343);
                pyObject = pyFrame.getlocal(0).__getitem__(pyFrame.getlocal(5));
                pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(1), pyObject);
                pyObject = null;
                pyFrame.setline(344);
                pyObject = pyFrame.getlocal(5);
                pyFrame.setlocal(1, pyObject);
                pyObject = null;
                pyFrame.setline(345);
                pyObject = Py.newInteger(2)._mul(pyFrame.getlocal(1))._add(Py.newInteger(1));
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                pyFrame.setline(337);
                pyObject = pyFrame.getlocal(5);
                pyObject2 = pyObject._lt(pyFrame.getlocal(2));
                pyObject = null;
            } while (pyObject2.__nonzero__());
        }
        pyFrame.setline(348);
        pyObject = pyFrame.getlocal(4);
        pyFrame.getlocal(0).__setitem__(pyFrame.getlocal(1), pyObject);
        pyObject = null;
        pyFrame.setline(349);
        pyFrame.getglobal("_siftdown_max").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3), pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public PyObject merge$15(PyFrame var1_1, ThreadState var2_2) {
        block18: {
            break block18;
lbl1:
            // 1 sources

            while (true) {
                var1_1.setline(367);
                PyString.fromInterned("Merge multiple sorted inputs into a single sorted output.\n\n    Similar to sorted(itertools.chain(*iterables)) but returns a generator,\n    does not pull the data into memory all at once, and assumes that each of\n    the input streams is already sorted (smallest to largest).\n\n    >>> list(merge([1,3,5,7], [0,2,4,8], [5,10,15,20], [], [25]))\n    [0, 1, 2, 3, 4, 5, 5, 7, 8, 10, 15, 20, 25]\n\n    ");
                var1_1.setline(368);
                var3_3 = new PyObject[]{var1_1.getglobal("heappop"), var1_1.getglobal("heapreplace"), var1_1.getglobal("StopIteration")};
                v0 = new PyTuple((PyObject[])var3_3);
                Arrays.fill((Object[])var3_3, null);
                var3_3 = v0;
                var4_4 /* !! */  = Py.unpackSequence((PyObject)var3_3, 3);
                var5_5 = var4_4 /* !! */ [0];
                var1_1.setlocal(1, (PyObject)var5_5);
                var5_5 = null;
                var5_5 = var4_4 /* !! */ [1];
                var1_1.setlocal(2, (PyObject)var5_5);
                var5_5 = null;
                var5_5 = var4_4 /* !! */ [2];
                var1_1.setlocal(3, (PyObject)var5_5);
                var5_5 = null;
                var3_3 = null;
                var1_1.setline(370);
                var3_3 = Py.EmptyObjects;
                v1 = new PyList((PyObject[])var3_3);
                Arrays.fill((Object[])var3_3, null);
                var3_3 = v1;
                var1_1.setlocal(4, (PyObject)var3_3);
                var3_3 = null;
                var1_1.setline(371);
                var3_3 = var1_1.getlocal(4).__getattr__("append");
                var1_1.setlocal(5, (PyObject)var3_3);
                var3_3 = null;
                var1_1.setline(372);
                var3_3 = var1_1.getglobal("enumerate").__call__(var2_2, var1_1.getglobal("map").__call__(var2_2, var1_1.getglobal("iter"), var1_1.getlocal(0))).__iter__();
                if (true) ** GOTO lbl62
                do {
                    var5_5 = Py.unpackSequence((PyObject)var4_4 /* !! */ , 2);
                    var6_6 = var5_5[0];
                    var1_1.setlocal(6, var6_6);
                    var6_6 = null;
                    var6_6 = var5_5[1];
                    var1_1.setlocal(7, var6_6);
                    var6_6 = null;
                    try {
                        var1_1.setline(374);
                        var5_5 = var1_1.getlocal(7).__getattr__("next");
                        var1_1.setlocal(8, (PyObject)var5_5);
                        var5_5 = null;
                        var1_1.setline(375);
                        v2 = var1_1.getlocal(5);
                        var5_5 = new PyObject[]{var1_1.getlocal(8).__call__(var2_2), var1_1.getlocal(6), var1_1.getlocal(8)};
                        v3 = new PyList(var5_5);
                        Arrays.fill(var5_5, null);
                        v2.__call__(var2_2, (PyObject)v3);
                    }
                    catch (Throwable v4) {
                        var5_5 = Py.setException(v4, var1_1);
                        if (var5_5.match(var1_1.getlocal(3))) {
                            var1_1.setline(377);
                        }
                        throw var5_5;
                    }
lbl62:
                    // 3 sources

                    var1_1.setline(372);
                } while ((var4_4 /* !! */  = var3_3.__iternext__()) != null);
                var1_1.setline(378);
                var1_1.getglobal("heapify").__call__(var2_2, var1_1.getlocal(4));
                ** GOTO lbl121
                while (true) {
                    ** GOTO lbl106
                    while (true) {
                        var1_1.setline(383);
                        var3_3 = var1_1.getlocal(4).__getitem__(Py.newInteger(0));
                        var4_4 /* !! */  = Py.unpackSequence((PyObject)var3_3, 3);
                        var5_5 = var4_4 /* !! */ [0];
                        var1_1.setlocal(9, (PyObject)var5_5);
                        var5_5 = null;
                        var5_5 = var4_4 /* !! */ [1];
                        var1_1.setlocal(6, (PyObject)var5_5);
                        var5_5 = null;
                        var5_5 = var4_4 /* !! */ [2];
                        var1_1.setlocal(8, (PyObject)var5_5);
                        var5_5 = null;
                        var1_1.setlocal(10, (PyObject)var3_3);
                        var1_1.setline(384);
                        var1_1.setline(384);
                        var1_1.f_lasti = 1;
                        var3_3 = new Object[7];
                        var1_1.f_savedlocals = var3_3;
                        return var1_1.getlocal(9);
                    }
                    break;
                }
                break;
            }
lbl91:
            // 1 sources

            while (true) {
                block17: {
                    var3_3 = var1_1.f_savedlocals;
                    try {
                        v5 = var1_1.getGeneratorInput();
                        if (v5 instanceof PyException) {
                            throw (Throwable)v5;
                        }
                        (PyObject)v5;
                        var1_1.setline(385);
                        var3_3 = var1_1.getlocal(8).__call__(var2_2);
                        var1_1.getlocal(10).__setitem__(Py.newInteger(0), (PyObject)var3_3);
                        var3_3 = null;
                        var1_1.setline(386);
                        var1_1.getlocal(2).__call__(var2_2, var1_1.getlocal(4), var1_1.getlocal(10));
lbl106:
                        // 2 sources

                        var1_1.setline(382);
                        if (Py.newInteger(1).__nonzero__()) ** continue;
                    }
                    catch (Throwable v6) {
                        var3_3 = Py.setException(v6, var1_1);
                        if (var3_3.match(var1_1.getlocal(3))) {
                            var1_1.setline(388);
                            var1_1.getlocal(1).__call__(var2_2, var1_1.getlocal(4));
                            break block17;
                        }
                        if (var3_3.match(var1_1.getglobal("IndexError"))) {
                            var1_1.setline(390);
                            var1_1.f_lasti = -1;
                            return Py.None;
                        }
                        throw var3_3;
                    }
                }
                var1_1.setline(380);
                if (Py.newInteger(1).__nonzero__()) ** continue;
                var1_1.f_lasti = -1;
                return Py.None;
            }
        }
        switch (var1_1.f_lasti) {
            default: {
                ** continue;
            }
            ** case 1:
lbl131:
            // 1 sources

            ** continue;
        }
    }

    public PyObject nsmallest$16(PyFrame pyFrame, ThreadState threadState) {
        PyObject[] pyObjectArray;
        Serializable serializable;
        PyObject pyObject;
        block8: {
            pyFrame.setline(398);
            PyString.fromInterned("Find the n smallest elements in a dataset.\n\n    Equivalent to:  sorted(iterable, key=key)[:n]\n    ");
            pyFrame.setline(400);
            pyObject = pyFrame.getlocal(0);
            PyObject pyObject2 = pyObject._eq(Py.newInteger(1));
            pyObject = null;
            if (pyObject2.__nonzero__()) {
                pyFrame.setline(401);
                pyObject = pyFrame.getglobal("iter").__call__(threadState, pyFrame.getlocal(1));
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(402);
                pyObject = pyFrame.getglobal("list").__call__(threadState, pyFrame.getglobal("islice").__call__(threadState, pyFrame.getlocal(3), (PyObject)Py.newInteger(1)));
                pyFrame.setlocal(4, pyObject);
                pyObject = null;
                pyFrame.setline(403);
                if (pyFrame.getlocal(4).__not__().__nonzero__()) {
                    pyFrame.setline(404);
                    pyObject = new PyList(Py.EmptyObjects);
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(405);
                PyObject[] pyObjectArray2 = pyFrame.getlocal(2);
                PyObject pyObject3 = pyObjectArray2._is(pyFrame.getglobal("None"));
                pyObjectArray2 = null;
                if (pyObject3.__nonzero__()) {
                    pyFrame.setline(406);
                    pyObject = new PyList(new PyObject[]{pyFrame.getglobal("min").__call__(threadState, pyFrame.getglobal("chain").__call__(threadState, pyFrame.getlocal(4), pyFrame.getlocal(3)))});
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(407);
                PyObject[] pyObjectArray3 = new PyObject[1];
                pyObjectArray2 = new PyObject[]{pyFrame.getglobal("chain").__call__(threadState, pyFrame.getlocal(4), pyFrame.getlocal(3)), pyFrame.getlocal(2)};
                String[] stringArray = new String[]{"key"};
                PyObject pyObject4 = pyFrame.getglobal("min").__call__(threadState, pyObjectArray2, stringArray);
                pyObjectArray2 = null;
                pyObjectArray3[0] = pyObject4;
                pyObject = new PyList(pyObjectArray3);
                pyFrame.f_lasti = -1;
                return pyObject;
            }
            try {
                pyFrame.setline(411);
                serializable = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(1));
                pyFrame.setlocal(5, (PyObject)serializable);
                serializable = null;
            }
            catch (Throwable throwable) {
                serializable = Py.setException(throwable, pyFrame);
                if (((PyException)serializable).match(new PyTuple(pyFrame.getglobal("TypeError"), pyFrame.getglobal("AttributeError")))) {
                    pyFrame.setline(413);
                    break block8;
                }
                throw serializable;
            }
            pyFrame.setline(415);
            pyObjectArray = pyFrame.getlocal(0);
            PyObject pyObject5 = pyObjectArray._ge(pyFrame.getlocal(5));
            pyObjectArray = null;
            if (pyObject5.__nonzero__()) {
                pyFrame.setline(416);
                pyObjectArray = new PyObject[]{pyFrame.getlocal(1), pyFrame.getlocal(2)};
                String[] stringArray = new String[]{"key"};
                PyObject pyObject6 = pyFrame.getglobal("sorted").__call__(threadState, pyObjectArray, stringArray);
                pyObjectArray = null;
                pyObject = pyObject6.__getslice__(null, pyFrame.getlocal(0), null);
                pyFrame.f_lasti = -1;
                return pyObject;
            }
        }
        pyFrame.setline(419);
        serializable = pyFrame.getlocal(2);
        PyObject pyObject7 = ((PyObject)serializable)._is(pyFrame.getglobal("None"));
        serializable = null;
        if (pyObject7.__nonzero__()) {
            pyFrame.setline(420);
            serializable = pyFrame.getglobal("izip").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("count").__call__(threadState));
            pyFrame.setlocal(3, (PyObject)serializable);
            serializable = null;
            pyFrame.setline(421);
            serializable = pyFrame.getglobal("_nsmallest").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3));
            pyFrame.setlocal(6, (PyObject)serializable);
            serializable = null;
            pyFrame.setline(422);
            pyObject = pyFrame.getglobal("map").__call__(threadState, pyFrame.getglobal("itemgetter").__call__(threadState, (PyObject)Py.newInteger(0)), pyFrame.getlocal(6));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(425);
        serializable = pyFrame.getglobal("tee").__call__(threadState, pyFrame.getlocal(1));
        pyObjectArray = Py.unpackSequence((PyObject)serializable, 2);
        PyObject pyObject8 = pyObjectArray[0];
        pyFrame.setlocal(7, pyObject8);
        pyObject8 = null;
        pyObject8 = pyObjectArray[1];
        pyFrame.setlocal(8, pyObject8);
        pyObject8 = null;
        serializable = null;
        pyFrame.setline(426);
        serializable = pyFrame.getglobal("izip").__call__(threadState, pyFrame.getglobal("imap").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(7)), pyFrame.getglobal("count").__call__(threadState), pyFrame.getlocal(8));
        pyFrame.setlocal(3, (PyObject)serializable);
        serializable = null;
        pyFrame.setline(427);
        serializable = pyFrame.getglobal("_nsmallest").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3));
        pyFrame.setlocal(6, (PyObject)serializable);
        serializable = null;
        pyFrame.setline(428);
        pyObject = pyFrame.getglobal("map").__call__(threadState, pyFrame.getglobal("itemgetter").__call__(threadState, (PyObject)Py.newInteger(2)), pyFrame.getlocal(6));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject nlargest$17(PyFrame pyFrame, ThreadState threadState) {
        PyObject[] pyObjectArray;
        Serializable serializable;
        PyObject pyObject;
        block8: {
            pyFrame.setline(435);
            PyString.fromInterned("Find the n largest elements in a dataset.\n\n    Equivalent to:  sorted(iterable, key=key, reverse=True)[:n]\n    ");
            pyFrame.setline(438);
            pyObject = pyFrame.getlocal(0);
            PyObject pyObject2 = pyObject._eq(Py.newInteger(1));
            pyObject = null;
            if (pyObject2.__nonzero__()) {
                pyFrame.setline(439);
                pyObject = pyFrame.getglobal("iter").__call__(threadState, pyFrame.getlocal(1));
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(440);
                pyObject = pyFrame.getglobal("list").__call__(threadState, pyFrame.getglobal("islice").__call__(threadState, pyFrame.getlocal(3), (PyObject)Py.newInteger(1)));
                pyFrame.setlocal(4, pyObject);
                pyObject = null;
                pyFrame.setline(441);
                if (pyFrame.getlocal(4).__not__().__nonzero__()) {
                    pyFrame.setline(442);
                    pyObject = new PyList(Py.EmptyObjects);
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(443);
                PyObject[] pyObjectArray2 = pyFrame.getlocal(2);
                PyObject pyObject3 = pyObjectArray2._is(pyFrame.getglobal("None"));
                pyObjectArray2 = null;
                if (pyObject3.__nonzero__()) {
                    pyFrame.setline(444);
                    pyObject = new PyList(new PyObject[]{pyFrame.getglobal("max").__call__(threadState, pyFrame.getglobal("chain").__call__(threadState, pyFrame.getlocal(4), pyFrame.getlocal(3)))});
                    pyFrame.f_lasti = -1;
                    return pyObject;
                }
                pyFrame.setline(445);
                PyObject[] pyObjectArray3 = new PyObject[1];
                pyObjectArray2 = new PyObject[]{pyFrame.getglobal("chain").__call__(threadState, pyFrame.getlocal(4), pyFrame.getlocal(3)), pyFrame.getlocal(2)};
                String[] stringArray = new String[]{"key"};
                PyObject pyObject4 = pyFrame.getglobal("max").__call__(threadState, pyObjectArray2, stringArray);
                pyObjectArray2 = null;
                pyObjectArray3[0] = pyObject4;
                pyObject = new PyList(pyObjectArray3);
                pyFrame.f_lasti = -1;
                return pyObject;
            }
            try {
                pyFrame.setline(449);
                serializable = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(1));
                pyFrame.setlocal(5, (PyObject)serializable);
                serializable = null;
            }
            catch (Throwable throwable) {
                serializable = Py.setException(throwable, pyFrame);
                if (((PyException)serializable).match(new PyTuple(pyFrame.getglobal("TypeError"), pyFrame.getglobal("AttributeError")))) {
                    pyFrame.setline(451);
                    break block8;
                }
                throw serializable;
            }
            pyFrame.setline(453);
            pyObjectArray = pyFrame.getlocal(0);
            PyObject pyObject5 = pyObjectArray._ge(pyFrame.getlocal(5));
            pyObjectArray = null;
            if (pyObject5.__nonzero__()) {
                pyFrame.setline(454);
                pyObjectArray = new PyObject[]{pyFrame.getlocal(1), pyFrame.getlocal(2), pyFrame.getglobal("True")};
                String[] stringArray = new String[]{"key", "reverse"};
                PyObject pyObject6 = pyFrame.getglobal("sorted").__call__(threadState, pyObjectArray, stringArray);
                pyObjectArray = null;
                pyObject = pyObject6.__getslice__(null, pyFrame.getlocal(0), null);
                pyFrame.f_lasti = -1;
                return pyObject;
            }
        }
        pyFrame.setline(457);
        serializable = pyFrame.getlocal(2);
        PyObject pyObject7 = ((PyObject)serializable)._is(pyFrame.getglobal("None"));
        serializable = null;
        if (pyObject7.__nonzero__()) {
            pyFrame.setline(458);
            serializable = pyFrame.getglobal("izip").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("count").__call__(threadState, (PyObject)Py.newInteger(0), (PyObject)Py.newInteger(-1)));
            pyFrame.setlocal(3, (PyObject)serializable);
            serializable = null;
            pyFrame.setline(459);
            serializable = pyFrame.getglobal("_nlargest").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3));
            pyFrame.setlocal(6, (PyObject)serializable);
            serializable = null;
            pyFrame.setline(460);
            pyObject = pyFrame.getglobal("map").__call__(threadState, pyFrame.getglobal("itemgetter").__call__(threadState, (PyObject)Py.newInteger(0)), pyFrame.getlocal(6));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(463);
        serializable = pyFrame.getglobal("tee").__call__(threadState, pyFrame.getlocal(1));
        pyObjectArray = Py.unpackSequence((PyObject)serializable, 2);
        PyObject pyObject8 = pyObjectArray[0];
        pyFrame.setlocal(7, pyObject8);
        pyObject8 = null;
        pyObject8 = pyObjectArray[1];
        pyFrame.setlocal(8, pyObject8);
        pyObject8 = null;
        serializable = null;
        pyFrame.setline(464);
        serializable = pyFrame.getglobal("izip").__call__(threadState, pyFrame.getglobal("imap").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(7)), pyFrame.getglobal("count").__call__(threadState, (PyObject)Py.newInteger(0), (PyObject)Py.newInteger(-1)), pyFrame.getlocal(8));
        pyFrame.setlocal(3, (PyObject)serializable);
        serializable = null;
        pyFrame.setline(465);
        serializable = pyFrame.getglobal("_nlargest").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3));
        pyFrame.setlocal(6, (PyObject)serializable);
        serializable = null;
        pyFrame.setline(466);
        pyObject = pyFrame.getglobal("map").__call__(threadState, pyFrame.getglobal("itemgetter").__call__(threadState, (PyObject)Py.newInteger(2)), pyFrame.getlocal(6));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public heapq$py(String string2) {
        self = this;
        String[] stringArray = new String[]{};
        f$0 = Py.newCode(0, stringArray, string2, "<module>", 0, false, false, (PyFunctionTable)self, 0, null, null, 0, 4096);
        stringArray = new String[]{"x", "y"};
        cmp_lt$1 = Py.newCode(2, stringArray, string2, "cmp_lt", 135, false, false, (PyFunctionTable)self, 1, null, null, 0, 4097);
        stringArray = new String[]{"heap", "item"};
        heappush$2 = Py.newCode(2, stringArray, string2, "heappush", 140, false, false, (PyFunctionTable)self, 2, null, null, 0, 4097);
        stringArray = new String[]{"heap", "lastelt", "returnitem"};
        heappop$3 = Py.newCode(1, stringArray, string2, "heappop", 145, false, false, (PyFunctionTable)self, 3, null, null, 0, 4097);
        stringArray = new String[]{"heap", "item", "returnitem"};
        heapreplace$4 = Py.newCode(2, stringArray, string2, "heapreplace", 156, false, false, (PyFunctionTable)self, 4, null, null, 0, 4097);
        stringArray = new String[]{"heap", "item"};
        heappushpop$5 = Py.newCode(2, stringArray, string2, "heappushpop", 172, false, false, (PyFunctionTable)self, 5, null, null, 0, 4097);
        stringArray = new String[]{"x", "n", "i"};
        heapify$6 = Py.newCode(1, stringArray, string2, "heapify", 179, false, false, (PyFunctionTable)self, 6, null, null, 0, 4097);
        stringArray = new String[]{"heap", "item"};
        _heappushpop_max$7 = Py.newCode(2, stringArray, string2, "_heappushpop_max", 190, false, false, (PyFunctionTable)self, 7, null, null, 0, 4097);
        stringArray = new String[]{"x", "n", "i"};
        _heapify_max$8 = Py.newCode(1, stringArray, string2, "_heapify_max", 197, false, false, (PyFunctionTable)self, 8, null, null, 0, 4097);
        stringArray = new String[]{"n", "iterable", "it", "result", "_heappushpop", "elem"};
        nlargest$9 = Py.newCode(2, stringArray, string2, "nlargest", 203, false, false, (PyFunctionTable)self, 9, null, null, 0, 4097);
        stringArray = new String[]{"n", "iterable", "it", "result", "_heappushpop", "elem"};
        nsmallest$10 = Py.newCode(2, stringArray, string2, "nsmallest", 221, false, false, (PyFunctionTable)self, 10, null, null, 0, 4097);
        stringArray = new String[]{"heap", "startpos", "pos", "newitem", "parentpos", "parent"};
        _siftdown$11 = Py.newCode(3, stringArray, string2, "_siftdown", 242, false, false, (PyFunctionTable)self, 11, null, null, 0, 4097);
        stringArray = new String[]{"heap", "pos", "endpos", "startpos", "newitem", "childpos", "rightpos"};
        _siftup$12 = Py.newCode(2, stringArray, string2, "_siftup", 295, false, false, (PyFunctionTable)self, 12, null, null, 0, 4097);
        stringArray = new String[]{"heap", "startpos", "pos", "newitem", "parentpos", "parent"};
        _siftdown_max$13 = Py.newCode(3, stringArray, string2, "_siftdown_max", 315, false, false, (PyFunctionTable)self, 13, null, null, 0, 4097);
        stringArray = new String[]{"heap", "pos", "endpos", "startpos", "newitem", "childpos", "rightpos"};
        _siftup_max$14 = Py.newCode(2, stringArray, string2, "_siftup_max", 330, false, false, (PyFunctionTable)self, 14, null, null, 0, 4097);
        stringArray = new String[]{"iterables", "_heappop", "_heapreplace", "_StopIteration", "h", "h_append", "itnum", "it", "next", "v", "s"};
        merge$15 = Py.newCode(1, stringArray, string2, "merge", 357, true, false, (PyFunctionTable)self, 15, null, null, 0, 4129);
        stringArray = new String[]{"n", "iterable", "key", "it", "head", "size", "result", "in1", "in2"};
        nsmallest$16 = Py.newCode(3, stringArray, string2, "nsmallest", 394, false, false, (PyFunctionTable)self, 16, null, null, 0, 4097);
        stringArray = new String[]{"n", "iterable", "key", "it", "head", "size", "result", "in1", "in2"};
        nlargest$17 = Py.newCode(3, stringArray, string2, "nlargest", 431, false, false, (PyFunctionTable)self, 17, null, null, 0, 4097);
    }

    @Override
    public PyCode getMain() {
        return f$0;
    }

    public static void main(String[] stringArray) {
        Py.runMain(CodeLoader.createSimpleBootstrap(new heapq$py("heapq$py").getMain()), stringArray);
    }

    public static CodeBootstrap getCodeBootstrap() {
        return PyRunnableBootstrap.getFilenameConstructorReflectionBootstrap(heapq$py.class);
    }

    @Override
    public PyObject call_function(int n, PyFrame pyFrame, ThreadState threadState) {
        heapq$py heapq$py = this;
        PyFrame pyFrame2 = pyFrame;
        ThreadState threadState2 = threadState;
        switch (n) {
            case 0: {
                return heapq$py.f$0(pyFrame2, threadState2);
            }
            case 1: {
                return heapq$py.cmp_lt$1(pyFrame2, threadState2);
            }
            case 2: {
                return heapq$py.heappush$2(pyFrame2, threadState2);
            }
            case 3: {
                return heapq$py.heappop$3(pyFrame2, threadState2);
            }
            case 4: {
                return heapq$py.heapreplace$4(pyFrame2, threadState2);
            }
            case 5: {
                return heapq$py.heappushpop$5(pyFrame2, threadState2);
            }
            case 6: {
                return heapq$py.heapify$6(pyFrame2, threadState2);
            }
            case 7: {
                return heapq$py._heappushpop_max$7(pyFrame2, threadState2);
            }
            case 8: {
                return heapq$py._heapify_max$8(pyFrame2, threadState2);
            }
            case 9: {
                return heapq$py.nlargest$9(pyFrame2, threadState2);
            }
            case 10: {
                return heapq$py.nsmallest$10(pyFrame2, threadState2);
            }
            case 11: {
                return heapq$py._siftdown$11(pyFrame2, threadState2);
            }
            case 12: {
                return heapq$py._siftup$12(pyFrame2, threadState2);
            }
            case 13: {
                return heapq$py._siftdown_max$13(pyFrame2, threadState2);
            }
            case 14: {
                return heapq$py._siftup_max$14(pyFrame2, threadState2);
            }
            case 15: {
                return heapq$py.merge$15(pyFrame2, threadState2);
            }
            case 16: {
                return heapq$py.nsmallest$16(pyFrame2, threadState2);
            }
            case 17: {
                return heapq$py.nlargest$17(pyFrame2, threadState2);
            }
        }
        return null;
    }
}

