/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.messaging.factory.net;

import java.net.InetSocketAddress;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.GenericMessage;
import reactor.core.Environment;
import reactor.function.Consumer;
import reactor.io.encoding.Codec;
import reactor.io.encoding.DelimitedCodec;
import reactor.io.encoding.LengthFieldCodec;
import reactor.io.encoding.StandardCodecs;
import reactor.net.NetChannel;
import reactor.net.NetServer;
import reactor.net.encoding.syslog.SyslogCodec;
import reactor.net.netty.tcp.NettyTcpServer;
import reactor.net.netty.udp.NettyDatagramServer;
import reactor.net.tcp.spec.TcpServerSpec;
import reactor.net.tcp.spec.TcpServers;
import reactor.net.udp.spec.DatagramServers;
import reactor.util.Assert;

public class NetServerFactoryBean
implements FactoryBean<NetServer>,
SmartLifecycle {
    private final ReentrantLock startLock = new ReentrantLock();
    private final Environment env;
    private volatile boolean started = false;
    private int phase = 0;
    private boolean autoStartup = true;
    private Class<? extends NetServer> serverImpl;
    private NetServer server;
    private String dispatcher;
    private String host = null;
    private int port = 3000;
    private Codec codec = StandardCodecs.BYTE_ARRAY_CODEC;
    private String framing = "delimited";
    private String delimiter = "LF";
    private int lengthFieldLength = 4;
    private String transport = "tcp";
    private MessageHandler messageHandler;

    public NetServerFactoryBean(Environment env) {
        this.env = env;
    }

    public NetServerFactoryBean setDispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    public NetServerFactoryBean setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public NetServerFactoryBean setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
        return this;
    }

    public NetServerFactoryBean setHost(String host) {
        Assert.notNull((Object)host, (String)"Host cannot be null.");
        this.host = host;
        return this;
    }

    public NetServerFactoryBean setPort(int port) {
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port must be greater than 0");
        this.port = port;
        return this;
    }

    public NetServerFactoryBean setCodec(String codec) {
        if ("bytes".equals(codec)) {
            this.codec = StandardCodecs.BYTE_ARRAY_CODEC;
        } else if ("string".equals(codec)) {
            this.codec = StandardCodecs.STRING_CODEC;
        } else if ("syslog".equals(codec)) {
            this.codec = new SyslogCodec();
        } else {
            throw new IllegalArgumentException("Codec '" + codec + "' not recognized.");
        }
        return this;
    }

    public NetServerFactoryBean setFraming(String framing) {
        Assert.isTrue(("delimited".equals(framing) || "length".equals(framing) ? 1 : 0) != 0);
        this.framing = framing;
        return this;
    }

    public NetServerFactoryBean setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public NetServerFactoryBean setLengthFieldLength(int lengthFieldLength) {
        this.lengthFieldLength = lengthFieldLength;
        return this;
    }

    public NetServerFactoryBean setTransport(String transport) {
        if ("tcp".equals(transport)) {
            this.serverImpl = NettyTcpServer.class;
        } else if ("udp".equals(transport)) {
            this.serverImpl = NettyDatagramServer.class;
        } else {
            throw new IllegalArgumentException("Transport must be either 'tcp' or 'udp'");
        }
        this.transport = transport;
        return this;
    }

    public NetServerFactoryBean setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        this.startLock.lock();
        try {
            this.server.shutdown();
            this.started = false;
        }
        finally {
            this.startLock.unlock();
            if (null != callback) {
                callback.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startLock.lock();
        try {
            this.server.start();
            this.started = true;
        }
        finally {
            this.startLock.unlock();
        }
    }

    public void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.startLock.lock();
        try {
            boolean bl = this.started;
            return bl;
        }
        finally {
            this.startLock.unlock();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public NetServer getObject() throws Exception {
        if (null == this.server) {
            TcpServerSpec spec;
            InetSocketAddress bindAddress = null == this.host ? InetSocketAddress.createUnresolved("0.0.0.0", this.port) : new InetSocketAddress(this.host, this.port);
            DelimitedCodec framedCodec = null;
            if ("delimited".equals(this.framing)) {
                if ("LF".equals(this.delimiter)) {
                    framedCodec = new DelimitedCodec(this.codec);
                } else if ("CR".equals(this.delimiter)) {
                    framedCodec = new DelimitedCodec(13, true, this.codec);
                }
            } else if ("length".equals(this.framing)) {
                framedCodec = new LengthFieldCodec(this.lengthFieldLength, this.codec);
            }
            if (null == framedCodec) {
                framedCodec = this.codec;
            }
            Consumer<NetChannel> channelConsumer = new Consumer<NetChannel>(){

                public void accept(NetChannel ch) {
                    ch.consume(new Consumer(){

                        public void accept(Object o) {
                            if (null == NetServerFactoryBean.this.messageHandler) {
                                return;
                            }
                            GenericMessage msg = new GenericMessage(o);
                            NetServerFactoryBean.this.messageHandler.handleMessage((Message)msg);
                        }
                    });
                }
            };
            if ("tcp".equals(this.transport)) {
                spec = TcpServers.create((Environment)this.env, null == this.serverImpl ? NettyTcpServer.class : this.serverImpl);
            } else if ("udp".equals(this.transport)) {
                spec = DatagramServers.create((Environment)this.env, null == this.serverImpl ? NettyDatagramServer.class : this.serverImpl);
            } else {
                throw new IllegalArgumentException(this.transport + " not recognized as a valid transport type.");
            }
            if (null != this.dispatcher) {
                spec.dispatcher(this.dispatcher);
            }
            this.server = (NetServer)spec.listen(bindAddress).codec((Codec)framedCodec).consume((Consumer)channelConsumer).get();
        }
        return this.server;
    }

    public Class<?> getObjectType() {
        return NetServer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

