/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.messaging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.ObjectUtils;
import reactor.core.processor.Operation;
import reactor.core.processor.Processor;
import reactor.core.processor.spec.ProcessorSpec;
import reactor.function.Consumer;
import reactor.function.Supplier;
import reactor.function.support.DelegatingConsumer;

public class ReactorSubscribableChannel
implements BeanNameAware,
MessageChannel,
SubscribableChannel {
    private final Map<MessageHandler, Consumer> messageHandlerConsumers = new ConcurrentHashMap<MessageHandler, Consumer>();
    private final DelegatingConsumer<MessageEvent> delegatingConsumer = new DelegatingConsumer();
    private final Processor<MessageEvent> processor;
    private String beanName = String.format("%s@%s", this.getClass().getSimpleName(), ObjectUtils.getIdentityHexString((Object)this));

    public ReactorSubscribableChannel() {
        this(false);
    }

    public ReactorSubscribableChannel(boolean singleThreadedProducer) {
        ProcessorSpec spec = new ProcessorSpec().dataSupplier((Supplier)new Supplier<MessageEvent>(){

            public MessageEvent get() {
                return new MessageEvent();
            }
        }).consume(this.delegatingConsumer);
        if (singleThreadedProducer) {
            spec.singleThreadedProducer();
        } else {
            spec.multiThreadedProducer();
        }
        this.processor = spec.get();
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean subscribe(final MessageHandler handler) {
        Consumer<MessageEvent> consumer = new Consumer<MessageEvent>(){

            public void accept(MessageEvent ev) {
                handler.handleMessage(ev.message);
            }
        };
        this.messageHandlerConsumers.put(handler, (Consumer)consumer);
        this.delegatingConsumer.add((Consumer)consumer);
        return true;
    }

    public boolean unsubscribe(MessageHandler handler) {
        Consumer consumer = this.messageHandlerConsumers.remove(handler);
        if (null == consumer) {
            return false;
        }
        this.delegatingConsumer.remove(consumer);
        return true;
    }

    public boolean send(Message<?> message) {
        return this.send(message, 0L);
    }

    public boolean send(Message<?> message, long timeout) {
        Operation op = this.processor.prepare();
        ((MessageEvent)op.get()).message = message;
        op.commit();
        return true;
    }

    private static class MessageEvent {
        Message<?> message;

        private MessageEvent() {
        }
    }
}

