/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.context.config;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;
import reactor.core.Environment;
import reactor.core.configuration.ConfigurationReader;
import reactor.core.configuration.PropertiesConfigurationReader;
import reactor.function.Supplier;
import reactor.spring.context.config.ConsumerBeanAutoConfiguration;
import reactor.spring.context.config.EnableReactor;
import reactor.spring.factory.CreateOrReuseFactoryBean;

public class ReactorBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String DEFAULT_ENV_NAME = "reactorEnv";

    public void registerBeanDefinitions(AnnotationMetadata meta, BeanDefinitionRegistry registry) {
        Map attrs = meta.getAnnotationAttributes(EnableReactor.class.getName());
        if (!registry.containsBeanDefinition(DEFAULT_ENV_NAME)) {
            BeanDefinitionBuilder envBeanDef = BeanDefinitionBuilder.rootBeanDefinition(CreateOrReuseFactoryBean.class);
            envBeanDef.addConstructorArgValue((Object)DEFAULT_ENV_NAME);
            envBeanDef.addConstructorArgValue(Environment.class);
            String envSupplierBean = (String)attrs.get("environmentSupplier");
            if (StringUtils.hasText((String)envSupplierBean)) {
                envBeanDef.addConstructorArgReference(envSupplierBean);
            } else {
                final String profileName = (String)attrs.get("value");
                Object envSupplier = StringUtils.hasText((String)profileName) ? new Supplier<Environment>(){

                    public Environment get() {
                        return new Environment((ConfigurationReader)new PropertiesConfigurationReader(profileName));
                    }
                } : new Supplier<Environment>(){

                    public Environment get() {
                        return new Environment();
                    }
                };
                envBeanDef.addConstructorArgValue(envSupplier);
            }
            registry.registerBeanDefinition(DEFAULT_ENV_NAME, (BeanDefinition)envBeanDef.getBeanDefinition());
        }
        if (!registry.containsBeanDefinition(ConsumerBeanAutoConfiguration.class.getName())) {
            BeanDefinitionBuilder autoConfigDef = BeanDefinitionBuilder.rootBeanDefinition(ConsumerBeanAutoConfiguration.class);
            registry.registerBeanDefinition(ConsumerBeanAutoConfiguration.class.getName(), (BeanDefinition)autoConfigDef.getBeanDefinition());
        }
    }
}

