/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.context.config;

import com.jayway.jsonpath.Filter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import reactor.core.Observable;
import reactor.event.Event;
import reactor.event.selector.Selectors;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.selector.JsonPathSelector;
import reactor.spring.context.annotation.ReplyTo;
import reactor.spring.context.annotation.Selector;
import reactor.util.StringUtils;

public class ConsumerBeanAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    public static final String REACTOR_CONVERSION_SERVICE_BEAN_NAME = "reactorConversionService";
    public static final ReflectionUtils.MethodFilter CONSUMER_METHOD_FILTER = new ReflectionUtils.MethodFilter(){

        public boolean matches(Method method) {
            return null != AnnotationUtils.findAnnotation((Method)method, Selector.class);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerBeanAutoConfiguration.class);
    private reactor.event.selector.Selector defaultSelector = Selectors.anonymous();
    private Map<String, Boolean> wiredBeans = new HashMap<String, Boolean>();
    private ApplicationContext appCtx;
    private BeanResolver beanResolver;
    private ConversionService conversionService;
    private TemplateAwareExpressionParser expressionParser = new SpelExpressionParser();
    private List<PropertyAccessor> expressionPropertyAccessors = new ArrayList<PropertyAccessor>();

    public ConsumerBeanAutoConfiguration() {
        this.expressionPropertyAccessors.add((PropertyAccessor)new EnvironmentAccessor());
        this.expressionPropertyAccessors.add((PropertyAccessor)new BeanFactoryAccessor());
        this.expressionPropertyAccessors.add((PropertyAccessor)new ReflectivePropertyAccessor());
        this.expressionPropertyAccessors.add(new DirectFieldAccessPropertyAccessor());
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    public void onApplicationEvent(ContextRefreshedEvent ev) {
        ApplicationContext ctx;
        block13: {
            ctx = ev.getApplicationContext();
            if (ctx != this.appCtx) {
                return;
            }
            if (null == this.beanResolver) {
                this.beanResolver = new BeanFactoryResolver((BeanFactory)ctx);
            }
            if (null == this.conversionService) {
                try {
                    this.conversionService = (ConversionService)ctx.getBean(REACTOR_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
                }
                catch (BeansException be) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug("reactorConversionService has not been found in the context. Skipping.");
                }
            }
        }
        for (String beanName : ctx.getBeanDefinitionNames()) {
            HashSet<Method> methods = new HashSet<Method>();
            Class type = ctx.getType(beanName);
            if (null == AnnotationUtils.findAnnotation((Class)type, reactor.spring.context.annotation.Consumer.class)) {
                this.wiredBeans.put(beanName, Boolean.FALSE);
                continue;
            }
            if (this.wiredBeans.containsKey(beanName)) continue;
            try {
                if (Function.class.isAssignableFrom(type)) {
                    methods.add(type.getDeclaredMethod("apply", new Class[0]));
                } else if (Consumer.class.isAssignableFrom(type)) {
                    methods.add(type.getDeclaredMethod("accept", new Class[0]));
                } else {
                    methods.addAll(ConsumerBeanAutoConfiguration.findHandlerMethods(type, CONSUMER_METHOD_FILTER));
                }
                this.wireBean(ctx.getBean(beanName), methods);
                this.wiredBeans.put(beanName, Boolean.TRUE);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
    }

    public void wireBean(Object bean, Set<Method> methods) {
        if (methods.isEmpty()) {
            return;
        }
        for (Method method : methods) {
            Object consumer;
            Selector selectorAnno = (Selector)AnnotationUtils.findAnnotation((Method)method, Selector.class);
            ReplyTo replyToAnno = (ReplyTo)AnnotationUtils.findAnnotation((Method)method, ReplyTo.class);
            Observable reactor = this.fetchObservable(selectorAnno, bean);
            reactor.event.selector.Selector selector = this.fetchSelector(selectorAnno, bean, method);
            Object replyTo = replyToAnno != null ? this.parseReplyTo(replyToAnno, bean) : null;
            Invoker handler = new Invoker(method, bean, this.conversionService);
            Object object = consumer = null != replyToAnno ? new ReplyToServiceConsumer(reactor, replyTo, handler) : new ServiceConsumer(handler);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attaching Consumer to Reactor[" + reactor + "] using Selector[" + selector + "]");
            }
            if (null == selector) {
                throw new IllegalArgumentException("Selector cannot be null");
            }
            reactor.on(selector, (Consumer)consumer);
        }
    }

    private <T> T expression(String selector, Object bean) {
        if (selector == null) {
            return null;
        }
        StandardEvaluationContext evalCtx = new StandardEvaluationContext(bean);
        evalCtx.setBeanResolver(this.beanResolver);
        evalCtx.setPropertyAccessors(this.expressionPropertyAccessors);
        return (T)this.expressionParser.parseExpression(selector).getValue((EvaluationContext)evalCtx);
    }

    private Observable fetchObservable(Selector selectorAnno, Object bean) {
        return (Observable)this.expression(selectorAnno.reactor(), bean);
    }

    private Object parseSelector(Selector selector, Object bean, Method method) {
        if (!StringUtils.hasText((String)selector.value())) {
            return method.getName();
        }
        try {
            return this.expression(selector.value(), bean);
        }
        catch (Exception e) {
            return selector.value();
        }
    }

    private Object parseReplyTo(ReplyTo selector, Object bean) {
        if (StringUtils.isEmpty((Object)selector.value())) {
            return null;
        }
        try {
            return this.expression(selector.value(), bean);
        }
        catch (EvaluationException ee) {
            return selector.value();
        }
    }

    private reactor.event.selector.Selector fetchSelector(Selector selectorAnno, Object bean, Method method) {
        Object sel;
        block11: {
            sel = this.parseSelector(selectorAnno, bean, method);
            try {
                switch (selectorAnno.type()) {
                    case OBJECT: {
                        return Selectors.object((Object)sel);
                    }
                    case REGEX: {
                        return Selectors.regex((String)sel.toString());
                    }
                    case URI: {
                        return Selectors.uri((String)sel.toString());
                    }
                    case TYPE: {
                        try {
                            return Selectors.type(Class.forName(sel.toString()));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    }
                    case JSON_PATH: {
                        return JsonPathSelector.jsonPathSelector((String)sel.toString(), (Filter[])new Filter[0]);
                    }
                }
            }
            catch (EvaluationException e) {
                if (!LOG.isTraceEnabled()) break block11;
                LOG.trace("Creating ObjectSelector for '" + sel + "' due to " + e.getMessage(), (Throwable)e);
            }
        }
        return Selectors.object((Object)sel);
    }

    private static Set<Method> findHandlerMethods(Class<?> handlerType, final ReflectionUtils.MethodFilter handlerMethodFilter) {
        final LinkedHashSet<Method> handlerMethods = new LinkedHashSet<Method>();
        if (handlerType == null) {
            return handlerMethods;
        }
        LinkedHashSet handlerTypes = new LinkedHashSet();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(handlerType)) {
            handlerTypes.add(handlerType);
            specificHandlerType = handlerType;
        }
        handlerTypes.addAll(Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            final Class targetClass = specificHandlerType != null ? specificHandlerType : clazz;
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (handlerMethodFilter.matches(specificMethod) && (bridgedMethod == specificMethod || !handlerMethodFilter.matches(bridgedMethod))) {
                        handlerMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return handlerMethods;
    }

    private static class DirectFieldAccessPropertyAccessor
    implements PropertyAccessor {
        private static final Map<Integer, Field> fieldCache = new ConcurrentHashMap<Integer, Field>();

        private DirectFieldAccessPropertyAccessor() {
        }

        public Class<?>[] getSpecificTargetClasses() {
            return null;
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            return null != this.findField(target, name);
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            Field fld = this.findField(target, name);
            try {
                Object obj = fld.get(target);
                return new TypedValue(obj, TypeDescriptor.forObject((Object)obj));
            }
            catch (IllegalAccessException e) {
                throw new AccessException(e.getMessage(), (Exception)e);
            }
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
            return null != this.findField(target, name);
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            Field fld = this.findField(target, name);
            try {
                fld.set(target, newValue);
            }
            catch (IllegalAccessException e) {
                throw new AccessException(e.getMessage(), (Exception)e);
            }
        }

        private Field findField(Object target, final String name) {
            final int cacheKey = target.hashCode() & name.hashCode();
            if (!fieldCache.containsKey(cacheKey)) {
                ReflectionUtils.doWithFields(target.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                        if (name.equals(field.getName())) {
                            ReflectionUtils.makeAccessible((Field)field);
                            fieldCache.put(cacheKey, field);
                        }
                    }
                });
            }
            return fieldCache.get(cacheKey);
        }
    }

    private static final class Invoker
    implements Function<Event, Object> {
        private final Method method;
        private final Object bean;
        private final Class<?>[] argTypes;
        private final ConversionService conversionService;

        Invoker(Method method, Object bean, ConversionService conversionService) {
            this.method = method;
            this.bean = bean;
            this.conversionService = conversionService;
            this.argTypes = method.getParameterTypes();
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getBean() {
            return this.bean;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Object apply(Event ev) {
            if (this.argTypes.length == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + ev);
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean);
            }
            if (this.argTypes.length > 1) {
                throw new IllegalStateException("Multiple parameters not yet supported.");
            }
            if (Event.class.isAssignableFrom(this.argTypes[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + ev);
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{ev});
            }
            if (null == ev.getData() || this.argTypes[0].isAssignableFrom(ev.getData().getClass())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + ev.getData());
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{ev.getData()});
            }
            if (!this.argTypes[0].isAssignableFrom(ev.getClass()) && this.conversionService.canConvert(ev.getClass(), this.argTypes[0])) {
                ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{this.conversionService.convert((Object)ev, this.argTypes[0])});
            }
            if (this.conversionService.canConvert(ev.getData().getClass(), this.argTypes[0])) {
                Object convertedObj = this.conversionService.convert(ev.getData(), this.argTypes[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking method[" + this.method + "] on " + this.bean.getClass() + " using " + convertedObj);
                }
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{convertedObj});
            }
            throw new IllegalArgumentException("Cannot invoke method " + this.method + " passing parameter " + ev.getData());
        }
    }

    private static final class ServiceConsumer
    implements Consumer<Event> {
        private final Invoker handler;

        ServiceConsumer(Invoker handler) {
            this.handler = handler;
        }

        public Invoker getHandler() {
            return this.handler;
        }

        public void accept(Event ev) {
            this.handler.apply(ev);
        }
    }

    private static final class ReplyToServiceConsumer
    implements Consumer<Event> {
        private final Observable reactor;
        private final Object replyToKey;
        private final Invoker handler;

        ReplyToServiceConsumer(Observable reactor, Object replyToKey, Invoker handler) {
            this.reactor = reactor;
            this.replyToKey = replyToKey;
            this.handler = handler;
        }

        public Observable getReactor() {
            return this.reactor;
        }

        public Object getReplyToKey() {
            return this.replyToKey;
        }

        public Invoker getHandler() {
            return this.handler;
        }

        public void accept(Event ev) {
            Object _replyToKey;
            Object result = this.handler.apply(ev);
            Object object = _replyToKey = this.replyToKey != null ? this.replyToKey : ev.getReplyTo();
            if (_replyToKey != null) {
                this.reactor.notify(_replyToKey, Event.wrap((Object)result));
            }
        }
    }
}

