/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;
import lombok.core.ClassLiteral;
import lombok.core.FieldSelect;
import lombok.javac.JavacTreeMaker;
import lombok.permit.Permit;

public class Javac {
    private static final Pattern PRIMITIVE_TYPE_NAME_PATTERN = Pattern.compile("^(boolean|byte|short|int|long|float|double|char)$");
    private static final Pattern VERSION_PARSER = Pattern.compile("^(\\d{1,6})\\.?(\\d{1,6})?.*$");
    private static final Pattern SOURCE_PARSER = Pattern.compile("^JDK(\\d{1,6})_?(\\d{1,6})?.*$");
    private static final AtomicInteger compilerVersion = new AtomicInteger(-1);
    private static final Class<?> DOCCOMMENTTABLE_CLASS;
    public static final JavacTreeMaker.TypeTag CTC_BOOLEAN;
    public static final JavacTreeMaker.TypeTag CTC_INT;
    public static final JavacTreeMaker.TypeTag CTC_DOUBLE;
    public static final JavacTreeMaker.TypeTag CTC_FLOAT;
    public static final JavacTreeMaker.TypeTag CTC_SHORT;
    public static final JavacTreeMaker.TypeTag CTC_BYTE;
    public static final JavacTreeMaker.TypeTag CTC_LONG;
    public static final JavacTreeMaker.TypeTag CTC_CHAR;
    public static final JavacTreeMaker.TypeTag CTC_VOID;
    public static final JavacTreeMaker.TypeTag CTC_NONE;
    public static final JavacTreeMaker.TypeTag CTC_BOT;
    public static final JavacTreeMaker.TypeTag CTC_ERROR;
    public static final JavacTreeMaker.TypeTag CTC_UNKNOWN;
    public static final JavacTreeMaker.TypeTag CTC_UNDETVAR;
    public static final JavacTreeMaker.TypeTag CTC_CLASS;
    public static final JavacTreeMaker.TreeTag CTC_NOT_EQUAL;
    public static final JavacTreeMaker.TreeTag CTC_LESS_THAN;
    public static final JavacTreeMaker.TreeTag CTC_GREATER_THAN;
    public static final JavacTreeMaker.TreeTag CTC_LESS_OR_EQUAL;
    public static final JavacTreeMaker.TreeTag CTC_GREATER_OR_EQUAL;
    public static final JavacTreeMaker.TreeTag CTC_POS;
    public static final JavacTreeMaker.TreeTag CTC_NEG;
    public static final JavacTreeMaker.TreeTag CTC_NOT;
    public static final JavacTreeMaker.TreeTag CTC_COMPL;
    public static final JavacTreeMaker.TreeTag CTC_BITXOR;
    public static final JavacTreeMaker.TreeTag CTC_UNSIGNED_SHIFT_RIGHT;
    public static final JavacTreeMaker.TreeTag CTC_MUL;
    public static final JavacTreeMaker.TreeTag CTC_DIV;
    public static final JavacTreeMaker.TreeTag CTC_PLUS;
    public static final JavacTreeMaker.TreeTag CTC_MINUS;
    public static final JavacTreeMaker.TreeTag CTC_EQUAL;
    public static final JavacTreeMaker.TreeTag CTC_PREINC;
    public static final JavacTreeMaker.TreeTag CTC_PREDEC;
    public static final JavacTreeMaker.TreeTag CTC_POSTINC;
    public static final JavacTreeMaker.TreeTag CTC_POSTDEC;
    private static final Method getExtendsClause;
    private static final Method getEndPosition;
    private static final Method storeEnd;
    private static final Class<?> JC_VOID_TYPE;
    private static final Class<?> JC_NO_TYPE;
    private static final Field symtabVoidType;
    private static final Field JCCOMPILATIONUNIT_ENDPOSITIONS;
    private static final Field JCCOMPILATIONUNIT_DOCCOMMENTS;

    private Javac() {
    }

    public static int getJavaCompilerVersion() {
        String name;
        Matcher m;
        int cv = compilerVersion.get();
        if (cv != -1) {
            return cv;
        }
        Matcher m2 = VERSION_PARSER.matcher(JavaCompiler.version());
        if (m2.matches()) {
            int major = Integer.parseInt(m2.group(1));
            if (major == 1) {
                int minor = Integer.parseInt(m2.group(2));
                return Javac.setVersion(minor);
            }
            if (major >= 9) {
                return Javac.setVersion(major);
            }
        }
        if ((m = SOURCE_PARSER.matcher(name = Source.values()[Source.values().length - 1].name())).matches()) {
            int major = Integer.parseInt(m.group(1));
            if (major == 1) {
                int minor = Integer.parseInt(m.group(2));
                return Javac.setVersion(minor);
            }
            if (major >= 9) {
                return Javac.setVersion(major);
            }
        }
        return Javac.setVersion(6);
    }

    private static int setVersion(int version) {
        compilerVersion.set(version);
        return version;
    }

    public static boolean instanceOfDocCommentTable(Object o) {
        return DOCCOMMENTTABLE_CLASS != null && DOCCOMMENTTABLE_CLASS.isInstance(o);
    }

    public static boolean isPrimitive(JCTree.JCExpression ref) {
        String typeName = ref.toString();
        return PRIMITIVE_TYPE_NAME_PATTERN.matcher(typeName).matches();
    }

    public static Object calculateGuess(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)expr;
            if (lit.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                return ((Number)lit.value).intValue() != 0;
            }
            return lit.value;
        }
        if (expr instanceof JCTree.JCIdent || expr instanceof JCTree.JCFieldAccess) {
            String x = expr.toString();
            if (x.endsWith(".class")) {
                return new ClassLiteral(x.substring(0, x.length() - 6));
            }
            int idx = x.lastIndexOf(46);
            if (idx > -1) {
                x = x.substring(idx + 1);
            }
            return new FieldSelect(x);
        }
        return null;
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            return Permit.getMethod(clazz, name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw Javac.sneakyThrow(e);
        }
    }

    private static Method getMethod(Class<?> clazz, String name, String ... paramTypes) {
        try {
            Class[] c = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                c[i] = Class.forName(paramTypes[i]);
            }
            return Permit.getMethod(clazz, name, c);
        }
        catch (NoSuchMethodException e) {
            throw Javac.sneakyThrow(e);
        }
        catch (ClassNotFoundException e) {
            throw Javac.sneakyThrow(e);
        }
    }

    public static JCTree getExtendsClause(JCTree.JCClassDecl decl) {
        try {
            return (JCTree)getExtendsClause.invoke((Object)decl, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
    }

    public static Object getDocComments(JCTree.JCCompilationUnit cu) {
        try {
            return JCCOMPILATIONUNIT_DOCCOMMENTS.get(cu);
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e);
        }
    }

    public static void initDocComments(JCTree.JCCompilationUnit cu) {
        try {
            JCCOMPILATIONUNIT_DOCCOMMENTS.set(cu, new HashMap());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e);
        }
    }

    public static int getEndPosition(JCDiagnostic.DiagnosticPosition pos, JCTree.JCCompilationUnit top) {
        try {
            Object endPositions = JCCOMPILATIONUNIT_ENDPOSITIONS.get(top);
            return (Integer)getEndPosition.invoke((Object)pos, endPositions);
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
    }

    public static void storeEnd(JCTree tree, int pos, JCTree.JCCompilationUnit top) {
        try {
            Object endPositions = JCCOMPILATIONUNIT_ENDPOSITIONS.get(top);
            storeEnd.invoke(endPositions, tree, pos);
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e);
        }
        catch (InvocationTargetException e) {
            throw Javac.sneakyThrow(e.getCause());
        }
    }

    private static Field getFieldIfExists(Class<?> c, String fieldName) {
        try {
            return Permit.getField(c, "voidType");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Type createVoidType(Symtab symbolTable, JavacTreeMaker.TypeTag tag) {
        if (symtabVoidType != null) {
            try {
                return (Type)symtabVoidType.get(symbolTable);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (Javac.getJavaCompilerVersion() < 8) {
            return new JCNoType((Integer)tag.value);
        }
        try {
            if (CTC_VOID.equals(tag)) {
                return (Type)JC_VOID_TYPE.newInstance();
            }
            return (Type)JC_NO_TYPE.newInstance();
        }
        catch (IllegalAccessException e) {
            throw Javac.sneakyThrow(e);
        }
        catch (InstantiationException e) {
            throw Javac.sneakyThrow(e);
        }
    }

    static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        Javac.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    static {
        Class<?> c = null;
        try {
            c = Class.forName("com.sun.tools.javac.tree.DocCommentTable");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DOCCOMMENTTABLE_CLASS = c;
        CTC_BOOLEAN = JavacTreeMaker.TypeTag.typeTag("BOOLEAN");
        CTC_INT = JavacTreeMaker.TypeTag.typeTag("INT");
        CTC_DOUBLE = JavacTreeMaker.TypeTag.typeTag("DOUBLE");
        CTC_FLOAT = JavacTreeMaker.TypeTag.typeTag("FLOAT");
        CTC_SHORT = JavacTreeMaker.TypeTag.typeTag("SHORT");
        CTC_BYTE = JavacTreeMaker.TypeTag.typeTag("BYTE");
        CTC_LONG = JavacTreeMaker.TypeTag.typeTag("LONG");
        CTC_CHAR = JavacTreeMaker.TypeTag.typeTag("CHAR");
        CTC_VOID = JavacTreeMaker.TypeTag.typeTag("VOID");
        CTC_NONE = JavacTreeMaker.TypeTag.typeTag("NONE");
        CTC_BOT = JavacTreeMaker.TypeTag.typeTag("BOT");
        CTC_ERROR = JavacTreeMaker.TypeTag.typeTag("ERROR");
        CTC_UNKNOWN = JavacTreeMaker.TypeTag.typeTag("UNKNOWN");
        CTC_UNDETVAR = JavacTreeMaker.TypeTag.typeTag("UNDETVAR");
        CTC_CLASS = JavacTreeMaker.TypeTag.typeTag("CLASS");
        CTC_NOT_EQUAL = JavacTreeMaker.TreeTag.treeTag("NE");
        CTC_LESS_THAN = JavacTreeMaker.TreeTag.treeTag("LT");
        CTC_GREATER_THAN = JavacTreeMaker.TreeTag.treeTag("GT");
        CTC_LESS_OR_EQUAL = JavacTreeMaker.TreeTag.treeTag("LE");
        CTC_GREATER_OR_EQUAL = JavacTreeMaker.TreeTag.treeTag("GE");
        CTC_POS = JavacTreeMaker.TreeTag.treeTag("POS");
        CTC_NEG = JavacTreeMaker.TreeTag.treeTag("NEG");
        CTC_NOT = JavacTreeMaker.TreeTag.treeTag("NOT");
        CTC_COMPL = JavacTreeMaker.TreeTag.treeTag("COMPL");
        CTC_BITXOR = JavacTreeMaker.TreeTag.treeTag("BITXOR");
        CTC_UNSIGNED_SHIFT_RIGHT = JavacTreeMaker.TreeTag.treeTag("USR");
        CTC_MUL = JavacTreeMaker.TreeTag.treeTag("MUL");
        CTC_DIV = JavacTreeMaker.TreeTag.treeTag("DIV");
        CTC_PLUS = JavacTreeMaker.TreeTag.treeTag("PLUS");
        CTC_MINUS = JavacTreeMaker.TreeTag.treeTag("MINUS");
        CTC_EQUAL = JavacTreeMaker.TreeTag.treeTag("EQ");
        CTC_PREINC = JavacTreeMaker.TreeTag.treeTag("PREINC");
        CTC_PREDEC = JavacTreeMaker.TreeTag.treeTag("PREDEC");
        CTC_POSTINC = JavacTreeMaker.TreeTag.treeTag("POSTINC");
        CTC_POSTDEC = JavacTreeMaker.TreeTag.treeTag("POSTDEC");
        getExtendsClause = Javac.getMethod(JCTree.JCClassDecl.class, "getExtendsClause", new Class[0]);
        if (Javac.getJavaCompilerVersion() < 8) {
            getEndPosition = Javac.getMethod(JCDiagnostic.DiagnosticPosition.class, "getEndPosition", Map.class);
            storeEnd = Javac.getMethod(Map.class, "put", Object.class, Object.class);
        } else {
            Method storeEndMethodTemp;
            Class<?> endPosTable;
            getEndPosition = Javac.getMethod(JCDiagnostic.DiagnosticPosition.class, "getEndPosition", "com.sun.tools.javac.tree.EndPosTable");
            try {
                endPosTable = Class.forName("com.sun.tools.javac.tree.EndPosTable");
            }
            catch (ClassNotFoundException ex) {
                throw Javac.sneakyThrow(ex);
            }
            try {
                storeEndMethodTemp = Permit.getMethod(endPosTable, "storeEnd", JCTree.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                try {
                    endPosTable = Class.forName("com.sun.tools.javac.parser.JavacParser$AbstractEndPosTable");
                    storeEndMethodTemp = Permit.getMethod(endPosTable, "storeEnd", JCTree.class, Integer.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    throw Javac.sneakyThrow(ex);
                }
                catch (ClassNotFoundException ex) {
                    throw Javac.sneakyThrow(ex);
                }
            }
            storeEnd = storeEndMethodTemp;
        }
        Permit.setAccessible(getEndPosition);
        Permit.setAccessible(storeEnd);
        c = null;
        try {
            c = Class.forName("com.sun.tools.javac.code.Type$JCVoidType");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JC_VOID_TYPE = c;
        c = null;
        try {
            c = Class.forName("com.sun.tools.javac.code.Type$JCNoType");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JC_NO_TYPE = c;
        symtabVoidType = Javac.getFieldIfExists(Symtab.class, "voidType");
        Field f = null;
        try {
            f = Permit.getField(JCTree.JCCompilationUnit.class, "endPositions");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        JCCOMPILATIONUNIT_ENDPOSITIONS = f;
        f = null;
        try {
            f = Permit.getField(JCTree.JCCompilationUnit.class, "docComments");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        JCCOMPILATIONUNIT_DOCCOMMENTS = f;
    }

    private static class JCNoType
    extends Type
    implements NoType {
        public JCNoType(int tag) {
            super(tag, null);
        }

        @Override
        public TypeKind getKind() {
            if (this.tag == (Integer)Javac.CTC_VOID.value) {
                return TypeKind.VOID;
            }
            if (this.tag == (Integer)Javac.CTC_NONE.value) {
                return TypeKind.NONE;
            }
            throw new AssertionError((Object)("Unexpected tag: " + this.tag));
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }
}

