/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import lombok.core.ClassLiteral;
import lombok.core.FieldSelect;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class Eclipse {
    private static final Annotation[] EMPTY_ANNOTATIONS_ARRAY = new Annotation[0];
    public static final int ECLIPSE_DO_NOT_TOUCH_FLAG = 0x800000;
    private static final Pattern SPLIT_AT_DOT = Pattern.compile("\\.");
    private static final Pattern PRIMITIVE_TYPE_NAME_PATTERN = Pattern.compile("^(boolean|byte|short|int|long|float|double|char)$");
    private static long latestEcjCompilerVersionConstantCached = 0L;
    private static int ecjCompilerVersionCached = -1;

    private Eclipse() {
    }

    public static String toQualifiedName(char[][] typeName) {
        int len = typeName.length - 1;
        if (len == 0) {
            return new String(typeName[0]);
        }
        char[][] cArray = typeName;
        int n = typeName.length;
        int n2 = 0;
        while (n2 < n) {
            char[] c = cArray[n2];
            len += c.length;
            ++n2;
        }
        char[] ret = new char[len];
        char[] part = typeName[0];
        System.arraycopy(part, 0, ret, 0, part.length);
        int pos = part.length;
        int i = 1;
        while (i < typeName.length) {
            ret[pos++] = 46;
            part = typeName[i];
            System.arraycopy(part, 0, ret, pos, part.length);
            pos += part.length;
            ++i;
        }
        return new String(ret);
    }

    public static char[][] fromQualifiedName(String typeName) {
        String[] split = SPLIT_AT_DOT.split(typeName);
        char[][] result = new char[split.length][];
        int i = 0;
        while (i < split.length) {
            result[i] = split[i].toCharArray();
            ++i;
        }
        return result;
    }

    public static long pos(ASTNode node) {
        return (long)node.sourceStart << 32 | (long)node.sourceEnd & 0xFFFFFFFFL;
    }

    public static long[] poss(ASTNode node, int repeat) {
        long p = (long)node.sourceStart << 32 | (long)node.sourceEnd & 0xFFFFFFFFL;
        long[] out = new long[repeat];
        Arrays.fill(out, p);
        return out;
    }

    public static boolean nameEquals(char[][] typeName, String string) {
        int pos = 0;
        int len = string.length();
        int i = 0;
        while (i < typeName.length) {
            char[] t = typeName[i];
            if (i > 0) {
                if (pos == len) {
                    return false;
                }
                if (string.charAt(pos++) != '.') {
                    return false;
                }
            }
            int j = 0;
            while (j < t.length) {
                if (pos == len) {
                    return false;
                }
                if (string.charAt(pos++) != t[j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasClinit(TypeDeclaration parent) {
        if (parent.methods == null) {
            return false;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = parent.methods;
        int n = parent.methods.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMethodDeclaration method = abstractMethodDeclarationArray[n2];
            if (method instanceof Clinit) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Annotation[] findAnnotations(AbstractVariableDeclaration field, Pattern namePattern) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (field.annotations == null) {
            return EMPTY_ANNOTATIONS_ARRAY;
        }
        Annotation[] annotationArray = field.annotations;
        int n = field.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            char[][] typeName;
            String suspect;
            Annotation annotation = annotationArray[n2];
            TypeReference typeRef = annotation.type;
            if (typeRef != null && typeRef.getTypeName() != null && namePattern.matcher(suspect = new String((typeName = typeRef.getTypeName())[typeName.length - 1])).matches()) {
                result.add(annotation);
            }
            ++n2;
        }
        return result.toArray(EMPTY_ANNOTATIONS_ARRAY);
    }

    public static boolean isPrimitive(TypeReference ref) {
        if (ref.dimensions() > 0) {
            return false;
        }
        return PRIMITIVE_TYPE_NAME_PATTERN.matcher(Eclipse.toQualifiedName(ref.getTypeName())).matches();
    }

    public static Object calculateValue(Expression e) {
        if (e instanceof Literal) {
            ((Literal)e).computeConstant();
            switch (e.constant.typeID()) {
                case 10: {
                    return e.constant.intValue();
                }
                case 3: {
                    return e.constant.byteValue();
                }
                case 4: {
                    return e.constant.shortValue();
                }
                case 2: {
                    return Character.valueOf(e.constant.charValue());
                }
                case 9: {
                    return Float.valueOf(e.constant.floatValue());
                }
                case 8: {
                    return e.constant.doubleValue();
                }
                case 5: {
                    return e.constant.booleanValue();
                }
                case 7: {
                    return e.constant.longValue();
                }
                case 11: {
                    return e.constant.stringValue();
                }
            }
            return null;
        }
        if (e instanceof ClassLiteralAccess) {
            return new ClassLiteral(Eclipse.toQualifiedName(((ClassLiteralAccess)e).type.getTypeName()));
        }
        if (e instanceof SingleNameReference) {
            return new FieldSelect(new String(((SingleNameReference)e).token));
        }
        if (e instanceof QualifiedNameReference) {
            String qName = Eclipse.toQualifiedName(((QualifiedNameReference)e).tokens);
            int idx = qName.lastIndexOf(46);
            return new FieldSelect(idx == -1 ? qName : qName.substring(idx + 1));
        }
        if (e instanceof UnaryExpression && "-".equals(((UnaryExpression)e).operatorToString())) {
            Object inner = Eclipse.calculateValue(((UnaryExpression)e).expression);
            if (inner instanceof Integer) {
                return -((Integer)inner).intValue();
            }
            if (inner instanceof Byte) {
                return (int)(-((Byte)inner).byteValue());
            }
            if (inner instanceof Short) {
                return (int)(-((Short)inner).shortValue());
            }
            if (inner instanceof Long) {
                return -((Long)inner).longValue();
            }
            if (inner instanceof Float) {
                return Float.valueOf(-((Float)inner).floatValue());
            }
            if (inner instanceof Double) {
                return -((Double)inner).doubleValue();
            }
            return null;
        }
        return null;
    }

    public static long getLatestEcjCompilerVersionConstant() {
        if (latestEcjCompilerVersionConstantCached != 0L) {
            return latestEcjCompilerVersionConstantCached;
        }
        int highestVersionSoFar = 0;
        Field[] fieldArray = ClassFileConstants.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                int thisVersion;
                if (f.getName().startsWith("JDK1_") && (thisVersion = Integer.parseInt(f.getName().substring("JDK1_".length()))) > highestVersionSoFar) {
                    highestVersionSoFar = thisVersion;
                    latestEcjCompilerVersionConstantCached = (Long)f.get(null);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (highestVersionSoFar > 6 && !Eclipse.ecjSupportsJava7Features()) {
            latestEcjCompilerVersionConstantCached = 0x320000L;
        }
        return latestEcjCompilerVersionConstantCached;
    }

    public static int getEcjCompilerVersion() {
        if (ecjCompilerVersionCached >= 0) {
            return ecjCompilerVersionCached;
        }
        Field[] fieldArray = CompilerOptions.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                if (f.getName().startsWith("VERSION_1_")) {
                    ecjCompilerVersionCached = Math.max(ecjCompilerVersionCached, Integer.parseInt(f.getName().substring("VERSION_1_".length())));
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (ecjCompilerVersionCached < 5) {
            ecjCompilerVersionCached = 5;
        }
        if (!Eclipse.ecjSupportsJava7Features()) {
            ecjCompilerVersionCached = Math.min(6, ecjCompilerVersionCached);
        }
        return ecjCompilerVersionCached;
    }

    private static boolean ecjSupportsJava7Features() {
        try {
            TryStatement.class.getDeclaredField("resources");
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }
}

