/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.HashMap;
import java.util.logging.Level;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.spi.WebDriverAdapter;

public class DefaultWebDriverAdapter
implements WebDriverAdapter {
    @Override
    public void initialize(ConfigProvider configProvider) {
        WebDriverManager webDriverManager = null;
        if ("firefox".equals(configProvider.getWebdriverBrowser())) {
            if (!System.getProperties().contains("webdriver.gecko.driver")) {
                webDriverManager = WebDriverManager.firefoxdriver();
            }
        } else if ("chrome".equals(configProvider.getWebdriverBrowser())) {
            if (!System.getProperties().contains("webdriver.chrome.driver")) {
                webDriverManager = WebDriverManager.chromedriver();
            }
        } else if ("safari".equals(configProvider.getWebdriverBrowser()) && !System.getProperties().contains("webdriver.safari.driver")) {
            webDriverManager = WebDriverManager.safaridriver();
        }
        if (webDriverManager != null) {
            if (configProvider.getWebdriverVersion() != null) {
                webDriverManager = webDriverManager.driverVersion(configProvider.getWebdriverVersion());
            }
            webDriverManager.setup();
        }
    }

    @Override
    public WebDriver createWebDriver() {
        ConfigProvider config = ConfigProvider.getInstance();
        if (config.getWebdriverBrowser() == null) {
            throw new RuntimeException("No webdriver.browser configured; Please either configure it or implement WebDriverAdapter#getWebDriver!");
        }
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("browser", config.getWebdriverLogLevel());
        switch (config.getWebdriverBrowser()) {
            case "firefox": {
                FirefoxOptions firefoxOptions = new FirefoxOptions().configureFromEnv();
                firefoxOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                if (config.isWebdriverHeadless()) {
                    firefoxOptions.addArguments(new String[]{"-headless"});
                }
                firefoxOptions.setLogLevel(FirefoxDriverLogLevel.fromLevel((Level)config.getWebdriverLogLevel()));
                firefoxOptions.addPreference("browser.helperApps.neverAsk.openFile", (Object)"application/octet-stream");
                return new FirefoxDriver(firefoxOptions);
            }
            case "chrome": {
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                if (config.isWebdriverHeadless()) {
                    chromeOptions.addArguments(new String[]{"--headless=new"});
                }
                chromeOptions.setCapability("goog:loggingPrefs", (Object)logPrefs);
                chromeOptions.addArguments(new String[]{"--remote-allow-origins=*"});
                HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
                chromePrefs.put("download.prompt_for_download", false);
                chromePrefs.put("download.directory_upgrade", true);
                chromePrefs.put("safebrowsing.enabled", true);
                chromePrefs.put("profile.default_content_settings.popups", 0);
                chromePrefs.put("download.default_directory", System.getProperty("java.io.tmpdir"));
                chromeOptions.setExperimentalOption("prefs", chromePrefs);
                return new ChromeDriver(chromeOptions);
            }
            case "safari": {
                SafariOptions safariOptions = new SafariOptions();
                safariOptions.setCapability("safari:diagnose", "true");
                return new SafariDriver(safariOptions);
            }
        }
        throw new RuntimeException("Current supported browsers are: safari, firefox, chrome");
    }
}

