/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.findby;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.primefaces.selenium.findby.FindByParentPartialId;

public class FindByParentPartialIdElementLocator
implements ElementLocator {
    private final WebDriver driver;
    private final ElementLocator parentLocator;
    private final FindByParentPartialId annotation;

    public FindByParentPartialIdElementLocator(WebDriver driver, ElementLocator parentLocator, FindByParentPartialId annotation) {
        this.driver = driver;
        this.parentLocator = parentLocator;
        this.annotation = annotation;
    }

    public WebElement findElement() {
        List<WebElement> elements = this.findElements();
        if (elements == null || elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate element using: " + this.annotation.value());
        }
        return elements.get(0);
    }

    public List<WebElement> findElements() {
        WebElement parent = this.parentLocator.findElement();
        String parentId = parent.getDomAttribute("id");
        if (parentId == null || parentId.trim().isEmpty()) {
            throw new WebDriverException("Id of parent element is null or empty!");
        }
        By by = this.annotation.name().length() > 0 ? By.name((String)(parentId + this.annotation.name())) : By.id((String)(parentId + this.annotation.value()));
        if (this.annotation.searchFromRoot()) {
            return this.driver.findElements(by);
        }
        return parent.findElements(by);
    }
}

