/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.spi;

import java.util.ArrayList;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.events.EventFiringDecorator;
import org.openqa.selenium.support.events.WebDriverListener;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.internal.OnloadScriptsEventListener;
import org.primefaces.selenium.internal.ScrollElementIntoViewClickListener;
import org.primefaces.selenium.spi.WebDriverAdapter;

public class WebDriverProvider {
    private static final ThreadLocal<WebDriver> WEB_DRIVER = new ThreadLocal();
    private static final int CREATE_WEBDRIVER_RETRIES = 3;

    private WebDriverProvider() {
    }

    public static void set(WebDriver driver) {
        WEB_DRIVER.set(driver);
    }

    public static WebDriver get() {
        return WebDriverProvider.get(false);
    }

    public static WebDriver get(boolean create) {
        WebDriver driver = WEB_DRIVER.get();
        if (driver == null && create) {
            WebDriverAdapter adapter = ConfigProvider.getInstance().getWebdriverAdapter();
            int fails = 0;
            do {
                try {
                    driver = adapter.createWebDriver();
                }
                catch (WebDriverException ex) {
                    if (++fails < 3) continue;
                    throw ex;
                }
            } while (driver == null);
            if (PrimeSelenium.isHeadless()) {
                driver.manage().window().setSize(new Dimension(1920, 1080));
            } else {
                driver.manage().window().setSize(new Dimension(1280, 1000));
            }
            ArrayList<Object> listeners = new ArrayList<Object>();
            listeners.add(new OnloadScriptsEventListener());
            if (ConfigProvider.getInstance().getScrollElementIntoView() != null) {
                listeners.add(new ScrollElementIntoViewClickListener(ConfigProvider.getInstance().getScrollElementIntoView()));
            }
            driver = new EventFiringDecorator(listeners.toArray(new WebDriverListener[listeners.size()])).decorate(driver);
            WebDriverProvider.set(driver);
        }
        return driver;
    }
}

