/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal.junit;

import java.lang.reflect.Field;
import javax.inject.Inject;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.openqa.selenium.WebDriver;
import org.primefaces.selenium.AbstractPrimePage;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.spi.PrimePageFactory;
import org.primefaces.selenium.spi.WebDriverProvider;

public class PageInjectionExtension
implements ParameterResolver,
TestInstancePostProcessor {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return AbstractPrimePage.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        WebDriver driver = WebDriverProvider.get(true);
        Object page = PrimePageFactory.create(parameterContext.getParameter().getType(), driver);
        PrimeSelenium.goTo(page);
        return page;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getAnnotation(Inject.class) == null || !AbstractPrimePage.class.isAssignableFrom(field.getType()) || field.get(testInstance) != null) continue;
            WebDriver driver = WebDriverProvider.get(true);
            Object page = PrimePageFactory.create(field.getType(), driver);
            field.set(testInstance, page);
        }
    }
}

