/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.primefaces.selenium.internal.DefaultWebDriverAdapter;
import org.primefaces.selenium.spi.DeploymentAdapter;
import org.primefaces.selenium.spi.OnloadScriptsAdapter;
import org.primefaces.selenium.spi.WebDriverAdapter;

public class ConfigProvider {
    private static ConfigProvider configProvider = null;
    private int timeoutGui = 2;
    private int timeoutAjax = 10;
    private int timeoutHttp = 10;
    private int timeoutDocumentLoad = 15;
    private int timeoutFileUpload = 20;
    private String scrollElementIntoView;
    private boolean disableAnimations = true;
    private WebDriverAdapter webdriverAdapter;
    private String webdriverBrowser;
    private boolean webdriverHeadless = false;
    private String webdriverVersion;
    private Level webdriverLogLevel = Level.WARNING;
    private String deploymentBaseUrl;
    private DeploymentAdapter deploymentAdapter;
    private OnloadScriptsAdapter onloadScriptsAdapter;
    private List<String> onloadScripts;

    public ConfigProvider() {
        try {
            InputStream config = this.getClass().getResourceAsStream("/primefaces-selenium/config.properties");
            if (config != null) {
                String onloadScriptsAdapter;
                String webdriverLogLevel;
                String webdriverVersion;
                String webdriverHeadless;
                String webdriverBrowser;
                String webdriverAdapter;
                String deploymentAdapter;
                String deploymentBaseUrl;
                String scrollElementIntoView;
                String disableAnimations;
                String timeoutFileUpload;
                String timeoutDocumentLoad;
                String timeoutHttp;
                String timeoutAjax;
                Properties properties = new Properties();
                properties.load(config);
                String timeoutGui = properties.getProperty("timeout.gui");
                if (timeoutGui != null && !timeoutGui.trim().isEmpty()) {
                    this.timeoutGui = Integer.parseInt(timeoutGui);
                }
                if ((timeoutAjax = properties.getProperty("timeout.ajax")) != null && !timeoutAjax.trim().isEmpty()) {
                    this.timeoutAjax = Integer.parseInt(timeoutAjax);
                }
                if ((timeoutHttp = properties.getProperty("timeout.http")) != null && !timeoutHttp.trim().isEmpty()) {
                    this.timeoutHttp = Integer.parseInt(timeoutHttp);
                }
                if ((timeoutDocumentLoad = properties.getProperty("timeout.documentLoad")) != null && !timeoutDocumentLoad.trim().isEmpty()) {
                    this.timeoutDocumentLoad = Integer.parseInt(timeoutDocumentLoad);
                }
                if ((timeoutFileUpload = properties.getProperty("timeout.fileUpload")) != null && !timeoutFileUpload.trim().isEmpty()) {
                    this.timeoutFileUpload = Integer.parseInt(timeoutFileUpload);
                }
                if ((disableAnimations = properties.getProperty("disableAnimations")) != null && !disableAnimations.trim().isEmpty()) {
                    this.disableAnimations = Boolean.parseBoolean(disableAnimations);
                }
                if ((scrollElementIntoView = properties.getProperty("scrollElementIntoView")) != null && !scrollElementIntoView.trim().isEmpty()) {
                    this.scrollElementIntoView = scrollElementIntoView;
                }
                if ((deploymentBaseUrl = properties.getProperty("deployment.baseUrl")) != null && !deploymentBaseUrl.trim().isEmpty()) {
                    this.deploymentBaseUrl = deploymentBaseUrl;
                }
                if ((deploymentAdapter = properties.getProperty("deployment.adapter")) != null && !deploymentAdapter.trim().isEmpty()) {
                    this.deploymentAdapter = (DeploymentAdapter)Class.forName(deploymentAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((webdriverAdapter = properties.getProperty("webdriver.adapter")) != null && !webdriverAdapter.trim().isEmpty()) {
                    this.webdriverAdapter = (WebDriverAdapter)Class.forName(webdriverAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((webdriverBrowser = properties.getProperty("webdriver.browser")) != null && !webdriverBrowser.trim().isEmpty()) {
                    this.webdriverBrowser = webdriverBrowser;
                }
                if ((webdriverHeadless = properties.getProperty("webdriver.headless")) != null && !webdriverHeadless.trim().isEmpty()) {
                    this.webdriverHeadless = Boolean.parseBoolean(webdriverHeadless);
                }
                if ((webdriverVersion = properties.getProperty("webdriver.version")) != null && !webdriverVersion.trim().isEmpty()) {
                    this.webdriverVersion = webdriverVersion;
                }
                if ((webdriverLogLevel = properties.getProperty("webdriver.logLevel")) != null && !webdriverLogLevel.trim().isEmpty()) {
                    this.webdriverLogLevel = Level.parse(webdriverLogLevel);
                }
                if ((onloadScriptsAdapter = properties.getProperty("onloadScripts.adapter")) != null && !onloadScriptsAdapter.trim().isEmpty()) {
                    this.onloadScriptsAdapter = (OnloadScriptsAdapter)Class.forName(onloadScriptsAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            if (this.webdriverAdapter == null) {
                this.webdriverAdapter = new DefaultWebDriverAdapter();
            }
            if (this.deploymentBaseUrl == null && this.deploymentAdapter == null) {
                throw new RuntimeException("Please either provide a deployment.baseUrl for remote testing or deployment.adapter via config.properties!");
            }
            this.buildOnloadScripts();
            this.webdriverAdapter.initialize(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildOnloadScripts() throws Exception {
        this.onloadScripts = new ArrayList<String>();
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/primefaces-selenium/onload.js"), StandardCharsets.UTF_8));){
            this.onloadScripts.add(buffer.lines().collect(Collectors.joining("\n")));
        }
        if (this.disableAnimations) {
            this.onloadScripts.add("if (window.PrimeFaces) { $(function() { PrimeFaces.utils.disableAnimations(); }); }");
            this.onloadScripts.add("document.head.insertAdjacentHTML('beforeend', '<style>*, *:before, *:after { -webkit-transition: none !important; -moz-transition: none !important; -ms-transition: none !important; -o-transition: none !important; transition: none !important; }</style>');");
        }
        if (this.scrollElementIntoView != null) {
            this.onloadScripts.add("if (window.PrimeFaces) { $(function() { PrimeFaces.hideOverlaysOnViewportChange = false; }); }");
        }
        if (this.onloadScriptsAdapter != null) {
            this.onloadScriptsAdapter.registerOnloadScripts(this.onloadScripts);
        }
    }

    public int getTimeoutGui() {
        return this.timeoutGui;
    }

    public int getTimeoutAjax() {
        return this.timeoutAjax;
    }

    public void setTimeoutAjax(int timeoutAjax) {
        this.timeoutAjax = timeoutAjax;
    }

    public int getTimeoutHttp() {
        return this.timeoutHttp;
    }

    public int getTimeoutDocumentLoad() {
        return this.timeoutDocumentLoad;
    }

    public int getTimeoutFileUpload() {
        return this.timeoutFileUpload;
    }

    public String getScrollElementIntoView() {
        return this.scrollElementIntoView;
    }

    public boolean isDisableAnimations() {
        return this.disableAnimations;
    }

    public String getDeploymentBaseUrl() {
        return this.deploymentBaseUrl;
    }

    public DeploymentAdapter getDeploymentAdapter() {
        return this.deploymentAdapter;
    }

    public List<String> getOnloadScripts() {
        return this.onloadScripts;
    }

    public WebDriverAdapter getWebdriverAdapter() {
        return this.webdriverAdapter;
    }

    public OnloadScriptsAdapter getOnloadScriptsAdapter() {
        return this.onloadScriptsAdapter;
    }

    public String getWebdriverBrowser() {
        return this.webdriverBrowser;
    }

    public boolean isWebdriverHeadless() {
        return this.webdriverHeadless;
    }

    public String getWebdriverVersion() {
        return this.webdriverVersion;
    }

    public Level getWebdriverLogLevel() {
        return this.webdriverLogLevel;
    }

    public static synchronized ConfigProvider getInstance() {
        if (configProvider == null) {
            configProvider = new ConfigProvider();
        }
        return configProvider;
    }
}

