/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;

public final class PrimeExpectedConditions {
    private PrimeExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> script(String script) {
        return driver -> (Boolean)((JavascriptExecutor)driver).executeScript(script, new Object[0]);
    }

    public static ExpectedCondition<Boolean> documentLoaded() {
        return PrimeExpectedConditions.script("return document.readyState === 'complete'");
    }

    public static ExpectedCondition<Boolean> notNavigating() {
        return PrimeExpectedConditions.script("return (!window.pfselenium || pfselenium.navigating === false);");
    }

    public static ExpectedCondition<Boolean> notSubmitting() {
        return PrimeExpectedConditions.script("return (!window.pfselenium || pfselenium.submitting === false);");
    }

    public static ExpectedCondition<Boolean> animationNotActive() {
        return PrimeExpectedConditions.script("return ((!window.jQuery || jQuery.active == 0) && (!window.PrimeFaces || PrimeFaces.animationActive === false));");
    }

    public static ExpectedCondition<Boolean> ajaxQueueEmpty() {
        return PrimeExpectedConditions.script("return (!window.PrimeFaces || PrimeFaces.ajax.Queue.isEmpty());");
    }

    public static ExpectedCondition<Boolean> elementToBeClickable(WebElement element) {
        return ExpectedConditions.and((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.elementToBeClickable((WebElement)element)});
    }

    public static ExpectedCondition<Boolean> visibleAndAnimationComplete(WebElement element) {
        return ExpectedConditions.and((ExpectedCondition[])new ExpectedCondition[]{PrimeExpectedConditions.documentLoaded(), PrimeExpectedConditions.animationNotActive(), PrimeExpectedConditions.ajaxQueueEmpty(), ExpectedConditions.visibilityOf((WebElement)element)});
    }

    public static ExpectedCondition<Boolean> invisibleAndAnimationComplete(WebElement element) {
        return ExpectedConditions.and((ExpectedCondition[])new ExpectedCondition[]{PrimeExpectedConditions.documentLoaded(), PrimeExpectedConditions.animationNotActive(), PrimeExpectedConditions.ajaxQueueEmpty(), ExpectedConditions.invisibilityOf((WebElement)element)});
    }

    public static ExpectedCondition<Boolean> visibleInViewport(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver webDriver) {
                return (Boolean)PrimeSelenium.executeScript("var elem = arguments[0],    box = elem.getBoundingClientRect(),    cx = box.left + box.width / 2,    cy = box.top + box.height / 2,    e = document.elementFromPoint(cx, cy);for (; e; e = e.parentElement) {    if (e === elem) { return true; }}return false;", element);
            }

            public String toString() {
                return "is " + element + " visible in viewport";
            }
        };
    }
}

