/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractPageableData;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.component.model.datatable.Body;
import org.primefaces.selenium.component.model.datatable.Cell;
import org.primefaces.selenium.component.model.datatable.Header;
import org.primefaces.selenium.component.model.datatable.HeaderCell;
import org.primefaces.selenium.component.model.datatable.Row;

public abstract class AbstractTable<T extends Row>
extends AbstractPageableData {
    @Override
    public List<WebElement> getRowsWebElement() {
        return this.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
    }

    public abstract T getRow(int var1);

    public Cell getCell(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
        T row = this.getRow(rowIndex);
        if (row == null) {
            throw new IndexOutOfBoundsException("Row " + rowIndex + " was not found in table");
        }
        Cell cell = ((Row)row).getCell(colIndex);
        if (cell == null) {
            throw new IndexOutOfBoundsException("Column " + colIndex + " was not found in Row " + rowIndex + ".");
        }
        return cell;
    }

    public WebElement getHeaderWebElement() {
        return this.findElement(By.tagName((String)"table")).findElement(By.tagName((String)"thead"));
    }

    public Header getHeader() {
        List<HeaderCell> cells = this.getHeaderWebElement().findElements(By.tagName((String)"th")).stream().map(HeaderCell::new).collect(Collectors.toList());
        return new Header(this.getHeaderWebElement(), cells);
    }

    public void sort(String headerText) {
        Optional<HeaderCell> cell = this.getHeader().getCell(headerText);
        if (cell.isPresent()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)cell.get().getWebElement().findElement(By.className((String)"ui-sortable-column-icon")))).click();
        } else {
            System.err.println("Header Cell '" + headerText + "' not found.");
        }
    }

    public void sort(int index) {
        HeaderCell cell = this.getHeader().getCell(index);
        if (cell != null) {
            ((WebElement)PrimeSelenium.guardAjax((Object)cell.getWebElement().findElement(By.className((String)"ui-sortable-column-icon")))).click();
        } else {
            System.err.println("Header Cell '" + index + "' not found.");
        }
    }

    public void filter(int cellIndex, String filterValue) {
        this.filter(this.getHeader().getCell(cellIndex), filterValue);
    }

    public void filter(String headerText, String filterValue) {
        Optional<HeaderCell> cell = this.getHeader().getCell(headerText);
        if (cell.isPresent()) {
            this.filter(cell.get(), filterValue);
        } else {
            System.err.println("Header Cell '" + headerText + "' not found.");
        }
    }

    public void removeFilter(int cellIndex) {
        this.filter(cellIndex, null);
    }

    public void removeFilter(String headerText) {
        this.filter(headerText, null);
    }

    private void filter(HeaderCell cell, String filterValue) {
        JSONObject cfg = this.getWidgetConfiguration();
        if (filterValue != null && filterValue.isEmpty()) {
            filterValue = null;
        }
        cell.setFilterValue(cfg, filterValue);
    }

    public void toggleSelectAllCheckBox() {
        WebElement checkboxAll = this.getSelectAllCheckBox();
        if (ComponentUtils.hasBehavior((WebElement)this, "rowSelect") || ComponentUtils.hasBehavior((WebElement)this, "rowUnselect")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)checkboxAll)).click();
        } else {
            checkboxAll.click();
        }
    }

    public WebElement getSelectAllCheckBox() {
        return this.getHeader().getCell(0).getWebElement();
    }

    public WebElement getFrozenHeaderWebElement() {
        return this.findElement(By.className((String)"ui-datatable-frozenlayout-left")).findElement(By.tagName((String)"thead"));
    }

    public Header getFrozenHeader() {
        List<HeaderCell> frozenHeaderCells = this.getFrozenHeaderWebElement().findElements(By.tagName((String)"th")).stream().map(HeaderCell::new).collect(Collectors.toList());
        return new Header(this.getFrozenHeaderWebElement(), frozenHeaderCells);
    }

    public WebElement getScrollableHeaderWebElement() {
        return this.findElement(By.className((String)"ui-datatable-frozenlayout-right")).findElement(By.tagName((String)"thead"));
    }

    public Header getScrollableHeader() {
        List<HeaderCell> scrollableHeaderCells = this.getScrollableHeaderWebElement().findElements(By.tagName((String)"th")).stream().map(HeaderCell::new).collect(Collectors.toList());
        return new Header(this.getScrollableHeaderWebElement(), scrollableHeaderCells);
    }

    public WebElement getFrozenBodyWebElement() {
        return this.findElement(By.className((String)"ui-datatable-frozenlayout-left")).findElement(By.tagName((String)"tbody"));
    }

    public WebElement getScrollableBodyWebElement() {
        return this.findElement(By.className((String)"ui-datatable-frozenlayout-right")).findElement(By.tagName((String)"tbody"));
    }

    public Body getFrozenBody() {
        ArrayList<Row> rows = new ArrayList<Row>();
        List frozenBodyRows = this.getFrozenBodyWebElement().findElements(By.tagName((String)"tr"));
        frozenBodyRows.forEach(row -> {
            List rowCellsTmp = row.findElements(By.tagName((String)"td"));
            List<Cell> rowCells = rowCellsTmp.stream().map(Cell::new).collect(Collectors.toList());
            rows.add(new Row((WebElement)row, rowCells));
        });
        return new Body(this.getFrozenBodyWebElement(), rows);
    }

    public Body getScrollableBody() {
        ArrayList<Row> rows = new ArrayList<Row>();
        List scrollableBodyRows = this.getScrollableBodyWebElement().findElements(By.tagName((String)"tr"));
        scrollableBodyRows.forEach(row -> {
            List rowCellsTmp = row.findElements(By.tagName((String)"td"));
            List<Cell> rowCells = rowCellsTmp.stream().map(Cell::new).collect(Collectors.toList());
            rows.add(new Row((WebElement)row, rowCells));
        });
        return new Body(this.getScrollableBodyWebElement(), rows);
    }
}

