/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import java.util.function.Function;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class AbstractToggleComponent
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public boolean isSelected() {
        return this.getValue();
    }

    public void click() {
        PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.getRoot()));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)this.getRoot()));
        if (this.isOnChangeAjaxified()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)this.getRoot())).click();
        } else {
            this.getRoot().click();
        }
    }

    public boolean isOnChangeAjaxified() {
        return this.isAjaxified(this.getInput(), "onchange") || ComponentUtils.hasAjaxBehavior(this.getRoot(), "change");
    }

    public void setValue(boolean value) {
        if (this.getValue() != value) {
            this.click();
        }
    }

    public boolean getValue() {
        return this.getInput().getAttribute("checked") != null;
    }

    public void toggle() {
        PrimeSelenium.executeScript((boolean)this.isOnChangeAjaxified(), (String)(this.getWidgetByIdScript() + ".toggle();"), (Object[])new Object[0]);
    }

    public void check() {
        PrimeSelenium.executeScript((boolean)this.isOnChangeAjaxified(), (String)(this.getWidgetByIdScript() + ".check();"), (Object[])new Object[0]);
    }

    public void uncheck() {
        PrimeSelenium.executeScript((boolean)this.isOnChangeAjaxified(), (String)(this.getWidgetByIdScript() + ".uncheck();"), (Object[])new Object[0]);
    }
}

