/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.internal.Guard;

public abstract class FileUpload
extends AbstractInputComponent {
    @Override
    public WebElement getInput() {
        boolean isInputFile = "input".equals(this.getTagName()) && "file".equals(this.getAttribute("type"));
        return isInputFile ? this : this.findElement(By.id((String)(this.getId() + "_input")));
    }

    public String getValue() {
        return this.getInput().getAttribute("value");
    }

    public void setValue(Serializable value) {
        this.setValue(value, true);
    }

    public void setValue(Serializable value, boolean useGuard) {
        Runnable runnable = () -> {
            if (this.getInput() != this && !PrimeSelenium.isChrome()) {
                this.getInput().clear();
            }
            this.getInput().sendKeys(new CharSequence[]{value.toString()});
            PrimeSelenium.wait((int)200);
        };
        if (this.isAutoUpload()) {
            if (useGuard) {
                if (this.isAdvancedMode()) {
                    Runnable guarded = (Runnable)Guard.custom((Object)runnable, (int)200, (int)ConfigProvider.getInstance().getTimeoutFileUpload(), (ExpectedCondition[])new ExpectedCondition[]{PrimeExpectedConditions.script((String)("return " + this.getWidgetByIdScript() + ".files.length === 0;"))});
                    guarded.run();
                } else {
                    ((Runnable)PrimeSelenium.guardAjax((Object)runnable)).run();
                }
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public void setValue(File ... values) {
        this.setValue(true, values);
    }

    public void setValue(boolean useGuard, File ... values) {
        String paths = Arrays.stream(values).map(f -> f.getAbsolutePath()).collect(Collectors.joining("\n"));
        this.setValue((Serializable)((Object)paths), useGuard);
    }

    public WebElement getAdvancedUploadButton() {
        WebElement element = this.findElement(By.cssSelector((String)".ui-fileupload-buttonbar button.ui-fileupload-upload"));
        WebElement guarded = (WebElement)Guard.custom((Object)element, (int)200, (int)ConfigProvider.getInstance().getTimeoutFileUpload(), (ExpectedCondition[])new ExpectedCondition[]{PrimeExpectedConditions.script((String)("return " + this.getWidgetByIdScript() + ".files.length === 0;"))});
        return guarded;
    }

    public WebElement getAdvancedCancelButton() {
        return this.findElement(By.cssSelector((String)".ui-fileupload-buttonbar button.ui-fileupload-cancel"));
    }

    public WebElement getAdvancedCancelButton(String fileName) {
        for (WebElement row : this.findElements(By.cssSelector((String)".ui-fileupload-files .ui-fileupload-row"))) {
            WebElement fn = row.findElement(By.cssSelector((String)".ui-fileupload-filename"));
            if (!fn.getText().contains(fileName)) continue;
            return row.findElement(By.cssSelector((String)"button.ui-fileupload-cancel"));
        }
        throw new NoSuchElementException("cancel button for " + fileName + " not found");
    }

    public String getFilename() {
        return this.findElement(By.className((String)"ui-fileupload-filename")).getText();
    }

    public List<String> getWidgetValues() {
        return this.findElements(By.className((String)"ui-fileupload-filename")).stream().map(e -> e.getText()).collect(Collectors.toList());
    }

    public List<String> getWidgetErrorMessages() {
        return this.findElements(By.className((String)"ui-messages-error-summary")).stream().map(e -> e.getText()).collect(Collectors.toList());
    }

    public boolean isAdvancedMode() {
        return "advanced".equals(this.getWidgetConfiguration().getString("mode"));
    }

    public boolean isAutoUpload() {
        return this.getWidgetConfiguration().has("auto") ? this.getWidgetConfiguration().getBoolean("auto") : false;
    }
}

