/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;

public abstract class BlockUI
extends AbstractComponent {
    public List<WebElement> getOverlays() {
        return this.getWebDriver().findElements(By.className((String)"ui-blockui"));
    }

    public List<WebElement> getContents() {
        return this.getWebDriver().findElements(By.className((String)"ui-blockui-content"));
    }

    public boolean isBlocking() {
        return (Boolean)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".isBlocking();"), (Object[])new Object[0]);
    }

    public boolean hasContent() {
        return (Boolean)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".hasContent();"), (Object[])new Object[0]);
    }

    public void show() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show();"), (Object[])new Object[0]);
        List<WebElement> overlays = this.getOverlays();
        if (overlays.size() > 0) {
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)overlays.get(0)));
        }
    }

    public void hide() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
        List<WebElement> overlays = this.getOverlays();
        if (overlays.size() > 0) {
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)overlays.get(0)));
        }
    }
}

