/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.model.tree;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.Tree;

public class TreeNode {
    private WebElement webElement;
    private TreeNode parent;
    private Tree tree;
    private String selector;
    private String childSelector;

    public TreeNode(WebElement webElement, String selector, Tree tree) {
        this.webElement = webElement;
        this.selector = selector;
        this.childSelector = selector + ">.ui-treenode-children>.ui-treenode";
        this.tree = tree;
    }

    public TreeNode(WebElement webElement, String selector, TreeNode parent) {
        this.webElement = webElement;
        this.selector = selector;
        this.childSelector = selector + ">.ui-treenode-children>.ui-treenode";
        this.parent = parent;
        this.tree = parent.getTree();
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public Tree getTree() {
        return this.tree;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void toggle() {
        ((WebElement)PrimeSelenium.guardAjax((Object)this.getTreeToggler())).click();
    }

    public void select() {
        ((WebElement)PrimeSelenium.guardAjax((Object)this.getLabel())).click();
    }

    public WebElement getTreeToggler() {
        return this.webElement.findElement(By.cssSelector((String)".ui-treenode-content .ui-tree-toggler"));
    }

    public String getLabelText() {
        return this.getLabel().getText();
    }

    public WebElement getLabel() {
        return this.webElement.findElement(By.cssSelector((String)".ui-treenode-content .ui-treenode-label"));
    }

    public List<TreeNode> getChildren() {
        return this.webElement.findElements(By.cssSelector((String)this.childSelector)).stream().map(e -> new TreeNode((WebElement)e, this.childSelector, this)).collect(Collectors.toList());
    }
}

