/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class SelectCheckboxMenu
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindByParentPartialId(value="_panel", searchFromRoot=true)
    private WebElement panel;
    @FindByParentPartialId(value="_filter", searchFromRoot=true)
    private WebElement filterInput;
    @FindBy(css="input[type='checkbox']")
    private List<WebElement> checkboxes;
    @FindBy(css="input[type='checkbox']:checked")
    private List<WebElement> selectedCheckboxes;

    public WebElement getFilterInput() {
        return this.filterInput;
    }

    public WebElement getPanel() {
        return this.panel;
    }

    public List<WebElement> getCheckboxes() {
        return this.checkboxes;
    }

    public List<WebElement> getSelectedCheckboxes() {
        return this.selectedCheckboxes;
    }

    public boolean isItemSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemSelect");
    }

    public boolean isItemUnselectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemUnselect");
    }

    public void togglPanel() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".togglePanel();"), (Object[])new Object[0]);
    }

    public void show() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && !panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void hide() {
        WebElement panel = this.getPanel();
        if (this.isEnabled() && panel.isDisplayed()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)panel));
        }
    }

    public void checkAll() {
        if (this.isEnabled()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".checkAll();"), (Object[])new Object[0]);
        }
    }

    public void uncheckAll() {
        if (this.isEnabled()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".uncheckAll();"), (Object[])new Object[0]);
        }
    }

    public void resetValue() {
        if (this.isEnabled()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".resetValue();"), (Object[])new Object[0]);
        }
    }

    public void selectValue(String value) {
        if (this.isEnabled()) {
            PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".selectValue('" + value + "');"), (Object[])new Object[0]);
        }
    }
}

