/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class DatePicker
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    public void click() {
        this.input.click();
        PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.getPanel()));
    }

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getPanel() {
        return this.getWebDriver().findElement(By.id((String)(this.getId() + "_panel")));
    }

    public boolean isDateSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "dateSelect");
    }

    public boolean isViewChangeAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "viewChange");
    }

    public boolean isCloseAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "close");
    }

    public WebElement getNextMonthLink() {
        WebElement link = this.showPanel().findElement(By.className((String)"ui-datepicker-next"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if (this.isViewChangeAjaxified()) {
            link = (WebElement)PrimeSelenium.guardAjax((Object)link);
        }
        return link;
    }

    public WebElement getPreviousMonthLink() {
        WebElement link = this.showPanel().findElement(By.className((String)"ui-datepicker-prev"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if (this.isViewChangeAjaxified()) {
            link = (WebElement)PrimeSelenium.guardAjax((Object)link);
        }
        return link;
    }

    public WebElement selectDay(String day) {
        WebElement link = this.showPanel().findElement(By.linkText((String)day));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if (this.isDateSelectAjaxified()) {
            link = (WebElement)PrimeSelenium.guardAjax((Object)link);
        }
        link.click();
        return link;
    }

    public WebElement getClearButton() {
        WebElement button = this.showPanel().findElement(By.className((String)"ui-datepicker-buttonbar")).findElement(By.className((String)"ui-clear-button"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)button));
        return button;
    }

    public WebElement getTodayButton() {
        WebElement button = this.showPanel().findElement(By.className((String)"ui-datepicker-buttonbar")).findElement(By.className((String)"ui-today-button"));
        PrimeSelenium.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)button));
        return button;
    }

    public LocalDateTime getValue() {
        if (!this.hasDate()) {
            return null;
        }
        Number epoch = (Number)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getTime();"), (Object[])new Object[0]);
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epoch.longValue()), ZoneId.systemDefault());
        return dateTime;
    }

    public LocalDate getValueAsLocalDate() {
        if (!this.hasDate()) {
            return null;
        }
        Long dayOfMonth = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getDate();"), (Object[])new Object[0]);
        Long month = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getMonth();"), (Object[])new Object[0]);
        Long year = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getFullYear();"), (Object[])new Object[0]);
        return LocalDate.of(year.intValue(), month.intValue() + 1, dayOfMonth.intValue());
    }

    public void setValue(LocalDate localDate) {
        this.setValue(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public void setValue(LocalDateTime dateTime) {
        long millis = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.setValue(millis);
    }

    public void setValue(long millis) {
        this.setDate(millis);
    }

    public String millisAsFormattedDate(long millis) {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".jq.data().primeDatePicker.formatDateTime(new Date(" + millis + "));"), (Object[])new Object[0]);
    }

    public boolean hasDate() {
        return (Boolean)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".hasDate();"), (Object[])new Object[0]);
    }

    public void setDate(LocalDateTime dateTime) {
        long millis = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.setDate(millis);
    }

    public void setDate(long epoch) {
        PrimeSelenium.executeScript((boolean)this.isDateSelectAjaxified(), (String)(this.getWidgetByIdScript() + ".setDate(new Date(" + epoch + "));"), (Object[])new Object[0]);
    }

    public String getWidgetDate() {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate();"), (Object[])new Object[0]);
    }

    public boolean isLazy() {
        return (Boolean)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".cfg.lazyDataModel === undefined ? false : " + this.getWidgetByIdScript() + ".cfg.lazyDataModel"), (Object[])new Object[0]);
    }

    public void updateViewDate(long epoch) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".jq.data().primeDatePicker.updateViewDate(null, new Date(" + epoch + "));"), (Object[])new Object[0]);
    }

    public WebElement showPanel() {
        if (this.isEnabled()) {
            PrimeSelenium.wait((int)110);
            if (!this.getPanel().isDisplayed()) {
                PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".show()"), (Object[])new Object[0]);
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.visibleAndAnimationComplete((WebElement)this.getPanel()));
        }
        return this.getPanel();
    }

    public void hidePanel() {
        if (this.isEnabled()) {
            if (this.getPanel().isDisplayed()) {
                PrimeSelenium.executeScript((boolean)this.isCloseAjaxified(), (String)(this.getWidgetByIdScript() + ".hide();"), (Object[])new Object[0]);
                PrimeSelenium.wait((int)110);
            }
            PrimeSelenium.waitGui().until((Function)PrimeExpectedConditions.invisibleAndAnimationComplete((WebElement)this.getPanel()));
        }
    }

    public long getTimezoneOffset() {
        return (Long)PrimeSelenium.executeScript((String)"return new Date().getTimezoneOffset();", (Object[])new Object[0]);
    }

    public void toggleMonthDropdown() {
        WebElement monthDropDown = this.showPanel().findElement(By.cssSelector((String)"select.ui-datepicker-month"));
        monthDropDown.click();
    }

    public void selectMonthDropdown(int month) {
        Select monthDropDown = new Select(this.showPanel().findElement(By.cssSelector((String)"select.ui-datepicker-month")));
        monthDropDown.selectByValue(Integer.toString(month));
    }

    public void toggleYearDropdown() {
        WebElement yearDropDown = this.showPanel().findElement(By.cssSelector((String)"select.ui-datepicker-year"));
        yearDropDown.click();
    }

    public void selectYearDropdown(int year) {
        Select yearDropDown = new Select(this.showPanel().findElement(By.cssSelector((String)"select.ui-datepicker-year")));
        yearDropDown.selectByValue(Integer.toString(year));
    }
}

