/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;

public abstract class SelectOneButton
extends AbstractInputComponent {
    @FindBy(css=".ui-button")
    private List<WebElement> options;
    @FindBy(css=".ui-button.ui-state-active")
    private WebElement activeOption;

    public List<WebElement> getOptions() {
        return this.options;
    }

    public WebElement getActiveOption() {
        return this.activeOption;
    }

    public List<String> getOptionLabels() {
        ArrayList<String> result = new ArrayList<String>();
        this.getOptions().forEach(element -> result.add(element.getText()));
        return result;
    }

    public String getSelectedLabel() {
        return this.getActiveOption().getText();
    }

    public boolean isSelected(String label) {
        return this.getSelectedLabel().equalsIgnoreCase(label);
    }

    public boolean isSelected(int index) {
        return index == this.getOptions().indexOf(this.getActiveOption());
    }

    public void selectNext() {
        int activeIndex = this.getOptions().indexOf(this.getActiveOption());
        int nextIndex = activeIndex + 1;
        if (nextIndex >= this.getOptions().size()) {
            nextIndex = 0;
        }
        this.select(nextIndex);
    }

    public void select(String label) {
        if (this.isSelected(label)) {
            return;
        }
        for (WebElement element : this.getOptions()) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            this.click(element);
            return;
        }
    }

    public void select(int index) {
        if (index > this.getOptions().size()) {
            throw new IndexOutOfBoundsException("Index " + index + ", Size " + this.getOptions().size());
        }
        if (this.isSelected(index)) {
            return;
        }
        this.click(this.getOptions().get(index));
    }

    public void selectFirst() {
        this.select(0);
    }

    public void selectLast() {
        this.select(this.getOptions().size() - 1);
    }

    public void deselect(String label) {
        this.deselect(label, false);
    }

    public void deselect(String label, boolean ignoreDeselectable) {
        if (!ignoreDeselectable && !this.isUnselectable()) {
            return;
        }
        if (!this.isSelected(label)) {
            return;
        }
        for (WebElement element : this.getOptions()) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            this.click(element);
            return;
        }
    }

    public void deselect(int index) {
        this.deselect(index, false);
    }

    public void deselect(int index, boolean ignoreDeselectable) {
        if (index > this.getOptions().size()) {
            throw new IndexOutOfBoundsException("Index " + index + ", Size " + this.getOptions().size());
        }
        if (!ignoreDeselectable && !this.isUnselectable()) {
            return;
        }
        if (!this.isSelected(index)) {
            return;
        }
        this.click(this.getOptions().get(index));
    }

    public boolean isUnselectable() {
        return "true".equals(PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".cfg.unselectable"), (Object[])new Object[0]));
    }

    protected void click(WebElement element) {
        if (this.isOnchangeAjaxified()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)element)).click();
        } else {
            element.click();
        }
    }
}

