/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.replacer;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.primefaces.extensions.optimizerplugin.replacer.TokenResolver;

public class TokenReplacingReader
extends Reader {
    private String tokenStartMarker;
    private String tokenEndMarker;
    private char[] tokenStartMarkerChars;
    private char[] tokenEndMarkerChars;
    private char[] tmpTokenStartMarkerChars;
    private char[] tmpTokenEndMarkerChars;
    private PushbackReader pushbackReader;
    private TokenResolver tokenResolver;
    private StringBuilder tokenBuffer = new StringBuilder();
    private String resolvedToken = null;
    private int resolvedTokenIndex = 0;

    public TokenReplacingReader(TokenResolver resolver, Reader source, String tokenStartMarker, String tokenEndMarker) {
        if (resolver == null) {
            throw new IllegalArgumentException("Token resolver is null");
        }
        if (tokenStartMarker == null || tokenStartMarker.length() < 1 || tokenEndMarker == null || tokenEndMarker.length() < 1) {
            throw new IllegalArgumentException("Token start / end marker is null or empty");
        }
        this.tokenStartMarker = tokenStartMarker;
        this.tokenEndMarker = tokenEndMarker;
        this.tokenStartMarkerChars = tokenStartMarker.toCharArray();
        this.tokenEndMarkerChars = tokenEndMarker.toCharArray();
        this.tmpTokenStartMarkerChars = new char[tokenStartMarker.length()];
        this.tmpTokenEndMarkerChars = new char[tokenEndMarker.length()];
        this.pushbackReader = new PushbackReader(source, Math.max(tokenStartMarker.length(), tokenEndMarker.length()));
        this.tokenResolver = resolver;
    }

    @Override
    public int read() throws IOException {
        if (this.resolvedToken != null) {
            if (this.resolvedTokenIndex < this.resolvedToken.length()) {
                return this.resolvedToken.charAt(this.resolvedTokenIndex++);
            }
            if (this.resolvedTokenIndex == this.resolvedToken.length()) {
                this.resolvedToken = null;
                this.resolvedTokenIndex = 0;
            }
        }
        int countValidChars = this.readChars(this.tmpTokenStartMarkerChars);
        if (!Arrays.equals(this.tmpTokenStartMarkerChars, this.tokenStartMarkerChars)) {
            if (countValidChars > 0) {
                this.pushbackReader.unread(this.tmpTokenStartMarkerChars, 0, countValidChars);
            }
            return this.pushbackReader.read();
        }
        boolean endOfSource = false;
        this.tokenBuffer.delete(0, this.tokenBuffer.length());
        countValidChars = this.readChars(this.tmpTokenEndMarkerChars);
        while (!Arrays.equals(this.tmpTokenEndMarkerChars, this.tokenEndMarkerChars)) {
            if (countValidChars == -1) {
                endOfSource = true;
                break;
            }
            this.tokenBuffer.append(this.tmpTokenEndMarkerChars[0]);
            this.pushbackReader.unread(this.tmpTokenEndMarkerChars, 0, countValidChars);
            if (this.pushbackReader.read() == -1) {
                endOfSource = true;
                break;
            }
            countValidChars = this.readChars(this.tmpTokenEndMarkerChars);
        }
        if (endOfSource) {
            this.resolvedToken = this.tokenStartMarker + this.tokenBuffer.toString();
        } else {
            this.resolvedToken = this.tokenResolver.resolveToken(this.tokenBuffer.toString());
            if (this.resolvedToken == null) {
                this.resolvedToken = this.tokenStartMarker + this.tokenBuffer.toString() + this.tokenEndMarker;
            }
        }
        return this.resolvedToken.charAt(this.resolvedTokenIndex++);
    }

    private int readChars(char[] tmpChars) throws IOException {
        int countValidChars = -1;
        int length = tmpChars.length;
        int data = this.pushbackReader.read();
        for (int i = 0; i < length; ++i) {
            if (data != -1) {
                tmpChars[i] = (char)data;
                countValidChars = i + 1;
                if (i + 1 >= length) continue;
                data = this.pushbackReader.read();
                continue;
            }
            tmpChars[i] = '\u0000';
        }
        return countValidChars;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead = 0;
        for (int i = 0; i < len; ++i) {
            int nextChar = this.read();
            if (nextChar == -1) {
                charsRead = i;
                if (charsRead != 0) break;
                charsRead = -1;
                break;
            }
            charsRead = i + 1;
            cbuf[off + i] = (char)nextChar;
        }
        return charsRead;
    }

    @Override
    public void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new UnsupportedOperationException("Method int read(CharBuffer target) is not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Method long skip(long n) is not supported");
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new UnsupportedOperationException("Method void mark(int readAheadLimit) is not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("Method void reset() is not supported");
    }
}

