/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.replacer;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.primefaces.extensions.optimizerplugin.replacer.TokenResolver;

public class DataUriTokenResolver
implements TokenResolver {
    private File[] imagesDir;
    private static Pattern pattern = Pattern.compile("[\\s'\":/\\\\]+");
    private static final int SIZE_LIMIT = 32768;
    private static final Map<String, String> supportedTypes = new HashMap<String, String>();

    public DataUriTokenResolver(File[] imagesDir) {
        this.imagesDir = imagesDir;
    }

    @Override
    public String resolveToken(String token) throws IOException {
        boolean exceedLimit;
        if (token == null || token.length() < 1) {
            return token;
        }
        String[] pathParts = pattern.split(token);
        if (pathParts == null || pathParts.length < 1) {
            return null;
        }
        String separator = System.getProperty("file.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(separator);
        for (int i = 0; i < pathParts.length; ++i) {
            if (!StringUtils.isNotBlank((String)pathParts[i])) continue;
            sb.append(pathParts[i]);
            if (i + 1 >= pathParts.length) continue;
            sb.append(separator);
        }
        String path = sb.toString();
        if (path.length() == 1) {
            return null;
        }
        if (path.endsWith(separator)) {
            path = path.substring(0, path.length() - 1);
        }
        boolean found = false;
        File imageFile = null;
        String extension = null;
        for (File imageDir : this.imagesDir) {
            String fullPath = imageDir.getCanonicalPath() + path;
            imageFile = new File(fullPath);
            if (!imageFile.exists() || (extension = FileUtils.extension((String)fullPath)) == null || !supportedTypes.containsKey(extension)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        byte[] bytes = Files.toByteArray(imageFile);
        StringBuilder dataUriBilder = new StringBuilder();
        dataUriBilder.append("data:");
        dataUriBilder.append(supportedTypes.get(extension));
        dataUriBilder.append(";base64,");
        dataUriBilder.append(new String(Base64.encodeBase64((byte[])bytes)));
        String dataUri = dataUriBilder.toString();
        boolean bl = exceedLimit = dataUri.length() >= 32768;
        if (exceedLimit) {
            return null;
        }
        return dataUri;
    }

    static {
        supportedTypes.put("gif", "image/gif");
        supportedTypes.put("jpg", "image/jpeg");
        supportedTypes.put("jpeg", "image/jpeg");
        supportedTypes.put("png", "image/png");
    }
}

