/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.speedtest;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.speedtest.Speedtest;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.WidgetBuilder;

public class SpeedtestRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Speedtest speedtest = (Speedtest)component;
        this.encodeMarkup(context, speedtest);
        this.encodeScript(context, speedtest);
    }

    private void encodeMarkup(FacesContext context, Speedtest speedtest) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = speedtest.getClientId(context);
        String widgetVar = speedtest.resolveWidgetVar();
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("id", (Object)(clientId + "SpeedTest"), "id");
        if (speedtest.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)speedtest.getStyleClass(), "styleClass");
        }
        if (speedtest.getStyle() != null) {
            writer.writeAttribute("style", (Object)speedtest.getStyle(), "style");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g", null);
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("style", (Object)"height:200px", null);
        writer.writeAttribute("id", (Object)(clientId + "ggdown"), "id");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("style", (Object)"height:200px", null);
        writer.writeAttribute("id", (Object)(clientId + "ggup"), "id");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("style", (Object)"height:200px", null);
        writer.writeAttribute("id", (Object)(clientId + "ggping"), "id");
        writer.endElement("div");
        writer.startElement("div", (UIComponent)speedtest);
        writer.writeAttribute("class", (Object)"ui-g-3", null);
        writer.writeAttribute("style", (Object)"height:200px", null);
        writer.writeAttribute("id", (Object)(clientId + "ggjitter"), "id");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Speedtest speedtest) throws IOException {
        String clientId = speedtest.getClientId(context);
        UIForm form = ComponentTraversalUtils.closestForm((UIComponent)speedtest);
        if (form == null) {
            throw new FacesException("Speedtest:" + clientId + " needs to be enclosed in a form component");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtSpeedtest", (UIComponent)speedtest);
        wb.attr("idDown", clientId + "ggdown");
        wb.attr("idUp", clientId + "ggup");
        wb.attr("idPing", clientId + "ggping");
        wb.attr("idJitter", clientId + "ggjitter");
        wb.attr("captionPing", speedtest.getCaptionPing());
        wb.attr("captionJitter", speedtest.getCaptionJitter());
        wb.attr("captionDownload", speedtest.getCaptionDownload());
        wb.attr("captionUpload", speedtest.getCaptionUpload());
        wb.attr("colorPing", speedtest.getColorPing());
        wb.attr("colorJitter", speedtest.getColorJitter());
        wb.attr("colorDownload", speedtest.getColorDownload());
        wb.attr("colorUpload", speedtest.getColorUpload());
        wb.attr("file", speedtest.getFile());
        this.encodeClientBehaviors(context, speedtest);
        wb.finish();
    }
}

