/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputotp;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.RTLAware;
import org.primefaces.extensions.component.inputotp.InputOtp;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class InputOtpRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputOtp inputOtp = (InputOtp)component;
        if (!this.shouldDecode((UIInput)inputOtp)) {
            return;
        }
        String inputId = inputOtp.getClientId(context) + "_hidden";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputOtp.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)inputOtp);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputOtp inputOtp = (InputOtp)component;
        if (inputOtp.getLength() < 1) {
            throw new FacesException("InputOtp length property should be > 0");
        }
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputOtp, (Object)inputOtp.getValue());
        if (valueToRender == null) {
            valueToRender = "";
        }
        this.encodeMarkup(context, inputOtp, valueToRender);
        this.encodeScript(context, inputOtp);
    }

    protected void encodeMarkup(FacesContext context, InputOtp inputOtp, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputOtp.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add("ui-inputotp ui-widget", inputOtp.getStyleClass()).add(ComponentUtils.isRTL((FacesContext)context, (RTLAware)inputOtp), "ui-inputotp-rtl").build();
        writer.startElement("span", (UIComponent)inputOtp);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputOtp.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputOtp.getStyle(), "style");
        }
        this.encodeInput(context, inputOtp, clientId, valueToRender);
        this.encodeHiddenInput(context, inputOtp, clientId, valueToRender);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, InputOtp inputOtp, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputStyle = inputOtp.getInputStyle();
        String inputStyleClass = this.createStyleClass((UIInput)inputOtp, InputOtp.PropertyKeys.inputStyleClass.name(), "ui-inputotp-input ui-inputfield ui-inputtext ui-widget ui-state-default");
        char[] chars = valueToRender.toCharArray();
        boolean hasSeparatorFacet = FacetUtils.shouldRenderFacet((UIComponent)inputOtp.getFacet("separator"));
        for (int i = 1; i <= inputOtp.getLength(); ++i) {
            if (i > 1 && (LangUtils.isNotBlank((String)inputOtp.getSeparator()) || hasSeparatorFacet)) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-inputotp-separator", null);
                if (hasSeparatorFacet) {
                    inputOtp.getFacet("separator").encodeAll(context);
                } else {
                    writer.writeText((Object)inputOtp.getSeparator(), InputOtp.PropertyKeys.separator.name());
                }
                writer.endElement("div");
            }
            String inputId = clientId + "_input" + i;
            String inputValue = chars.length >= i ? String.valueOf(chars[i - 1]) : "";
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)inputId, null);
            writer.writeAttribute("name", (Object)inputId, null);
            writer.writeAttribute("value", (Object)inputValue, null);
            writer.writeAttribute("size", (Object)1, null);
            writer.writeAttribute("maxlength", (Object)inputOtp.getLength(), null);
            writer.writeAttribute("class", (Object)inputStyleClass, null);
            if (LangUtils.isNotBlank((String)inputStyle)) {
                writer.writeAttribute("style", (Object)inputStyle, null);
            }
            if (inputOtp.isMask()) {
                writer.writeAttribute("type", (Object)"password", null);
            }
            if (inputOtp.isIntegerOnly() && LangUtils.isBlank((String)inputOtp.getInputmode())) {
                inputOtp.setInputmode("numeric");
            }
            if (LangUtils.isNotBlank((String)inputOtp.getPlaceholder())) {
                char placeholder = inputOtp.getPlaceholder().charAt((i - 1) % inputOtp.getPlaceholder().length());
                writer.writeAttribute("placeholder", (Object)Character.valueOf(placeholder), null);
            }
            this.renderAccessibilityAttributes(context, (UIInput)inputOtp);
            this.renderRTLDirection(context, (UIComponent)inputOtp);
            this.renderPassThruAttributes(context, (UIComponent)inputOtp, InputOtp.INPUT_OTP_ATTRIBUTES_WITHOUT_EVENTS);
            this.renderDomEvents(context, (UIComponent)inputOtp, HTML.INPUT_TEXT_EVENTS);
            this.renderValidationMetadata(context, (EditableValueHolder)inputOtp, new ClientValidator[0]);
            writer.endElement("input");
        }
    }

    protected void encodeHiddenInput(FacesContext context, InputOtp inputOtp, String clientId, String valueToRender) throws IOException {
        this.renderHiddenInput(context, clientId + "_hidden", valueToRender, inputOtp.isDisabled());
    }

    protected void encodeScript(FacesContext context, InputOtp inputOtp) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtInputOtp", (UIComponent)inputOtp);
        wb.attr("integerOnly", inputOtp.isIntegerOnly(), false);
        if (LangUtils.isNotBlank((String)inputOtp.getAriaLabel())) {
            wb.attr("ariaLabel", inputOtp.getAriaLabel());
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputOtp);
        wb.finish();
    }
}

