
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Controls the behavior of the unicode highlight feature (by default, ambiguous and invisible characters are
 * highlighted).
 */
@SuppressWarnings("serial")
public class EditorUnicodeHighlightOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorUnicodeHighlightOptions(this);
    }

    private static class SerializedEditorUnicodeHighlightOptions implements Serializable {
        private String json;

        public SerializedEditorUnicodeHighlightOptions(EditorUnicodeHighlightOptions editorUnicodeHighlightOptions) {
            this.json = editorUnicodeHighlightOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorUnicodeHighlightOptions editorUnicodeHighlightOptions = new EditorUnicodeHighlightOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorUnicodeHighlightOptions.put(key, value);
            }
            return editorUnicodeHighlightOptions;
        }
    }

    /**
     * @return A map of allowed characters ({@code true}: allowed).
     */
    public JSONObject getAllowedCharacters() {
        return (JSONObject) (has("allowedCharacters") ? get("allowedCharacters") : null);
    }

    /**
     * @param allowedCharacters A map of allowed characters ({@code true}: allowed).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAllowedCharacters(final JSONObject allowedCharacters) {
        put("allowedCharacters", allowedCharacters);
        return this;
    }

    /**
     * A map of allowed characters ({@code true}: allowed).
     * @param key The key of the map entry to add.
     * @param value The value to associate with the key.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions addAllowedCharacter(final String key, final Boolean value) {
        JSONObject x = getAllowedCharacters();
        if (x == null) {
            x = new JSONObject();
            setAllowedCharacters(x);
        }
        x.put(key, value);
        return this;
    }

    /**
     * @param allowedCharacters A map of allowed characters ({@code true}: allowed).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAllowedCharacters(final java.util.Map<String, Boolean> allowedCharacters) {
        return setAllowedCharacters(new JSONObject(allowedCharacters));
    }

    /**
     * @return Unicode characters that are common in allowed locales are not being highlighted. ({@code true}: allowed).
     */
    public JSONObject getAllowedLocales() {
        return (JSONObject) (has("allowedLocales") ? get("allowedLocales") : null);
    }

    /**
     * @param allowedLocales Unicode characters that are common in allowed locales are not being highlighted. ({@code
     * true}: allowed).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAllowedLocales(final JSONObject allowedLocales) {
        put("allowedLocales", allowedLocales);
        return this;
    }

    /**
     * Unicode characters that are common in allowed locales are not being highlighted. ({@code true}: allowed).
     * @param key The key of the map entry to add.
     * @param value The value to associate with the key.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions addAllowedLocale(final String key, final Boolean value) {
        JSONObject x = getAllowedLocales();
        if (x == null) {
            x = new JSONObject();
            setAllowedLocales(x);
        }
        x.put(key, value);
        return this;
    }

    /**
     * @param allowedLocales Unicode characters that are common in allowed locales are not being highlighted. ({@code
     * true}: allowed).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAllowedLocales(final java.util.Map<String, Boolean> allowedLocales) {
        return setAllowedLocales(new JSONObject(allowedLocales));
    }

    /**
     * @return Controls whether characters are highlighted that can be confused with basic ASCII characters, except
     * those that are common in the current user locale.
     */
    public Boolean isAmbiguousCharacters() {
        return (Boolean) (has("ambiguousCharacters") ? get("ambiguousCharacters") : null);
    }

    /**
     * @param ambiguousCharacters Controls whether characters are highlighted that can be confused with basic ASCII
     * characters, except those that are common in the current user locale.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setAmbiguousCharacters(final Boolean ambiguousCharacters) {
        put("ambiguousCharacters", ambiguousCharacters);
        return this;
    }

    public Boolean isIncludeComments() {
        final Object tmp = (has("includeComments") ? get("includeComments") : null);
        return (Boolean) (tmp instanceof Boolean ? tmp : null);
    }

    public String getIncludeComments() {
        final Object tmp = (has("includeComments") ? get("includeComments") : null);
        return (String) (tmp instanceof String ? tmp : null);
    }

    public EditorUnicodeHighlightOptions setIncludeComments(final Boolean includeComments) {
        put("includeComments", includeComments);
        return this;
    }

    public EditorUnicodeHighlightOptions setIncludeComments(final String includeComments) {
        put("includeComments", includeComments);
        return this;
    }

    public Boolean isIncludeStrings() {
        final Object tmp = (has("includeStrings") ? get("includeStrings") : null);
        return (Boolean) (tmp instanceof Boolean ? tmp : null);
    }

    public String getIncludeStrings() {
        final Object tmp = (has("includeStrings") ? get("includeStrings") : null);
        return (String) (tmp instanceof String ? tmp : null);
    }

    public EditorUnicodeHighlightOptions setIncludeStrings(final Boolean includeStrings) {
        put("includeStrings", includeStrings);
        return this;
    }

    public EditorUnicodeHighlightOptions setIncludeStrings(final String includeStrings) {
        put("includeStrings", includeStrings);
        return this;
    }

    /**
     * @return Controls whether characters that just reserve space or have no width at all are highlighted.
     */
    public Boolean isInvisibleCharacters() {
        return (Boolean) (has("invisibleCharacters") ? get("invisibleCharacters") : null);
    }

    /**
     * @param invisibleCharacters Controls whether characters that just reserve space or have no width at all are
     * highlighted.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorUnicodeHighlightOptions setInvisibleCharacters(final Boolean invisibleCharacters) {
        put("invisibleCharacters", invisibleCharacters);
        return this;
    }

    public Boolean isNonBasicASCII() {
        final Object tmp = (has("nonBasicASCII") ? get("nonBasicASCII") : null);
        return (Boolean) (tmp instanceof Boolean ? tmp : null);
    }

    public String getNonBasicASCII() {
        final Object tmp = (has("nonBasicASCII") ? get("nonBasicASCII") : null);
        return (String) (tmp instanceof String ? tmp : null);
    }

    public EditorUnicodeHighlightOptions setNonBasicASCII(final Boolean nonBasicASCII) {
        put("nonBasicASCII", nonBasicASCII);
        return this;
    }

    public EditorUnicodeHighlightOptions setNonBasicASCII(final String nonBasicASCII) {
        put("nonBasicASCII", nonBasicASCII);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}