/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.inputplace;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class Place
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String placeId;
    private String formattedAddress;
    private String name;
    private String addressLine;
    private String postalCode;
    private String city;
    private String state;
    private String country;
    private String countryCode;
    private String administrativeAreaLevel1;
    private String administrativeAreaLevel2;
    private String administrativeAreaLevel3;
    private String types;
    private String url;
    private String phone;
    private double latitude;
    private double longitude;

    public Place() {
    }

    public Place(String clientId, Map<String, String> params) {
        this.placeId = params.get(clientId + "_place_id");
        this.name = params.get(clientId + "_name");
        this.formattedAddress = params.get(clientId + "_formatted_address");
        this.addressLine = params.get(clientId + "_address");
        this.postalCode = params.get(clientId + "_postcode");
        this.city = params.get(clientId + "_city");
        this.state = params.get(clientId + "_state");
        this.country = params.get(clientId + "_country");
        this.countryCode = params.get(clientId + "_country_code");
        this.latitude = Double.parseDouble(params.get(clientId + "_lat"));
        this.longitude = Double.parseDouble(params.get(clientId + "_lng"));
        this.administrativeAreaLevel1 = params.get(clientId + "_administrative_area_level_1");
        this.administrativeAreaLevel2 = params.get(clientId + "_administrative_area_level_2");
        this.administrativeAreaLevel3 = params.get(clientId + "_administrative_area_level_3");
        this.types = params.get(clientId + "_types");
        this.url = params.get(clientId + "_url");
        this.phone = params.get(clientId + "_phone");
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getFormattedAddress() {
        return this.formattedAddress;
    }

    public void setFormattedAddress(String formattedAddress) {
        this.formattedAddress = formattedAddress;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(String addressLine) {
        this.addressLine = addressLine;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getAdministrativeAreaLevel1() {
        return this.administrativeAreaLevel1;
    }

    public void setAdministrativeAreaLevel1(String administrativeAreaLevel1) {
        this.administrativeAreaLevel1 = administrativeAreaLevel1;
    }

    public String getAdministrativeAreaLevel2() {
        return this.administrativeAreaLevel2;
    }

    public void setAdministrativeAreaLevel2(String administrativeAreaLevel2) {
        this.administrativeAreaLevel2 = administrativeAreaLevel2;
    }

    public String getAdministrativeAreaLevel3() {
        return this.administrativeAreaLevel3;
    }

    public void setAdministrativeAreaLevel3(String administrativeAreaLevel3) {
        this.administrativeAreaLevel3 = administrativeAreaLevel3;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Place place = (Place)o;
        return Objects.equals(this.getPlaceId(), place.getPlaceId()) && Objects.equals(this.getFormattedAddress(), place.getFormattedAddress());
    }

    public int hashCode() {
        return Objects.hash(this.getPlaceId(), this.getFormattedAddress());
    }

    public String toString() {
        return new StringJoiner(", ", Place.class.getSimpleName() + "[", "]").add("placeId='" + this.placeId + "'").add("formattedAddress='" + this.formattedAddress + "'").add("name='" + this.name + "'").add("addressLine='" + this.addressLine + "'").add("postalCode='" + this.postalCode + "'").add("city='" + this.city + "'").add("state='" + this.state + "'").add("country='" + this.country + "'").add("countryCode='" + this.countryCode + "'").add("administrativeAreaLevel1='" + this.administrativeAreaLevel1 + "'").add("administrativeAreaLevel2='" + this.administrativeAreaLevel2 + "'").add("administrativeAreaLevel3='" + this.administrativeAreaLevel3 + "'").add("types='" + this.types + "'").add("url='" + this.url + "'").add("phone='" + this.phone + "'").add("latitude=" + this.latitude).add("longitude=" + this.longitude).toString();
    }
}

