/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timer;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.component.timer.Timer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TimerRenderer
extends CoreRenderer {
    public static final String RENDERER_TYPE = "org.primefaces.extensions.component.TimerRenderer";

    public void decode(FacesContext context, UIComponent component) {
        Timer timer = (Timer)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(timer.getClientId(context))) {
            ActionEvent event = new ActionEvent((UIComponent)timer);
            if (timer.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            timer.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Timer timer = (Timer)component;
        this.encodeMarkup(context, timer);
        this.encodeScript(context, timer);
    }

    protected void encodeMarkup(FacesContext context, Timer timer) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)timer);
        writer.writeAttribute("id", (Object)timer.getClientId(), null);
        writer.writeAttribute("title", (Object)timer.getTitle(), null);
        writer.writeAttribute("class", (Object)("ui-timer ui-widget ui-widget-header ui-corner-all " + timer.getStyleClass()), "styleclass");
        writer.writeAttribute("style", (Object)((!timer.isVisible() ? "display:none;" : "") + timer.getStyle()), "style");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, Timer timer) throws IOException {
        String clientId = timer.getClientId(context);
        UIForm form = ComponentTraversalUtils.closestForm((UIComponent)timer);
        if (form == null) {
            throw new FacesException("Timer:" + clientId + " needs to be enclosed in a form component");
        }
        AjaxRequestBuilder builder = PrimeRequestContext.getCurrentInstance().getAjaxRequestBuilder();
        String request = null;
        if (timer.getListener() != null) {
            request = builder.init().source(clientId).form((AjaxSource)timer, (UIComponent)timer, form).process((UIComponent)timer, timer.getProcess()).update((UIComponent)timer, timer.getUpdate()).async(timer.isAsync()).global(timer.isGlobal()).delay(timer.getDelay()).partialSubmit(timer.isPartialSubmit(), timer.isPartialSubmitSet(), timer.getPartialSubmitFilter()).resetValues(timer.isResetValues(), timer.isResetValuesSet()).ignoreAutoUpdate(timer.isIgnoreAutoUpdate()).onstart(timer.getOnstart()).onerror(timer.getOnerror()).onsuccess(timer.getOnsuccess()).oncomplete(timer.getOncomplete()).params((UIComponent)timer).build();
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtTimer", (UIComponent)timer).attr("timeout", (Number)timer.getTimeout()).attr("interval", (Number)timer.getInterval()).attr("singleRun", Boolean.valueOf(timer.isSingleRun())).attr("format", timer.getFormat()).attr("autoStart", Boolean.valueOf(timer.isAutoStart())).attr("forward", Boolean.valueOf(timer.isForward())).attr("locale", timer.calculateLocale().toString());
        if (request != null) {
            wb.callback("listener", "function()", request);
        }
        if (LangUtils.isNotBlank((String)timer.getOntimerstep())) {
            wb.callback("ontimerstep", "function(intervalData)", timer.getOntimerstep());
        }
        if (LangUtils.isNotBlank((String)timer.getFormatFunction())) {
            wb.callback("formatFunction", "function(value)", timer.getFormatFunction());
        }
        if (LangUtils.isNotBlank((String)timer.getOntimercomplete())) {
            wb.callback("ontimercomplete", "function()", timer.getOntimercomplete());
        }
        wb.finish();
    }
}

