/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.parameters;

import javax.el.ValueExpression;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.primefaces.extensions.component.parameters.AssignableParameter;

public class AssignableParameterHandler
extends ComponentHandler {
    private static final AssignToMetaRule META_RULE = new AssignToMetaRule();

    public AssignableParameterHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset metaRuleset = super.createMetaRuleset(type);
        metaRuleset.addRule((MetaRule)META_RULE);
        return metaRuleset;
    }

    private static final class AssignToMetaRule
    extends MetaRule {
        private AssignToMetaRule() {
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AssignableParameter.class) && AssignableParameter.PropertyKeys.assignTo.toString().equals(name)) {
                return new AssignToValueExpressionMetadata(attribute);
            }
            return null;
        }
    }

    private static final class AssignToValueExpressionMetadata
    extends Metadata {
        private final TagAttribute attribute;

        public AssignToValueExpressionMetadata(TagAttribute attribute) {
            this.attribute = attribute;
        }

        public void applyMetadata(FaceletContext context, Object instance) {
            AssignableParameter param = (AssignableParameter)((Object)instance);
            ValueExpression valueExpression = this.attribute.getValueExpression(context, Object.class);
            param.setAssignTo(valueExpression);
        }
    }
}

