/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.layout;

import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PreRenderComponentEvent;
import org.primefaces.component.outputpanel.OutputPanel;
import org.primefaces.extensions.component.layout.Layout;
import org.primefaces.extensions.model.layout.LayoutOptions;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public class LayoutPane
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.LayoutPane";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.LayoutPaneRenderer";
    private LayoutOptions options;

    public LayoutPane() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getStyleHeader() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleHeader), null);
    }

    public void setStyleHeader(String styleHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleHeader), (Object)styleHeader);
    }

    public String getStyleClassHeader() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClassHeader), null);
    }

    public void setStyleClassHeader(String styleClassHeader) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClassHeader), (Object)styleClassHeader);
    }

    public String getStyleContent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleContent), null);
    }

    public void setStyleContent(String styleContent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleContent), (Object)styleContent);
    }

    public String getStyleClassContent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClassContent), null);
    }

    public void setStyleClassContent(String styleClassContent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClassContent), (Object)styleClassContent);
    }

    public String getPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.position), (Object)"center");
    }

    public void setPosition(String position) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.position), (Object)position);
    }

    public String getPaneSelector() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paneSelector), null);
    }

    public void setPaneSelector(String paneSelector) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paneSelector), (Object)paneSelector);
    }

    public String getCombinedPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.combinedPosition), (Object)"center");
    }

    public void setCombinedPosition(String combinedPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.combinedPosition), (Object)combinedPosition);
    }

    public String getTogglerTipOpen() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.togglerTip_open), null);
    }

    public void setTogglerTipOpen(String togglerTipOpen) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.togglerTip_open), (Object)togglerTipOpen);
    }

    public String getTogglerTipClosed() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.togglerTip_closed), null);
    }

    public void setTogglerTipClosed(String togglerTipClosed) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.togglerTip_closed), (Object)togglerTipClosed);
    }

    public String getResizerTip() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizerTip), null);
    }

    public void setResizerTip(String resizerTip) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizerTip), (Object)resizerTip);
    }

    public String getSliderTip() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sliderTip), null);
    }

    public void setSliderTip(String sliderTip) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sliderTip), (Object)sliderTip);
    }

    public boolean isResizable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizable), (Object)true);
    }

    public void setResizable(boolean resizable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizable), (Object)resizable);
    }

    public boolean isSlidable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.slideable), (Object)true);
    }

    public void setSlidable(boolean slideable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.slideable), (Object)slideable);
    }

    public boolean isClosable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.closable), (Object)true);
    }

    public void setClosable(boolean closable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.closable), (Object)closable);
    }

    public String getSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.size), null);
    }

    public void setSize(String size) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.size), (Object)size);
    }

    public String getMinSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minSize), null);
    }

    public void setMinSize(String minSize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minSize), (Object)minSize);
    }

    public String getMaxSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxSize), null);
    }

    public void setMaxSize(String maxSize) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxSize), (Object)maxSize);
    }

    public String getMinWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minWidth), null);
    }

    public void setMinWidth(String minWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minWidth), (Object)minWidth);
    }

    public String getMaxWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxWidth), null);
    }

    public void setMaxWidth(String maxWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxWidth), (Object)maxWidth);
    }

    public String getMinHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHeight), null);
    }

    public void setMinHeight(String minHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minHeight), (Object)minHeight);
    }

    public String getMaxHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxHeight), null);
    }

    public void setMaxHeight(String maxHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxHeight), (Object)maxHeight);
    }

    public int getSpacingOpen() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.spacing_open), (Object)6);
    }

    public void setSpacingOpen(int spacingOpen) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.spacing_open), (Object)spacingOpen);
    }

    public int getSpacingClosed() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.spacing_closed), (Object)6);
    }

    public void setSpacingClosed(int spacingClosed) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.spacing_closed), (Object)spacingClosed);
    }

    public boolean isInitClosed() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.initClosed), (Object)false);
    }

    public void setInitClosed(boolean initClosed) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.initClosed), (Object)initClosed);
    }

    public boolean isInitHidden() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.initHidden), (Object)false);
    }

    public void setInitHidden(boolean initHidden) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.initHidden), (Object)initHidden);
    }

    public boolean isResizeWhileDragging() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizeWhileDragging), (Object)false);
    }

    public void setResizeWhileDragging(boolean resizeWhileDragging) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizeWhileDragging), (Object)resizeWhileDragging);
    }

    public boolean isMaskContents() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maskContents), (Object)false);
    }

    public void setMaskContents(boolean maskContents) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maskContents), (Object)maskContents);
    }

    public boolean isMaskObjects() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maskObjects), (Object)false);
    }

    public void setMaskObjects(boolean maskObjects) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maskObjects), (Object)maskObjects);
    }

    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        if (!(event instanceof PreRenderComponentEvent) || !this.getLayout().isBuildOptions()) {
            return;
        }
        this.setOptions(this.getParent());
    }

    public LayoutOptions getOptions() {
        String togglerTipClosed;
        String togglerTipOpen;
        String sliderTip;
        String maxHeight;
        String minHeight;
        String maxWidth;
        String minWidth;
        String maxSize;
        String minSize;
        String size;
        String paneSelector;
        boolean isMaskObjects;
        boolean isMaskContents;
        boolean isResizeWhileDragging;
        boolean initHidden;
        boolean isClosable;
        boolean isSlidable;
        if (this.options != null) {
            return this.options;
        }
        this.options = new LayoutOptions();
        boolean isResizable = this.isResizable();
        if (!isResizable) {
            this.options.addOption(PropertyKeys.resizable.toString(), false);
        }
        if (!(isSlidable = this.isSlidable())) {
            this.options.addOption(PropertyKeys.slideable.toString(), false);
        }
        if (!(isClosable = this.isClosable())) {
            this.options.addOption(PropertyKeys.closable.toString(), false);
        }
        this.options.addOption(PropertyKeys.spacing_open.toString(), this.getSpacingOpen());
        this.options.addOption(PropertyKeys.spacing_closed.toString(), this.getSpacingClosed());
        boolean initClosed = this.isInitClosed();
        if (initClosed) {
            this.options.addOption(PropertyKeys.initClosed.toString(), true);
        }
        if (initHidden = this.isInitHidden()) {
            this.options.addOption(PropertyKeys.initHidden.toString(), true);
        }
        if (isResizeWhileDragging = this.isResizeWhileDragging()) {
            this.options.addOption(PropertyKeys.resizeWhileDragging.toString(), true);
        }
        if (isMaskContents = this.isMaskContents()) {
            this.options.addOption(PropertyKeys.maskContents.toString(), true);
            this.options.addOption("contentIgnoreSelector", ".ui-layout-mask");
        }
        if (isMaskObjects = this.isMaskObjects()) {
            this.options.addOption(PropertyKeys.maskObjects.toString(), true);
            if (!isMaskContents) {
                this.options.addOption("contentIgnoreSelector", ".ui-layout-mask");
            }
        }
        if ((paneSelector = this.getPaneSelector()) != null) {
            this.options.addOption(PropertyKeys.paneSelector.toString(), paneSelector);
        }
        if ((size = this.getSize()) != null) {
            this.options.addOption(PropertyKeys.size.toString(), size);
        }
        if ((minSize = this.getMinSize()) != null) {
            this.options.addOption(PropertyKeys.minSize.toString(), minSize);
        }
        if ((maxSize = this.getMaxSize()) != null) {
            this.options.addOption(PropertyKeys.maxSize.toString(), maxSize);
        }
        if ((minWidth = this.getMinWidth()) != null) {
            this.options.addOption(PropertyKeys.minWidth.toString(), minWidth);
        }
        if ((maxWidth = this.getMaxWidth()) != null) {
            this.options.addOption(PropertyKeys.maxWidth.toString(), maxWidth);
        }
        if ((minHeight = this.getMinHeight()) != null) {
            this.options.addOption(PropertyKeys.minHeight.toString(), minHeight);
        }
        if ((maxHeight = this.getMaxHeight()) != null) {
            this.options.addOption(PropertyKeys.maxHeight.toString(), maxHeight);
        }
        LayoutOptions tips = new LayoutOptions();
        this.options.setTips(tips);
        String resizerTip = this.getResizerTip();
        if (resizerTip != null) {
            tips.addOption(PropertyKeys.resizerTip.toString(), resizerTip);
        }
        if ((sliderTip = this.getSliderTip()) != null) {
            tips.addOption(PropertyKeys.sliderTip.toString(), sliderTip);
        }
        if ((togglerTipOpen = this.getTogglerTipOpen()) != null) {
            tips.addOption(PropertyKeys.togglerTip_open.toString(), togglerTipOpen);
        }
        if ((togglerTipClosed = this.getTogglerTipClosed()) != null) {
            tips.addOption(PropertyKeys.togglerTip_closed.toString(), togglerTipClosed);
        }
        return this.options;
    }

    private void setOptions(UIComponent parent) {
        LayoutOptions parentOpts;
        String position = this.getPosition();
        LayoutOptions thisLayoutOptions = this.getOptions();
        if (parent instanceof LayoutPane) {
            LayoutOptions parentLayoutOptions = ((LayoutPane)parent).getOptions();
            parentOpts = parentLayoutOptions.getChildOptions();
            if (parentOpts == null) {
                parentOpts = new LayoutOptions();
                parentLayoutOptions.setChildOptions(parentOpts);
            }
        } else if (parent instanceof Layout) {
            parentOpts = (LayoutOptions)((Layout)parent).getOptions();
            if (parentOpts == null) {
                boolean maskPanesEarly;
                String togglerTipClosed;
                String togglerTipOpen;
                String sliderTip;
                Layout layout = (Layout)parent;
                parentOpts = new LayoutOptions();
                layout.setOptions(parentOpts);
                LayoutOptions defaults = new LayoutOptions();
                parentOpts.setPanesOptions(defaults);
                LayoutOptions tips = new LayoutOptions();
                defaults.setTips(tips);
                String resizerTip = layout.getResizerTip();
                if (resizerTip != null) {
                    tips.addOption(Layout.PropertyKeys.resizerTip.toString(), resizerTip);
                }
                if ((sliderTip = layout.getSliderTip()) != null) {
                    tips.addOption(Layout.PropertyKeys.sliderTip.toString(), sliderTip);
                }
                if ((togglerTipOpen = layout.getTogglerTipOpen()) != null) {
                    tips.addOption(Layout.PropertyKeys.togglerTip_open.toString(), togglerTipOpen);
                }
                if ((togglerTipClosed = layout.getTogglerTipClosed()) != null) {
                    tips.addOption(Layout.PropertyKeys.togglerTip_closed.toString(), togglerTipClosed);
                }
                if (maskPanesEarly = layout.isMaskPanesEarly()) {
                    parentOpts.addOption(Layout.PropertyKeys.maskPanesEarly.toString(), true);
                }
            }
        } else {
            if (parent instanceof UIForm || parent instanceof HtmlPanelGroup && "ui-layout-content ui-panel-content".equals(((HtmlPanelGroup)parent).getStyleClass()) && "block".equals(((HtmlPanelGroup)parent).getLayout()) || parent instanceof OutputPanel && "ui-layout-content ui-panel-content".equals(((OutputPanel)parent).getStyleClass()) || parent != null && parent.toString().contains("ui-layout-content ui-panel-content")) {
                this.setOptions(parent.getParent());
                return;
            }
            throw new FacesException("LayoutPane can be only placed within another LayoutPane, Layout, UIForm or DIV with class 'ui-layout-content'");
        }
        if ("center".equals(position)) {
            parentOpts.setCenterOptions(thisLayoutOptions);
        } else if ("north".equals(position)) {
            parentOpts.setNorthOptions(thisLayoutOptions);
        } else if ("south".equals(position)) {
            parentOpts.setSouthOptions(thisLayoutOptions);
        } else if ("west".equals(position)) {
            parentOpts.setWestOptions(thisLayoutOptions);
        } else if ("east".equals(position)) {
            parentOpts.setEastOptions(thisLayoutOptions);
        } else {
            throw new FacesException("Pane position " + position + " is invalid. Valid positions are 'center', 'north' 'south', 'west', 'east'");
        }
    }

    private Layout getLayout() {
        UIComponent parent = this.getParent();
        while (!(parent instanceof Layout)) {
            parent = parent.getParent();
        }
        return (Layout)parent;
    }

    public Object saveState(FacesContext context) {
        this.options = null;
        return super.saveState(context);
    }

    protected static enum PropertyKeys {
        position,
        paneSelector,
        combinedPosition,
        styleHeader,
        styleClassHeader,
        styleContent,
        styleClassContent,
        resizable,
        slideable,
        closable,
        size,
        minSize,
        maxSize,
        minWidth,
        maxWidth,
        minHeight,
        maxHeight,
        spacing_open,
        spacing_closed,
        initClosed,
        initHidden,
        resizeWhileDragging,
        togglerTip_open("Open"),
        togglerTip_closed("Close"),
        resizerTip("Resize"),
        sliderTip("Slide"),
        maskContents,
        maskObjects;

        private final String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
            this.toString = null;
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

