/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.counter;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.counter.Counter;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class CounterRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Counter counter = (Counter)component;
        this.encodeMarkup(context, counter);
        this.encodeScript(context, counter);
    }

    private void encodeScript(FacesContext context, Counter counter) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        Locale locale = counter.calculateLocale();
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(locale);
        String groupingSeparator = counter.getSeparator();
        String decimalSeparator = counter.getDecimal();
        if (LangUtils.isBlank((String)groupingSeparator)) {
            groupingSeparator = String.valueOf(formatter.getDecimalFormatSymbols().getGroupingSeparator());
        }
        if (LangUtils.isBlank((String)decimalSeparator)) {
            decimalSeparator = String.valueOf(formatter.getDecimalFormatSymbols().getDecimalSeparator());
        }
        wb.init("ExtCounter", (UIComponent)counter).attr("start", (Number)counter.getStart()).attr("end", (Number)counter.getEnd()).attr("decimals", (Number)counter.getDecimals()).attr("duration", (Number)counter.getDuration()).attr("useGrouping", counter.isUseGrouping()).attr("useEasing", counter.isUseEasing()).attr("smartEasingThreshold", (Number)counter.getSmartEasingThreshold()).attr("smartEasingAmount", (Number)counter.getSmartEasingAmount()).attr("separator", groupingSeparator).attr("decimal", decimalSeparator).attr("prefix", counter.getPrefix()).attr("suffix", counter.getSuffix()).attr("autoStart", counter.isAutoStart());
        if (!LangUtils.isBlank((String)counter.getOnstart())) {
            wb.callback("onstart", "function()", counter.getOnstart());
        }
        if (!LangUtils.isBlank((String)counter.getOnend())) {
            wb.callback("onend", "function()", counter.getOnend());
        }
        this.encodeClientBehaviors(context, counter);
        wb.finish();
    }

    private void encodeMarkup(FacesContext context, Counter counter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-counter").add(counter.getStyleClass()).build();
        writer.startElement("span", (UIComponent)counter);
        writer.writeAttribute("id", (Object)counter.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("style", (Object)((!counter.isVisible() ? "display:none;" : "") + counter.getStyle()), "style");
        writer.endElement("span");
    }
}

