
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Control the behavior and rendering of the inline completions.
 */
@SuppressWarnings("serial")
public class EditorInlineSuggestOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorInlineSuggestOptions(this);
    }

    private static class SerializedEditorInlineSuggestOptions implements Serializable {
        private String json;

        public SerializedEditorInlineSuggestOptions(EditorInlineSuggestOptions editorInlineSuggestOptions) {
            this.json = editorInlineSuggestOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorInlineSuggestOptions editorInlineSuggestOptions = new EditorInlineSuggestOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorInlineSuggestOptions.put(key, value);
            }
            return editorInlineSuggestOptions;
        }
    }

    /**
     * @return Enable or disable the rendering of automatic inline completions.
     */
    public Boolean isEnabled() {
        return (Boolean) (has("enabled") ? get("enabled") : null);
    }

    /**
     * @param enabled Enable or disable the rendering of automatic inline completions.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineSuggestOptions setEnabled(final Boolean enabled) {
        put("enabled", enabled);
        return this;
    }

    /**
     * @return Does not clear active inline suggestions when the editor loses focus.
     */
    public Boolean isKeepOnBlur() {
        return (Boolean) (has("keepOnBlur") ? get("keepOnBlur") : null);
    }

    /**
     * @param keepOnBlur Does not clear active inline suggestions when the editor loses focus.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineSuggestOptions setKeepOnBlur(final Boolean keepOnBlur) {
        put("keepOnBlur", keepOnBlur);
        return this;
    }

    /**
     * @return Configures the mode. Use prefix to only show ghost text if the text to replace is a prefix of the
     * suggestion text. Use {@link subword} to only show ghost text if the replace text is a sub word of the suggestion
     * text. Use {@link subwordSmart} to only show ghost text if the replace text is a sub word of the suggestion text,
     * but the sub word must start after the cursor position. Defaults to {@code prefix}.
     */
    public String getMode() {
        return (String) (has("mode") ? get("mode") : null);
    }

    /**
     * @param mode Configures the mode. Use prefix to only show ghost text if the text to replace is a prefix of the
     * suggestion text. Use {@link subword} to only show ghost text if the replace text is a sub word of the suggestion
     * text. Use {@link subwordSmart} to only show ghost text if the replace text is a sub word of the suggestion text,
     * but the sub word must start after the cursor position. Defaults to {@code prefix}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineSuggestOptions setMode(final EInlineSuggestMode mode) {
        put("mode", mode != null ? mode.toString() : null);
        return this;
    }

    /**
     * @param mode Configures the mode. Use prefix to only show ghost text if the text to replace is a prefix of the
     * suggestion text. Use {@link subword} to only show ghost text if the replace text is a sub word of the suggestion
     * text. Use {@link subwordSmart} to only show ghost text if the replace text is a sub word of the suggestion text,
     * but the sub word must start after the cursor position. Defaults to {@code prefix}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineSuggestOptions setMode(final String mode) {
        put("mode", mode);
        return this;
    }

    /**
     * @return Configures whether to show the inline suggest toolbar.
     */
    public String getShowToolbar() {
        return (String) (has("showToolbar") ? get("showToolbar") : null);
    }

    /**
     * @param showToolbar Configures whether to show the inline suggest toolbar.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineSuggestOptions setShowToolbar(final EShowToolbarMode showToolbar) {
        put("showToolbar", showToolbar != null ? showToolbar.toString() : null);
        return this;
    }

    /**
     * @param showToolbar Configures whether to show the inline suggest toolbar.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineSuggestOptions setShowToolbar(final String showToolbar) {
        put("showToolbar", showToolbar);
        return this;
    }

    public Boolean isSuppressSuggestions() {
        return (Boolean) (has("suppressSuggestions") ? get("suppressSuggestions") : null);
    }

    public EditorInlineSuggestOptions setSuppressSuggestions(final Boolean suppressSuggestions) {
        put("suppressSuggestions", suppressSuggestions);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}