/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

public class MimeTypes {
    public static final String MIME_SVG = "image/svg+xml";
    public static final String MIME_EPS = "image/x-eps";
    public static final String MIME_TIFF = "image/tiff";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_PNG = "image/x-png";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_BMP = "image/bmp";
    private static final String[][] FORMAT_MAPPINGS = new String[][]{{"svg", "image/svg+xml"}, {"eps", "image/x-eps"}, {"image/eps", "image/x-eps"}, {"tif", "image/tiff"}, {"tiff", "image/tiff"}, {"jpg", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"png", "image/x-png"}, {"image/png", "image/x-png"}, {"gif", "image/gif"}, {"image/x-bmp", "image/bmp"}, {"bmp", "image/bmp"}};

    protected MimeTypes() {
        throw new UnsupportedOperationException();
    }

    public static String expandFormat(String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        for (String[] formatMapping : FORMAT_MAPPINGS) {
            if (!format.equalsIgnoreCase(formatMapping[0]) && !format.equals(formatMapping[1])) continue;
            return formatMapping[1];
        }
        return format.toLowerCase();
    }

    public static boolean isBitmapFormat(String format) {
        String fmt = MimeTypes.expandFormat(format);
        if (fmt == null) {
            return false;
        }
        return fmt.equals(MIME_JPEG) || fmt.equals(MIME_TIFF) || fmt.equals(MIME_PNG) || fmt.equals(MIME_GIF) || fmt.equals(MIME_BMP);
    }
}

