/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.upcean;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class UPCALogicImpl
extends UPCEANLogicImpl {
    public UPCALogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public static void validateMessage(String msg) {
        UPCEANLogicImpl.validateMessage(msg);
        if (msg.length() < 11 || msg.length() > 12) {
            throw new IllegalArgumentException("Message must be 11 or 12 characters long. Message: " + msg);
        }
    }

    public static String handleChecksum(String msg, ChecksumMode mode) {
        if (mode == ChecksumMode.CP_AUTO) {
            if (msg.length() == 11) {
                mode = ChecksumMode.CP_ADD;
            } else if (msg.length() == 12) {
                mode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (mode == ChecksumMode.CP_ADD) {
            if (msg.length() != 11) {
                throw new IllegalArgumentException("Message must be 11 characters long");
            }
            return msg + UPCALogicImpl.calcChecksum(msg);
        }
        if (mode == ChecksumMode.CP_CHECK) {
            char expected;
            if (msg.length() != 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            char check = msg.charAt(11);
            if (check != (expected = UPCALogicImpl.calcChecksum(msg.substring(0, 11)))) {
                throw new IllegalArgumentException("Checksum is bad (" + check + "). Expected: " + expected);
            }
            return msg;
        }
        if (mode == ChecksumMode.CP_IGNORE) {
            if (msg.length() != 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + mode);
    }

    private String handleChecksum(String msg) {
        return UPCALogicImpl.handleChecksum(msg, this.getChecksumMode());
    }

    @Override
    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        int i;
        String supp = UPCALogicImpl.retrieveSupplemental(msg);
        String s = UPCALogicImpl.removeSupplemental(msg);
        UPCALogicImpl.validateMessage(s);
        String canonicalMessage = s = this.handleChecksum(s);
        if (supp != null) {
            canonicalMessage = canonicalMessage + "+" + supp;
        }
        logic.startBarcode(canonicalMessage, canonicalMessage);
        this.drawSideGuard(logic);
        char lead = s.charAt(0);
        logic.startBarGroup(BarGroup.UPC_EAN_LEAD, Character.toString(lead));
        this.encodeChar(logic, lead, 0);
        logic.endBarGroup();
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.substring(1, 6));
        for (i = 1; i < 6; ++i) {
            this.encodeChar(logic, s.charAt(i), 0);
        }
        logic.endBarGroup();
        this.drawCenterGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.substring(6, 11));
        for (i = 6; i < 11; ++i) {
            this.encodeChar(logic, s.charAt(i), 2);
        }
        logic.endBarGroup();
        char check = s.charAt(11);
        logic.startBarGroup(BarGroup.UPC_EAN_CHECK, Character.toString(check));
        this.encodeChar(logic, check, 2);
        logic.endBarGroup();
        this.drawSideGuard(logic);
        if (supp != null) {
            this.drawSupplemental(logic, supp);
        }
        logic.endBarcode();
    }
}

