/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.qr;

import org.krysalis.barcode4j.impl.qr.QRConstants;

public class QRHighLevelEncoder
implements QRConstants {
    private final String msg;
    private final int encodingMode;

    public QRHighLevelEncoder(String msg) {
        this.msg = msg;
        this.encodingMode = this.analyzeMessage(msg);
    }

    private static final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static final boolean isAlphanumeric(char ch) {
        return ALPHANUMERIC_TABLE[ch] >= 0;
    }

    public int getEncodingMode() {
        return this.encodingMode;
    }

    private int analyzeMessage(String msg) {
        int mode = 0;
        int c = msg.length();
        for (int i = 0; i < c; ++i) {
            char ch = msg.charAt(i);
            if (QRHighLevelEncoder.isDigit(ch)) continue;
            if (mode == 0 && QRHighLevelEncoder.isAlphanumeric(ch)) {
                mode = 1;
                continue;
            }
            mode = 2;
            break;
        }
        return mode;
    }
}

